/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.FetchProfile;
import org.hibernate.metamodel.binding.TypeDef;
import org.hibernate.metamodel.relational.AuxiliaryDatabaseObject;
import org.hibernate.metamodel.relational.BasicAuxiliaryDatabaseObjectImpl;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.Origin;
import org.hibernate.metamodel.source.hbm.HbmBindingContext;
import org.hibernate.metamodel.source.hbm.HbmHelper;
import org.hibernate.metamodel.source.hbm.RootEntityBinder;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLFetchProfileElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLJoinedSubclassElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLParamElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLQueryElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlQueryElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSubclassElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLUnionSubclassElement;
import org.hibernate.metamodel.source.internal.JaxbRoot;
import org.hibernate.metamodel.source.internal.OverriddenMappingDefaults;
import org.hibernate.metamodel.source.spi.MappingDefaults;
import org.hibernate.metamodel.source.spi.MetaAttributeContext;
import org.hibernate.metamodel.source.spi.MetadataImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.classloading.spi.ClassLoadingException;
import org.hibernate.type.Type;

public class HibernateMappingProcessor
implements HbmBindingContext {
    private final MetadataImplementor metadata;
    private final JaxbRoot<XMLHibernateMapping> jaxbRoot;
    private final XMLHibernateMapping hibernateMapping;
    private final MappingDefaults mappingDefaults;
    private final MetaAttributeContext metaAttributeContext;
    private final boolean autoImport;
    private ClassLoaderService classLoaderService;

    public HibernateMappingProcessor(MetadataImplementor metadata, JaxbRoot<XMLHibernateMapping> jaxbRoot) {
        this.metadata = metadata;
        this.jaxbRoot = jaxbRoot;
        this.hibernateMapping = jaxbRoot.getRoot();
        this.mappingDefaults = new OverriddenMappingDefaults(metadata.getMappingDefaults(), this.hibernateMapping.getPackage(), this.hibernateMapping.getSchema(), this.hibernateMapping.getCatalog(), null, null, this.hibernateMapping.getDefaultCascade(), this.hibernateMapping.getDefaultAccess(), this.hibernateMapping.isDefaultLazy());
        this.autoImport = this.hibernateMapping.isAutoImport();
        this.metaAttributeContext = this.extractMetaAttributes();
    }

    private MetaAttributeContext extractMetaAttributes() {
        return this.hibernateMapping.getMeta() == null ? new MetaAttributeContext(this.metadata.getMetaAttributeContext()) : HbmHelper.extractMetaAttributeContext(this.hibernateMapping.getMeta(), true, this.metadata.getMetaAttributeContext());
    }

    @Override
    public boolean isAutoImport() {
        return this.autoImport;
    }

    @Override
    public Origin getOrigin() {
        return this.jaxbRoot.getOrigin();
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.metadata.getServiceRegistry();
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.metadata.getOptions().getNamingStrategy();
    }

    @Override
    public MappingDefaults getMappingDefaults() {
        return this.mappingDefaults;
    }

    @Override
    public MetaAttributeContext getMetaAttributeContext() {
        return this.metaAttributeContext;
    }

    @Override
    public MetadataImplementor getMetadataImplementor() {
        return this.metadata;
    }

    public void bindIndependentMetadata() {
        this.bindDatabaseObjectDefinitions();
        this.bindTypeDefinitions();
    }

    private void bindDatabaseObjectDefinitions() {
        if (this.hibernateMapping.getDatabaseObject() == null) {
            return;
        }
        for (XMLHibernateMapping.XMLDatabaseObject databaseObjectElement : this.hibernateMapping.getDatabaseObject()) {
            AuxiliaryDatabaseObject auxiliaryDatabaseObject;
            if (databaseObjectElement.getDefinition() != null) {
                String className = databaseObjectElement.getDefinition().getClazz();
                try {
                    auxiliaryDatabaseObject = (AuxiliaryDatabaseObject)this.classLoaderService().classForName(className).newInstance();
                }
                catch (ClassLoadingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MappingException("could not instantiate custom database object class [" + className + "]", this.jaxbRoot.getOrigin());
                }
            } else {
                HashSet<String> dialectScopes = new HashSet<String>();
                if (databaseObjectElement.getDialectScope() != null) {
                    for (XMLHibernateMapping.XMLDatabaseObject.XMLDialectScope dialectScope : databaseObjectElement.getDialectScope()) {
                        dialectScopes.add(dialectScope.getName());
                    }
                }
                auxiliaryDatabaseObject = new BasicAuxiliaryDatabaseObjectImpl(databaseObjectElement.getCreate(), databaseObjectElement.getDrop(), dialectScopes);
            }
            this.metadata.addAuxiliaryDatabaseObject(auxiliaryDatabaseObject);
        }
    }

    private void bindTypeDefinitions() {
        if (this.hibernateMapping.getTypedef() == null) {
            return;
        }
        for (XMLHibernateMapping.XMLTypedef typedef : this.hibernateMapping.getTypedef()) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (XMLParamElement paramElement : typedef.getParam()) {
                parameters.put(paramElement.getName(), paramElement.getValue());
            }
            this.metadata.addTypeDefinition(new TypeDef(typedef.getName(), typedef.getClazz(), parameters));
        }
    }

    public void bindTypeDependentMetadata() {
        this.bindFilterDefinitions();
        this.bindIdentifierGenerators();
    }

    private void bindFilterDefinitions() {
        if (this.hibernateMapping.getFilterDef() == null) {
            return;
        }
        for (XMLHibernateMapping.XMLFilterDef filterDefinition : this.hibernateMapping.getFilterDef()) {
            String name = filterDefinition.getName();
            HashMap<String, Type> parameters = new HashMap<String, Type>();
            String condition = null;
            for (Serializable o : filterDefinition.getContent()) {
                if (o instanceof String) {
                    if (condition != null) {
                        // empty if block
                    }
                    condition = (String)((Object)o);
                    continue;
                }
                if (o instanceof XMLHibernateMapping.XMLFilterDef.XMLFilterParam) {
                    XMLHibernateMapping.XMLFilterDef.XMLFilterParam paramElement = (XMLHibernateMapping.XMLFilterDef.XMLFilterParam)((Object)o);
                    parameters.put(paramElement.getName(), this.metadata.getTypeResolver().heuristicType(paramElement.getType()));
                    continue;
                }
                throw new MappingException("Unrecognized nested filter content", this.jaxbRoot.getOrigin());
            }
            if (condition == null) {
                condition = filterDefinition.getCondition();
            }
            this.metadata.addFilterDefinition(new FilterDefinition(name, condition, parameters));
        }
    }

    private void bindIdentifierGenerators() {
        if (this.hibernateMapping.getIdentifierGenerator() == null) {
            return;
        }
        for (XMLHibernateMapping.XMLIdentifierGenerator identifierGeneratorElement : this.hibernateMapping.getIdentifierGenerator()) {
            this.metadata.registerIdentifierGenerator(identifierGeneratorElement.getName(), identifierGeneratorElement.getClazz());
        }
    }

    public void bindMappingMetadata(List<String> processedEntityNames) {
        if (this.hibernateMapping.getClazzOrSubclassOrJoinedSubclass() == null) {
            return;
        }
        for (Object clazzOrSubclass : this.hibernateMapping.getClazzOrSubclassOrJoinedSubclass()) {
            if (XMLHibernateMapping.XMLClass.class.isInstance(clazzOrSubclass)) {
                XMLHibernateMapping.XMLClass clazz = (XMLHibernateMapping.XMLClass)XMLHibernateMapping.XMLClass.class.cast(clazzOrSubclass);
                new RootEntityBinder(this, clazz).process(clazz);
                continue;
            }
            if (XMLSubclassElement.class.isInstance(clazzOrSubclass) || XMLJoinedSubclassElement.class.isInstance(clazzOrSubclass) || XMLUnionSubclassElement.class.isInstance(clazzOrSubclass)) continue;
            throw new MappingException("unknown type of class or subclass: " + clazzOrSubclass.getClass().getName(), this.jaxbRoot.getOrigin());
        }
    }

    public void bindMappingDependentMetadata() {
        this.bindFetchProfiles();
        this.bindImports();
        this.bindResultSetMappings();
        this.bindNamedQueries();
    }

    private void bindFetchProfiles() {
        if (this.hibernateMapping.getFetchProfile() == null) {
            return;
        }
        this.bindFetchProfiles(this.hibernateMapping.getFetchProfile(), null);
    }

    @Override
    public void bindFetchProfiles(List<XMLFetchProfileElement> fetchProfiles, String containingEntityName) {
        for (XMLFetchProfileElement fetchProfile : fetchProfiles) {
            String profileName = fetchProfile.getName();
            HashSet<FetchProfile.Fetch> fetches = new HashSet<FetchProfile.Fetch>();
            for (XMLFetchProfileElement.XMLFetch fetch : fetchProfile.getFetch()) {
                String entityName;
                String string = entityName = fetch.getEntity() == null ? containingEntityName : fetch.getEntity();
                if (entityName == null) {
                    throw new MappingException("could not determine entity for fetch-profile fetch [" + profileName + "]:[" + fetch.getAssociation() + "]", this.jaxbRoot.getOrigin());
                }
                fetches.add(new FetchProfile.Fetch(entityName, fetch.getAssociation(), fetch.getStyle()));
            }
            this.metadata.addFetchProfile(new FetchProfile(profileName, fetches));
        }
    }

    private void bindImports() {
        if (this.hibernateMapping.getImport() == null) {
            return;
        }
        for (XMLHibernateMapping.XMLImport importValue : this.hibernateMapping.getImport()) {
            String className = this.getClassName(importValue.getClazz());
            String rename = importValue.getRename();
            rename = rename == null ? StringHelper.unqualify(className) : rename;
            this.metadata.addImport(className, rename);
        }
    }

    private void bindResultSetMappings() {
        if (this.hibernateMapping.getResultset() == null) {
            return;
        }
    }

    private void bindNamedQueries() {
        if (this.hibernateMapping.getQueryOrSqlQuery() == null) {
            return;
        }
        for (Object queryOrSqlQuery : this.hibernateMapping.getQueryOrSqlQuery()) {
            if (XMLQueryElement.class.isInstance(queryOrSqlQuery) || XMLSqlQueryElement.class.isInstance(queryOrSqlQuery)) continue;
            throw new MappingException("unknown type of query: " + queryOrSqlQuery.getClass().getName(), this.jaxbRoot.getOrigin());
        }
    }

    private ClassLoaderService classLoaderService() {
        if (this.classLoaderService == null) {
            this.classLoaderService = this.metadata.getServiceRegistry().getService(ClassLoaderService.class);
        }
        return this.classLoaderService;
    }

    @Override
    public String extractEntityName(XMLHibernateMapping.XMLClass entityClazz) {
        return HbmHelper.extractEntityName(entityClazz, this.mappingDefaults.getPackageName());
    }

    @Override
    public String getClassName(String unqualifiedName) {
        return HbmHelper.getClassName(unqualifiedName, this.mappingDefaults.getPackageName());
    }
}

