/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm.state.relational;

import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.metamodel.relational.Size;
import org.hibernate.metamodel.relational.state.ColumnRelationalState;
import org.hibernate.metamodel.source.hbm.state.relational.HbmSimpleValueRelationalStateContainer;
import org.hibernate.metamodel.source.hbm.util.MappingHelper;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLColumnElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLManyToOneElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLPropertyElement;

public class HbmColumnRelationalState
implements ColumnRelationalState {
    private final HbmSimpleValueRelationalStateContainer container;
    private final String explicitColumnName;
    private final Size size;
    private final boolean isNullable;
    private final boolean isUnique;
    private final String checkCondition;
    private final String defaultColumnValue;
    private final String sqlType;
    private final String customWrite;
    private final String customRead;
    private final String comment;
    private final Set<String> uniqueKeys;
    private final Set<String> indexes;

    HbmColumnRelationalState(XMLColumnElement columnElement, HbmSimpleValueRelationalStateContainer container) {
        this.container = container;
        this.explicitColumnName = columnElement.getName();
        this.size = HbmColumnRelationalState.createSize(columnElement.getLength(), columnElement.getScale(), columnElement.getPrecision());
        this.isNullable = !MappingHelper.getBooleanValue(columnElement.isNotNull(), true);
        this.isUnique = MappingHelper.getBooleanValue(columnElement.isUnique(), true);
        this.checkCondition = columnElement.getCheck();
        this.defaultColumnValue = columnElement.getDefault();
        this.sqlType = columnElement.getSqlType();
        this.customWrite = columnElement.getWrite();
        if (this.customWrite != null && !this.customWrite.matches("[^?]*\\?[^?]*")) {
            throw new MappingException("write expression must contain exactly one value placeholder ('?') character");
        }
        this.customRead = columnElement.getRead();
        this.comment = columnElement.getComment() == null ? null : columnElement.getComment().trim();
        this.uniqueKeys = MappingHelper.getStringValueTokens(columnElement.getUniqueKey(), ", ");
        this.uniqueKeys.addAll(container.getPropertyUniqueKeys());
        this.indexes = MappingHelper.getStringValueTokens(columnElement.getIndex(), ", ");
        this.indexes.addAll(container.getPropertyIndexes());
    }

    HbmColumnRelationalState(XMLPropertyElement property, HbmSimpleValueRelationalStateContainer container) {
        this.container = container;
        this.explicitColumnName = property.getName();
        this.size = HbmColumnRelationalState.createSize(property.getLength(), property.getScale(), property.getPrecision());
        this.isUnique = MappingHelper.getBooleanValue(property.isUnique(), true);
        this.isNullable = !MappingHelper.getBooleanValue(property.isNotNull(), true);
        this.checkCondition = null;
        this.defaultColumnValue = null;
        this.sqlType = null;
        this.customWrite = null;
        this.customRead = null;
        this.comment = null;
        this.uniqueKeys = MappingHelper.getStringValueTokens(property.getUniqueKey(), ", ");
        this.uniqueKeys.addAll(container.getPropertyUniqueKeys());
        this.indexes = MappingHelper.getStringValueTokens(property.getIndex(), ", ");
        this.indexes.addAll(container.getPropertyIndexes());
    }

    HbmColumnRelationalState(XMLManyToOneElement manyToOne, HbmSimpleValueRelationalStateContainer container) {
        this.container = container;
        this.explicitColumnName = manyToOne.getName();
        this.size = new Size();
        this.isNullable = !MappingHelper.getBooleanValue(manyToOne.isNotNull(), false);
        this.isUnique = manyToOne.isUnique();
        this.checkCondition = null;
        this.defaultColumnValue = null;
        this.sqlType = null;
        this.customWrite = null;
        this.customRead = null;
        this.comment = null;
        this.uniqueKeys = MappingHelper.getStringValueTokens(manyToOne.getUniqueKey(), ", ");
        this.uniqueKeys.addAll(container.getPropertyUniqueKeys());
        this.indexes = MappingHelper.getStringValueTokens(manyToOne.getIndex(), ", ");
        this.indexes.addAll(container.getPropertyIndexes());
    }

    HbmColumnRelationalState(XMLHibernateMapping.XMLClass.XMLId id, HbmSimpleValueRelationalStateContainer container) {
        if (id.getColumn() != null && !id.getColumn().isEmpty()) {
            throw new IllegalArgumentException("This method should not be called with non-empty id.getColumnElement()");
        }
        this.container = container;
        this.explicitColumnName = id.getName();
        this.size = HbmColumnRelationalState.createSize(id.getLength(), null, null);
        this.isNullable = false;
        this.isUnique = true;
        this.checkCondition = null;
        this.defaultColumnValue = null;
        this.sqlType = null;
        this.customWrite = null;
        this.customRead = null;
        this.comment = null;
        this.uniqueKeys = container.getPropertyUniqueKeys();
        this.indexes = container.getPropertyIndexes();
    }

    HbmColumnRelationalState(XMLHibernateMapping.XMLClass.XMLDiscriminator discriminator, HbmSimpleValueRelationalStateContainer container) {
        if (discriminator.getColumn() != null) {
            throw new IllegalArgumentException("This method should not be called with null discriminator.getColumnElement()");
        }
        this.container = container;
        this.explicitColumnName = null;
        this.size = HbmColumnRelationalState.createSize(discriminator.getLength(), null, null);
        this.isNullable = false;
        this.isUnique = true;
        this.checkCondition = null;
        this.defaultColumnValue = null;
        this.sqlType = null;
        this.customWrite = null;
        this.customRead = null;
        this.comment = null;
        this.uniqueKeys = container.getPropertyUniqueKeys();
        this.indexes = container.getPropertyIndexes();
    }

    HbmColumnRelationalState(XMLHibernateMapping.XMLClass.XMLVersion version, HbmSimpleValueRelationalStateContainer container) {
        this.container = container;
        this.explicitColumnName = version.getColumnAttribute();
        if (version.getColumn() != null && !version.getColumn().isEmpty()) {
            throw new IllegalArgumentException("This method should not be called with non-empty version.getColumnElement()");
        }
        this.size = new Size();
        this.isNullable = false;
        this.isUnique = false;
        this.checkCondition = null;
        this.defaultColumnValue = null;
        this.sqlType = null;
        this.customWrite = null;
        this.customRead = null;
        this.comment = null;
        this.uniqueKeys = container.getPropertyUniqueKeys();
        this.indexes = container.getPropertyIndexes();
    }

    HbmColumnRelationalState(XMLHibernateMapping.XMLClass.XMLTimestamp timestamp, HbmSimpleValueRelationalStateContainer container) {
        this.container = container;
        this.explicitColumnName = timestamp.getColumn();
        this.size = new Size();
        this.isNullable = false;
        this.isUnique = true;
        this.checkCondition = null;
        this.defaultColumnValue = null;
        this.sqlType = null;
        this.customWrite = null;
        this.customRead = null;
        this.comment = null;
        this.uniqueKeys = container.getPropertyUniqueKeys();
        this.indexes = container.getPropertyIndexes();
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.container.getNamingStrategy();
    }

    @Override
    public String getExplicitColumnName() {
        return this.explicitColumnName;
    }

    @Override
    public Size getSize() {
        return this.size;
    }

    protected static Size createSize(String length, String scale, String precision) {
        Size size = new Size();
        if (length != null) {
            size.setLength(Integer.parseInt(length));
        }
        if (scale != null) {
            size.setScale(Integer.parseInt(scale));
        }
        if (precision != null) {
            size.setPrecision(Integer.parseInt(precision));
        }
        return size;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public String getCheckCondition() {
        return this.checkCondition;
    }

    @Override
    public String getDefault() {
        return this.defaultColumnValue;
    }

    @Override
    public String getSqlType() {
        return this.sqlType;
    }

    @Override
    public String getCustomWriteFragment() {
        return this.customWrite;
    }

    @Override
    public String getCustomReadFragment() {
        return this.customRead;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public Set<String> getUniqueKeys() {
        return this.uniqueKeys;
    }

    @Override
    public Set<String> getIndexes() {
        return this.indexes;
    }
}

