/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.seam;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.jboss.jsfunit.framework.Environment;
import org.jboss.seam.Component;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.web.Session;

public class SeamUtil {
    private static final boolean isLog4JAvailable;

    private SeamUtil() {
    }

    public static boolean isSeamPresent() {
        Class lifecycle = SeamUtil.getSeamLifecycle();
        return lifecycle != null;
    }

    private static Class getSeamLifecycle() {
        return Environment.loadClass("org.jboss.seam.contexts.Lifecycle");
    }

    public static boolean isSeamInitialized() {
        Class lifecycle = SeamUtil.getSeamLifecycle();
        if (lifecycle == null) {
            return false;
        }
        try {
            Boolean returnVal = (Boolean)lifecycle.getMethod("isApplicationInitialized", null).invoke(null, null);
            return returnVal;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void invalidateSeamSession(HttpServletRequest httpServletRequest) {
        try {
            ServletLifecycle.beginRequest((HttpServletRequest)httpServletRequest);
            Session.instance().invalidate();
            ServletLifecycle.endRequest((HttpServletRequest)httpServletRequest);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to invalidate Seam session.", e);
        }
    }

    public static void suppressSeamComponentWarning() {
        if (isLog4JAvailable) {
            SeamUtil.supressLog4J();
        }
        SeamUtil.supressJUL();
    }

    private static void supressLog4J() {
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(Component.class);
        logger.setLevel(org.apache.log4j.Level.ERROR);
    }

    private static void supressJUL() {
        Logger logger = Logger.getLogger(Component.class.getName());
        logger.setLevel(Level.SEVERE);
    }

    static {
        boolean available;
        try {
            Class.forName("org.apache.log4j.Logger");
            available = true;
        }
        catch (ClassNotFoundException cnfe) {
            available = false;
        }
        isLog4JAvailable = available;
    }
}

