/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusterIdGenerator {
    private static Log log = LogFactory.getLog(ClusterIdGenerator.class);
    private final AtomicInteger versionCounter = new AtomicInteger();
    private final AtomicLong versionPrefix = new AtomicLong();
    private RankCalculator rankCalculator = new RankCalculator();

    public long newVersion(boolean isClustered) {
        if (isClustered && this.versionPrefix.get() == 0L) {
            throw new IllegalStateException("If clustered, Version prefix cannot be 0. Rank calculator probably not in use.");
        }
        long counter = this.versionCounter.incrementAndGet();
        if (isClustered) {
            return this.versionPrefix.get() | counter;
        }
        return counter;
    }

    public RankCalculator getRankCalculatorListener() {
        return this.rankCalculator;
    }

    void resetCounter() {
        this.versionCounter.compareAndSet(this.versionCounter.get(), 0);
    }

    private int findAddressRank(Address address, List<Address> members, int rank) {
        if (address.equals(members.get(0))) {
            return rank;
        }
        return this.findAddressRank(address, members.subList(1, members.size()), rank + 1);
    }

    @Listener
    public class RankCalculator {
        @ViewChanged
        public void calculateRank(ViewChangedEvent e) {
            long rank = this.calculateRank(e.getLocalAddress(), e.getNewMembers(), e.getViewId());
            if (log.isTraceEnabled()) {
                log.tracef("Calculated rank based on view %s and result was %d", e, rank);
            }
        }

        public long calculateRank(Address address, List<Address> members, long viewId) {
            long rank = ClusterIdGenerator.this.findAddressRank(address, members, 1);
            long newVersionPrefix = viewId << 48 | rank << 32;
            ClusterIdGenerator.this.versionPrefix.compareAndSet(ClusterIdGenerator.this.versionPrefix.get(), newVersionPrefix);
            return ClusterIdGenerator.this.versionPrefix.get();
        }
    }
}

