/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import org.h2.command.CommandInterface;
import org.h2.constant.SysProperties;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.util.New;

public class JdbcStatement
extends TraceObject
implements Statement {
    protected JdbcConnection conn;
    protected SessionInterface session;
    protected JdbcResultSet resultSet;
    protected int maxRows;
    protected int fetchSize = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
    protected int updateCount;
    protected final int resultSetType;
    protected final int resultSetConcurrency;
    protected boolean closedByResultSet;
    private CommandInterface executingCommand;
    private int lastExecutedCommandType;
    private ArrayList<String> batchCommands;
    private boolean escapeProcessing = true;

    JdbcStatement(JdbcConnection jdbcConnection, int n, int n2, int n3, boolean bl) {
        this.conn = jdbcConnection;
        this.session = jdbcConnection.getSession();
        this.setTrace(this.session.getTrace(), 8, n);
        this.resultSetType = n2;
        this.resultSetConcurrency = n3;
        this.closedByResultSet = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String string) throws SQLException {
        try {
            int n = this.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSet", 4, n, "executeQuery(" + this.quote(string) + ")");
            }
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                ResultInterface resultInterface;
                this.checkClosed();
                this.closeOldResultSet();
                string = this.conn.translateSQL(string, this.escapeProcessing);
                CommandInterface commandInterface = this.conn.prepareCommand(string, this.fetchSize);
                boolean bl = this.resultSetType != 1003;
                boolean bl2 = this.resultSetConcurrency == 1008;
                this.setExecutingStatement(commandInterface);
                try {
                    resultInterface = commandInterface.executeQuery(this.maxRows, bl);
                }
                finally {
                    this.setExecutingStatement(null);
                }
                commandInterface.close();
                this.resultSet = new JdbcResultSet(this.conn, this, resultInterface, n, this.closedByResultSet, bl, bl2);
            }
            return this.resultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate(String string) throws SQLException {
        try {
            this.debugCodeCall("executeUpdate", string);
            return this.executeUpdateInternal(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateInternal(String string) throws SQLException {
        this.checkClosedForWrite();
        try {
            this.closeOldResultSet();
            string = this.conn.translateSQL(string, this.escapeProcessing);
            CommandInterface commandInterface = this.conn.prepareCommand(string, this.fetchSize);
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                this.setExecutingStatement(commandInterface);
                try {
                    this.updateCount = commandInterface.executeUpdate();
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            commandInterface.close();
            int n = this.updateCount;
            return n;
        }
        finally {
            this.afterWriting();
        }
    }

    public boolean execute(String string) throws SQLException {
        try {
            this.debugCodeCall("execute", string);
            return this.executeInternal(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeInternal(String string) throws SQLException {
        int n = this.getNextId(4);
        this.checkClosedForWrite();
        try {
            boolean bl;
            this.closeOldResultSet();
            string = this.conn.translateSQL(string, this.escapeProcessing);
            CommandInterface commandInterface = this.conn.prepareCommand(string, this.fetchSize);
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                this.setExecutingStatement(commandInterface);
                try {
                    if (commandInterface.isQuery()) {
                        bl = true;
                        boolean bl2 = this.resultSetType != 1003;
                        boolean bl3 = this.resultSetConcurrency == 1008;
                        ResultInterface resultInterface = commandInterface.executeQuery(this.maxRows, bl2);
                        this.resultSet = new JdbcResultSet(this.conn, this, resultInterface, n, this.closedByResultSet, bl2, bl3);
                    } else {
                        bl = false;
                        this.updateCount = commandInterface.executeUpdate();
                    }
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            commandInterface.close();
            boolean bl4 = bl;
            return bl4;
        }
        finally {
            this.afterWriting();
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            this.checkClosed();
            if (this.resultSet != null) {
                int n = this.resultSet.getTraceId();
                this.debugCodeAssign("ResultSet", 4, n, "getResultSet()");
            } else {
                this.debugCodeCall("getResultSet");
            }
            return this.resultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            this.debugCodeCall("getUpdateCount");
            this.checkClosed();
            return this.updateCount;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                this.closeOldResultSet();
                if (this.conn != null) {
                    this.conn = null;
                }
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Connection getConnection() {
        this.debugCodeCall("getConnection");
        return this.conn;
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            this.debugCodeCall("getMoreResults");
            this.checkClosed();
            this.closeOldResultSet();
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setCursorName(String string) throws SQLException {
        try {
            this.debugCodeCall("setCursorName", string);
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        try {
            this.debugCodeCall("setFetchDirection", n);
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            this.debugCodeCall("getFetchDirection");
            this.checkClosed();
            return 1000;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            this.debugCodeCall("getMaxRows");
            this.checkClosed();
            return this.maxRows;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setMaxRows(int n) throws SQLException {
        try {
            this.debugCodeCall("setMaxRows", n);
            this.checkClosed();
            if (n < 0) {
                throw DbException.getInvalidValueException("" + n, "maxRows");
            }
            this.maxRows = n;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setFetchSize(int n) throws SQLException {
        try {
            this.debugCodeCall("setFetchSize", n);
            this.checkClosed();
            if (n < 0 || n > 0 && this.maxRows > 0 && n > this.maxRows) {
                throw DbException.getInvalidValueException("" + n, "rows");
            }
            if (n == 0) {
                n = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
            }
            this.fetchSize = n;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            this.debugCodeCall("getFetchSize");
            this.checkClosed();
            return this.fetchSize;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            this.debugCodeCall("getResultSetConcurrency");
            this.checkClosed();
            return this.resultSetConcurrency;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            this.debugCodeCall("getResultSetType");
            this.checkClosed();
            return this.resultSetType;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            this.debugCodeCall("getMaxFieldSize");
            this.checkClosed();
            return 0;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setMaxFieldSize(int n) throws SQLException {
        try {
            this.debugCodeCall("setMaxFieldSize", n);
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setEscapeProcessing(" + bl + ");");
            }
            this.checkClosed();
            this.escapeProcessing = bl;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws SQLException {
        try {
            this.debugCodeCall("cancel");
            this.checkClosed();
            CommandInterface commandInterface = this.executingCommand;
            try {
                if (commandInterface != null) {
                    commandInterface.cancel();
                }
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            this.debugCodeCall("getQueryTimeout");
            this.checkClosed();
            return this.conn.getQueryTimeout();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        try {
            this.debugCodeCall("setQueryTimeout", n);
            this.checkClosed();
            if (n < 0) {
                throw DbException.getInvalidValueException("" + n, "seconds");
            }
            this.conn.setQueryTimeout(n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void addBatch(String string) throws SQLException {
        try {
            this.debugCodeCall("addBatch", string);
            this.checkClosed();
            string = this.conn.translateSQL(string, this.escapeProcessing);
            if (this.batchCommands == null) {
                this.batchCommands = New.arrayList();
            }
            this.batchCommands.add(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.debugCodeCall("clearBatch");
            this.checkClosed();
            this.batchCommands = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        this.debugCodeCall("executeBatch");
        this.checkClosedForWrite();
        try {
            if (this.batchCommands == null) {
                this.batchCommands = New.arrayList();
            }
            int n = this.batchCommands.size();
            int[] nArray = new int[n];
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                String string = this.batchCommands.get(i);
                try {
                    nArray[i] = this.executeUpdateInternal(string);
                    continue;
                }
                catch (Exception exception) {
                    this.logAndConvert(exception);
                    nArray[i] = -3;
                    bl = true;
                }
            }
            this.batchCommands = null;
            if (bl) {
                throw new BatchUpdateException(nArray);
            }
            int[] nArray2 = nArray;
            this.afterWriting();
            return nArray2;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            int n = this.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSet", 4, n, "getGeneratedKeys()");
            }
            this.checkClosed();
            return this.conn.getGeneratedKeys(this, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean getMoreResults(int n) throws SQLException {
        try {
            this.debugCodeCall("getMoreResults", n);
            switch (n) {
                case 1: 
                case 3: {
                    if (this.resultSet == null) break;
                    this.resultSet.close();
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw DbException.getInvalidValueException("" + n, "current");
                }
            }
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate(String string, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + this.quote(string) + ", " + n + ");");
            }
            return this.executeUpdateInternal(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + this.quote(string) + ", " + this.quoteIntArray(nArray) + ");");
            }
            return this.executeUpdateInternal(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + this.quote(string) + ", " + this.quoteArray(stringArray) + ");");
            }
            return this.executeUpdateInternal(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + this.quote(string) + ", " + n + ");");
            }
            return this.executeInternal(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + this.quote(string) + ", " + this.quoteIntArray(nArray) + ");");
            }
            return this.executeInternal(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + this.quote(string) + ", " + this.quoteArray(stringArray) + ");");
            }
            return this.executeInternal(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getResultSetHoldability() throws SQLException {
        try {
            this.debugCodeCall("getResultSetHoldability");
            this.checkClosed();
            return 1;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    boolean checkClosed() throws SQLException {
        return this.checkClosed(false);
    }

    boolean checkClosedForWrite() throws SQLException {
        return this.checkClosed(true);
    }

    protected boolean checkClosed(boolean bl) throws SQLException {
        if (this.conn == null) {
            throw DbException.get(90007);
        }
        this.conn.checkClosed(bl);
        SessionInterface sessionInterface = this.conn.getSession();
        if (sessionInterface != this.session) {
            this.session = sessionInterface;
            this.setTrace(this.session.getTrace());
            return true;
        }
        return false;
    }

    void afterWriting() {
        if (this.conn != null) {
            this.conn.afterWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeOldResultSet() throws SQLException {
        try {
            if (!this.closedByResultSet && this.resultSet != null) {
                this.resultSet.closeInternal();
            }
        }
        finally {
            this.resultSet = null;
            this.updateCount = -1;
        }
    }

    protected void setExecutingStatement(CommandInterface commandInterface) {
        if (commandInterface == null) {
            this.conn.setExecutingStatement(null);
        } else {
            this.conn.setExecutingStatement(this);
            this.lastExecutedCommandType = commandInterface.getCommandType();
        }
        this.executingCommand = commandInterface;
    }

    public int getLastExecutedCommandType() {
        return this.lastExecutedCommandType;
    }

    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.conn == null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isPoolable() {
        this.debugCodeCall("isPoolable");
        return false;
    }

    public void setPoolable(boolean bl) {
        if (this.isDebugEnabled()) {
            this.debugCode("setPoolable(" + bl + ");");
        }
    }

    public String toString() {
        return this.getTraceObjectName();
    }
}

