/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.jar.Manifest;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.osgi.spi.util.BundleInfo;

public class OSGiManifestStructureProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (deploymentRoot == null) {
            return;
        }
        Manifest manifest = (Manifest)deploymentUnit.getAttachment(Attachments.OSGI_MANIFEST);
        if (manifest != null) {
            return;
        }
        Boolean ignore = (Boolean)deploymentUnit.getAttachment(Attachments.IGNORE_OSGI);
        if (ignore != null && ignore.booleanValue()) {
            return;
        }
        manifest = (Manifest)deploymentRoot.getAttachment(Attachments.MANIFEST);
        if (BundleInfo.isValidBundleManifest((Manifest)manifest)) {
            deploymentUnit.putAttachment(Attachments.OSGI_MANIFEST, (Object)manifest);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(Attachments.OSGI_MANIFEST);
    }
}

