/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.osgi.deployment.OSGiMetaDataAttachment;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.vfs.VirtualFile;

public class OSGiXServiceParseProcessor
implements DeploymentUnitProcessor {
    public static final String XSERVICE_PROPERTIES_NAME = "META-INF/jbosgi-xservice.properties";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        OSGiMetaData metadata = OSGiMetaDataAttachment.getOSGiMetaData(deploymentUnit);
        if (metadata != null) {
            return;
        }
        VirtualFile virtualFile = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        VirtualFile xserviceFile = virtualFile.getChild(XSERVICE_PROPERTIES_NAME);
        if (!xserviceFile.exists()) {
            return;
        }
        try {
            metadata = OSGiMetaDataBuilder.load((InputStream)xserviceFile.openStream());
            OSGiMetaDataAttachment.attachOSGiMetaData(deploymentUnit, metadata);
        }
        catch (IOException ex) {
            throw new DeploymentUnitProcessingException("Cannot parse: " + xserviceFile);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        OSGiMetaDataAttachment.detachOSGiMetaData(deploymentUnit);
    }
}

