/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.EscapeSelector;
import org.jboss.as.cli.SecurityActions;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class Util {
    public static boolean isWindows() {
        return SecurityActions.getSystemProperty("os.name").toLowerCase().indexOf("windows") >= 0;
    }

    public static boolean isSuccess(ModelNode operationResult) {
        if (operationResult != null) {
            ModelNode outcome = operationResult.get("outcome");
            return outcome != null && outcome.asString().equals("success");
        }
        return false;
    }

    public static String getFailureDescription(ModelNode operationResult) {
        if (operationResult == null) {
            return null;
        }
        ModelNode descr = operationResult.get("failure-description");
        if (descr == null) {
            return null;
        }
        return descr.asString();
    }

    public static List<String> getList(ModelNode operationResult) {
        if (!operationResult.hasDefined("result")) {
            return Collections.emptyList();
        }
        List nodeList = operationResult.get("result").asList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(nodeList.size());
        for (ModelNode node : nodeList) {
            list.add(node.asString());
        }
        return list;
    }

    public static boolean listContains(ModelNode operationResult, String item) {
        if (!operationResult.hasDefined("result")) {
            return false;
        }
        List nodeList = operationResult.get("result").asList();
        if (nodeList.isEmpty()) {
            return false;
        }
        for (ModelNode node : nodeList) {
            if (!node.asString().equals(item)) continue;
            return true;
        }
        return false;
    }

    public static byte[] getHash(ModelNode operationResult) {
        if (!operationResult.hasDefined("result")) {
            return null;
        }
        return operationResult.get("result").asBytes();
    }

    public static List<String> getRequestPropertyNames(ModelNode operationResult) {
        if (!operationResult.hasDefined("result")) {
            return Collections.emptyList();
        }
        ModelNode result = operationResult.get("result");
        if (!result.hasDefined("request-properties")) {
            return Collections.emptyList();
        }
        List nodeList = result.get("request-properties").asPropertyList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(nodeList.size());
        for (Property node : nodeList) {
            list.add(node.getName());
        }
        return list;
    }

    public static boolean isDeploymentInRepository(String name, ModelControllerClient client) {
        return Util.getDeployments(client).contains(name);
    }

    public static boolean isDeployedAndEnabledInStandalone(String name, ModelControllerClient client) {
        ModelNode outcome;
        ModelNode request;
        DefaultOperationRequestBuilder builder;
        block12: {
            builder = new DefaultOperationRequestBuilder();
            try {
                builder.operationName("read-children-names");
                builder.addProperty("child-type", "deployment");
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            try {
                outcome = client.execute(request);
                if (Util.isSuccess(outcome)) {
                    if (!Util.listContains(outcome, name)) {
                        return false;
                    }
                    break block12;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        builder = new DefaultOperationRequestBuilder();
        builder.addNode("deployment", name);
        builder.setOperationName("read-attribute");
        builder.addProperty("name", "enabled");
        try {
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                if (!outcome.hasDefined("result")) {
                    return false;
                }
                return outcome.get("result").asBoolean();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public static List<String> getAllEnabledServerGroups(String deploymentName, ModelControllerClient client) {
        List<String> serverGroups = Util.getServerGroups(client);
        if (serverGroups.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String serverGroup : serverGroups) {
            ModelNode outcome;
            ModelNode request;
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            try {
                builder.operationName("read-children-names");
                builder.addNode("server-group", serverGroup);
                builder.addProperty("child-type", "deployment");
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            try {
                outcome = client.execute(request);
                if (!Util.isSuccess(outcome)) continue;
                if (!Util.listContains(outcome, deploymentName)) {
                }
            }
            catch (Exception e) {}
            continue;
            builder = new DefaultOperationRequestBuilder();
            builder.addNode("server-group", serverGroup);
            builder.addNode("deployment", deploymentName);
            builder.setOperationName("read-attribute");
            builder.addProperty("name", "enabled");
            try {
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            try {
                outcome = client.execute(request);
                if (!Util.isSuccess(outcome) || !outcome.hasDefined("result") || !outcome.get("result").asBoolean()) continue;
                result.add(serverGroup);
            }
            catch (Exception e) {}
        }
        return result;
    }

    public static List<String> getAllReferencingServerGroups(String deploymentName, ModelControllerClient client) {
        List<String> serverGroups = Util.getServerGroups(client);
        if (serverGroups.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String serverGroup : serverGroups) {
            ModelNode request;
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            try {
                builder.operationName("read-children-names");
                builder.addNode("server-group", serverGroup);
                builder.addProperty("child-type", "deployment");
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            try {
                ModelNode outcome = client.execute(request);
                if (!Util.isSuccess(outcome) || !Util.listContains(outcome, deploymentName)) continue;
                result.add(serverGroup);
            }
            catch (Exception e) {}
        }
        return result;
    }

    public static List<String> getDeployments(ModelControllerClient client) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.operationName("read-children-names");
            builder.addProperty("child-type", "deployment");
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                return Util.getList(outcome);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static List<String> getServerGroups(ModelControllerClient client) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.operationName("read-children-names");
            builder.addProperty("child-type", "server-group");
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                return Util.getList(outcome);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static List<String> getNodeTypes(ModelControllerClient client, OperationRequestAddress address) {
        List<String> result;
        ModelNode request;
        if (client == null) {
            return Collections.emptyList();
        }
        if (address.endsOnType()) {
            throw new IllegalArgumentException("The prefix isn't expected to end on a type.");
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(address);
        try {
            builder.operationName("read-children-types");
            request = builder.buildRequest();
        }
        catch (OperationFormatException e1) {
            throw new IllegalStateException("Failed to build operation", e1);
        }
        try {
            ModelNode outcome = client.execute(request);
            result = !Util.isSuccess(outcome) ? Collections.emptyList() : Util.getList(outcome);
        }
        catch (Exception e) {
            result = Collections.emptyList();
        }
        return result;
    }

    public static List<String> getNodeNames(ModelControllerClient client, OperationRequestAddress address, String type) {
        List<String> result;
        ModelNode request;
        if (client == null) {
            return Collections.emptyList();
        }
        if (address != null && address.endsOnType()) {
            throw new IllegalArgumentException("The address isn't expected to end on a type.");
        }
        DefaultOperationRequestBuilder builder = address == null ? new DefaultOperationRequestBuilder() : new DefaultOperationRequestBuilder(address);
        try {
            builder.operationName("read-children-names");
            builder.addProperty("child-type", type);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e1) {
            throw new IllegalStateException("Failed to build operation", e1);
        }
        try {
            ModelNode outcome = client.execute(request);
            result = !Util.isSuccess(outcome) ? Collections.emptyList() : Util.getList(outcome);
        }
        catch (Exception e) {
            result = Collections.emptyList();
        }
        return result;
    }

    public static List<String> getJmsResources(ModelControllerClient client, String profile, String type) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            if (profile != null) {
                builder.addNode("profile", profile);
            }
            builder.addNode("subsystem", "messaging");
            builder.operationName("read-children-names");
            builder.addProperty("child-type", type);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                return Util.getList(outcome);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static List<String> getDatasources(ModelControllerClient client, String profile, String dsType) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            if (profile != null) {
                builder.addNode("profile", profile);
            }
            builder.addNode("subsystem", "datasources");
            builder.operationName("read-children-names");
            builder.addProperty("child-type", dsType);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                return Util.getList(outcome);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static boolean isTopic(ModelControllerClient client, String name) {
        List<String> topics = Util.getJmsResources(client, null, "jms-topic");
        return topics.contains(name);
    }

    public static boolean isQueue(ModelControllerClient client, String name) {
        List<String> queues = Util.getJmsResources(client, null, "jms-queue");
        return queues.contains(name);
    }

    public static boolean isConnectionFactory(ModelControllerClient client, String name) {
        List<String> cf = Util.getJmsResources(client, null, "connection-factory");
        return cf.contains(name);
    }

    public static ModelNode configureDeploymentOperation(String operationName, String uniqueName, String serverGroup) {
        ModelNode op = new ModelNode();
        op.get("operation").set(operationName);
        if (serverGroup != null) {
            op.get("address").add("server-group", serverGroup);
        }
        op.get("address").add("deployment", uniqueName);
        return op;
    }

    public static String getCommonStart(List<String> list) {
        int size = list.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return list.get(0);
        }
        String first = list.get(0);
        String last = list.get(size - 1);
        int minSize = Math.min(first.length(), last.length());
        for (int i = 0; i < minSize; ++i) {
            if (first.charAt(i) == last.charAt(i)) continue;
            if (i == 0) {
                return null;
            }
            return first.substring(0, i);
        }
        return first.substring(0, minSize);
    }

    public static String escapeString(String name, EscapeSelector selector) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!selector.isEscape(ch)) continue;
            StringBuilder builder = new StringBuilder();
            builder.append(name, 0, i);
            builder.append('\\').append(ch);
            for (int j = i + 1; j < name.length(); ++j) {
                ch = name.charAt(j);
                if (selector.isEscape(ch)) {
                    builder.append('\\');
                }
                builder.append(ch);
            }
            return builder.toString();
        }
        return name;
    }

    public static void sortAndEscape(List<String> candidates, EscapeSelector selector) {
        Collections.sort(candidates);
        String common = Util.getCommonStart(candidates);
        if (common != null) {
            String escapedCommon = Util.escapeString(common, selector);
            if (common.length() != escapedCommon.length()) {
                for (int i = 0; i < candidates.size(); ++i) {
                    candidates.set(i, escapedCommon + candidates.get(i).substring(common.length()));
                }
            }
        }
    }

    public static void setRequestProperty(ModelNode request, String name, String value) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument name is not specified: '" + name + "'");
        }
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument value is not specified: '" + value + "'");
        }
        ModelNode toSet = null;
        try {
            toSet = ModelNode.fromString((String)value);
        }
        catch (Exception e) {
            toSet = new ModelNode().set(value);
        }
        request.get(name).set(toSet);
    }
}

