/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.HashSet;
import java.util.List;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.JMSTopicService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class JMSTopicAdd
extends AbstractAddStepHandler {
    public static final String OPERATION_NAME = "add";
    public static final JMSTopicAdd INSTANCE = new JMSTopicAdd();
    private static final String[] NO_BINDINGS = new String[0];

    public static ModelNode getOperation(ModelNode address, ModelNode existing) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        if (existing.hasDefined("entries")) {
            op.get("entries").set(existing.get("entries"));
        }
        return op;
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        if (operation.hasDefined("entries")) {
            model.get("entries").set(operation.get("entries"));
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        JMSTopicService service = new JMSTopicService(name, JMSTopicAdd.jndiBindings(operation));
        ServiceName serviceName = JMSServices.JMS_TOPIC_BASE.append(new String[]{name});
        newControllers.add(context.getServiceTarget().addService(serviceName, (Service)service).addDependency(JMSServices.JMS_MANAGER, JMSServerManager.class, service.getJmsServer()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
    }

    static String[] jndiBindings(ModelNode node) {
        if (node.hasDefined("entries")) {
            HashSet<String> bindings = new HashSet<String>();
            for (ModelNode entry : node.get("entries").asList()) {
                bindings.add(entry.asString());
            }
            return bindings.toArray(new String[bindings.size()]);
        }
        return NO_BINDINGS;
    }
}

