/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.deployer;

import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.internal.NullFileDeployment;
import org.jboss.osgi.deployment.internal.VirtualFileDeployment;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Version;

public class DeploymentFactory {
    private DeploymentFactory() {
    }

    public static Deployment createDeployment(BundleInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Null info");
        }
        return new VirtualFileDeployment(info.getRoot(), info.getLocation(), info.getSymbolicName(), info.getVersion());
    }

    public static Deployment createDeployment(VirtualFile rootFile, String location, String symbolicName, Version version) {
        return new VirtualFileDeployment(rootFile, location, symbolicName, version);
    }

    public static Deployment createDeployment(String location, String symbolicName, Version version) {
        return new NullFileDeployment(location, symbolicName, version);
    }
}

