/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jboss.as.clustering.MarshalledValue;
import org.jboss.as.clustering.MarshallingContext;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.Unmarshaller;

public class SimpleMarshalledValue<T>
implements MarshalledValue<T, MarshallingContext> {
    private static final long serialVersionUID = -8852566958387608376L;
    private transient MarshallingContext context;
    private transient T object;
    private transient byte[] bytes;

    public SimpleMarshalledValue(T object, MarshallingContext context) {
        this.context = context;
        this.object = object;
    }

    T peek() {
        return this.object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized byte[] getBytes() throws IOException {
        if (this.bytes != null) {
            return this.bytes;
        }
        if (this.object == null) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Marshaller marshaller = this.context.createMarshaller();
        try {
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeObject(this.object);
            marshaller.finish();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            marshaller.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized T get(MarshallingContext context) throws IOException, ClassNotFoundException {
        if (this.object == null) {
            this.context = context;
            if (this.bytes != null) {
                Unmarshaller unmarshaller = context.createUnmarshaller();
                try {
                    unmarshaller.start(Marshalling.createByteInput((ByteBuffer)ByteBuffer.wrap(this.bytes)));
                    this.object = unmarshaller.readObject();
                    unmarshaller.finish();
                    this.bytes = null;
                }
                finally {
                    unmarshaller.close();
                }
            }
        }
        return this.object;
    }

    public synchronized int hashCode() {
        return this.object != null ? this.object.hashCode() : 0;
    }

    public synchronized boolean equals(Object object) {
        if (object == null || !(object instanceof SimpleMarshalledValue)) {
            return false;
        }
        SimpleMarshalledValue value = (SimpleMarshalledValue)object;
        if (this.object != null && value.object != null) {
            return this.object.equals(value.object);
        }
        try {
            byte[] us = this.getBytes();
            byte[] them = value.getBytes();
            return us != null && them != null ? Arrays.equals(us, them) : us == them;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized String toString() {
        return this.object != null ? this.object.toString() : (this.bytes != null ? this.bytes.toString() : null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int size = in.readInt();
        if (size > 0) {
            this.bytes = new byte[size];
            in.read(this.bytes, 0, size);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.bytes = this.getBytes();
        if (this.bytes != null) {
            out.writeInt(this.bytes.length);
            out.write(this.bytes);
        } else {
            out.writeInt(0);
        }
    }
}

