/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.pool.infinite;

import java.util.LinkedList;
import java.util.List;
import org.jboss.ejb3.pool.AbstractPool;
import org.jboss.ejb3.pool.StatelessObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfinitePool<T>
extends AbstractPool<T> {
    private List<T> active = new LinkedList<T>();
    private int size;

    public InfinitePool(StatelessObjectFactory<T> factory) {
        super(factory);
    }

    @Override
    public void discard(T obj) {
        throw new RuntimeException("NYI");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object obj = this.create();
        List<T> list = this.active;
        synchronized (list) {
            this.active.add(obj);
            this.size = this.active.size();
        }
        return obj;
    }

    @Override
    public int getAvailableCount() {
        return -1;
    }

    @Override
    public int getCurrentSize() {
        return this.size;
    }

    @Override
    public int getMaxSize() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(T obj) {
        List<T> list = this.active;
        synchronized (list) {
            boolean contains = this.active.remove(obj);
            if (!contains) {
                throw new IllegalArgumentException(obj + " is not of this pool");
            }
        }
        this.destroy(obj);
    }

    @Override
    public void setMaxSize(int maxSize) {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        for (T obj : this.active) {
            this.destroy(obj);
        }
        this.active.clear();
        this.size = 0;
    }
}

