/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.lang.reflect.Constructor;
import java.util.List;
import javax.persistence.spi.PersistenceProvider;
import org.jboss.as.jpa.persistenceprovider.PersistenceProviderResolverImpl;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class PersistenceProviderProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.jpa");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServicesAttachment servicesAttachment = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        if (module != null && servicesAttachment != null) {
            ModuleClassLoader classLoader = module.getClassLoader();
            List providerNames = servicesAttachment.getServiceImplementations(PersistenceProvider.class.getName());
            for (String providerName : providerNames) {
                try {
                    Class<PersistenceProvider> providerClass = classLoader.loadClass(providerName).asSubclass(PersistenceProvider.class);
                    Constructor<PersistenceProvider> constructor = providerClass.getConstructor(new Class[0]);
                    PersistenceProvider provider = constructor.newInstance(new Object[0]);
                    log.infof("Deploying Persistence Provider %s ", providerClass);
                    phaseContext.getServiceTarget().addService(ServiceName.JBOSS.append(new String[]{"persistenceprovider", providerName}), (Service)new ValueService((Value)new ImmediateValue((Object)provider))).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    PersistenceProviderResolverImpl.getInstance().addPersistenceProvider(provider);
                }
                catch (Exception e) {
                    log.warnf("Unable to instantiate persistence provider class \"%s\": %s", (Object)providerName, (Object)e);
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

