/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.security.RemotingPermission;
import org.xnio.OptionMap;

public final class Remoting {
    private static final RemotingPermission CREATE_ENDPOINT_PERM = new RemotingPermission("createEndpoint");

    public static Endpoint createEndpoint(String endpointName, Executor executor, OptionMap optionMap) throws IOException {
        if (endpointName == null) {
            throw new NullPointerException("endpointName is null");
        }
        if (optionMap == null) {
            throw new NullPointerException("optionMap is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_ENDPOINT_PERM);
        }
        EndpointImpl endpoint = new EndpointImpl(executor, endpointName, optionMap);
        return endpoint;
    }

    private Remoting() {
    }
}

