/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.remote.IntIndexer;
import org.jboss.remoting3.remote.RemoteConnectionChannel;
import org.jboss.remoting3.remote.RemoteLogger;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.channels.Channels;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.SuspendableWriteChannel;
import org.xnio.channels.WritableMessageChannel;
import org.xnio.streams.BufferPipeOutputStream;

final class OutboundMessage
extends MessageOutputStream {
    final short messageId;
    final RemoteConnectionChannel channel;
    final BufferPipeOutputStream pipeOutputStream;
    final int maximumWindow;
    int window;
    boolean closed;
    boolean cancelled;
    final BufferPipeOutputStream.BufferWriter bufferWriter = new BufferPipeOutputStream.BufferWriter(){

        public Pooled<ByteBuffer> getBuffer(boolean firstBuffer) throws IOException {
            Pooled<ByteBuffer> pooled = OutboundMessage.this.allocate((byte)48);
            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
            buffer.limit(buffer.limit() - 4);
            buffer.put(firstBuffer ? (byte)2 : 0);
            int windowPlusHeader = OutboundMessage.this.maximumWindow + 8;
            if (buffer.remaining() > windowPlusHeader) {
                buffer.limit(windowPlusHeader);
            }
            return pooled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept(Pooled<ByteBuffer> pooledBuffer, boolean eof) throws IOException {
            try {
                ByteBuffer buffer = (ByteBuffer)pooledBuffer.getResource();
                ConnectedMessageChannel messageChannel = OutboundMessage.this.channel.getConnection().getChannel();
                if (eof) {
                    buffer.put(7, (byte)(buffer.get(7) | 1));
                    RemoteLogger.log.tracef("Sending message (with EOF) (%s) to %s", buffer, messageChannel);
                }
                if (OutboundMessage.this.cancelled) {
                    buffer.put(7, (byte)(buffer.get(7) | 4));
                    buffer.limit(8);
                    RemoteLogger.log.trace("Message includes cancel flag");
                }
                OutboundMessage outboundMessage = OutboundMessage.this;
                synchronized (outboundMessage) {
                    int msgSize = buffer.remaining();
                    OutboundMessage.this.window -= msgSize;
                    while (OutboundMessage.this.window < msgSize) {
                        try {
                            RemoteLogger.log.trace("Message window is closed, waiting");
                            OutboundMessage.this.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException("Interrupted on write");
                        }
                    }
                    RemoteLogger.log.trace("Message window is open, proceeding with send");
                }
                Channels.sendBlocking((WritableMessageChannel)messageChannel, (ByteBuffer)buffer);
            }
            finally {
                pooledBuffer.free();
                if (eof) {
                    OutboundMessage.this.channel.freeOutboundMessage(OutboundMessage.this.messageId);
                }
            }
        }

        public void flush() throws IOException {
            RemoteLogger.log.trace("Flushing message channel");
            Channels.flushBlocking((SuspendableWriteChannel)OutboundMessage.this.channel.getConnection().getChannel());
        }
    };
    static final IntIndexer<OutboundMessage> INDEXER = new IntIndexer<OutboundMessage>(){

        @Override
        public int indexOf(OutboundMessage argument) {
            return argument.messageId & 0xFFFF;
        }

        @Override
        public boolean equals(OutboundMessage argument, int index) {
            return (argument.messageId & 0xFFFF) == index;
        }
    };

    OutboundMessage(short messageId, RemoteConnectionChannel channel, int window) {
        this.messageId = messageId;
        this.channel = channel;
        this.window = this.maximumWindow = window;
        try {
            this.pipeOutputStream = new BufferPipeOutputStream(this.bufferWriter);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    Pooled<ByteBuffer> allocate(byte protoId) {
        Pooled<ByteBuffer> pooled = this.channel.allocate(protoId);
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        buffer.putShort(this.messageId);
        return pooled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledge(int count) {
        OutboundMessage outboundMessage = this;
        synchronized (outboundMessage) {
            if (RemoteLogger.log.isTraceEnabled()) {
                RemoteLogger.log.tracef("Acknowledged %d bytes on %s", count, this);
            }
            this.window += count;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncClose() {
        IoUtils.safeClose((Closeable)this.pipeOutputStream);
        this.channel.free(this);
        OutboundMessage outboundMessage = this;
        synchronized (outboundMessage) {
            this.closed = true;
            this.notifyAll();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.pipeOutputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.pipeOutputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.pipeOutputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.pipeOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.pipeOutputStream.close();
        this.channel.free(this);
    }

    @Override
    public MessageOutputStream cancel() {
        this.cancelled = true;
        IoUtils.safeClose((Closeable)this.pipeOutputStream);
        return this;
    }
}

