/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.Executor;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.remote.InboundMessage;
import org.jboss.remoting3.remote.IntIndexer;
import org.jboss.remoting3.remote.OutboundMessage;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.remote.UnlockedReadIntIndexHashMap;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.xnio.Pooled;
import org.xnio.channels.Channels;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.SuspendableWriteChannel;
import org.xnio.channels.WritableMessageChannel;

final class RemoteConnectionChannel
extends AbstractHandleableCloseable<Channel>
implements Channel {
    static final IntIndexer<RemoteConnectionChannel> INDEXER = new IntIndexer<RemoteConnectionChannel>(){

        @Override
        public int indexOf(RemoteConnectionChannel argument) {
            return argument.channelId;
        }

        @Override
        public boolean equals(RemoteConnectionChannel argument, int index) {
            return argument.channelId == index;
        }
    };
    private final RemoteConnection connection;
    private final int channelId;
    private final UnlockedReadIntIndexHashMap<OutboundMessage> outboundMessages = new UnlockedReadIntIndexHashMap<OutboundMessage>(OutboundMessage.INDEXER);
    private final UnlockedReadIntIndexHashMap<InboundMessage> inboundMessages = new UnlockedReadIntIndexHashMap<InboundMessage>(InboundMessage.INDEXER);
    private final Random random;
    private final int outboundWindow;
    private final int inboundWindow;
    private final Attachments attachments = new Attachments();
    private final Queue<InboundMessage> inboundMessageQueue = new ArrayDeque<InboundMessage>();
    private Channel.Receiver nextReceiver;
    private int outboundMessageCount;
    private boolean writeClosed;
    private boolean readClosed;

    RemoteConnectionChannel(Executor executor, RemoteConnection connection, int channelId, Random random, int outboundWindow, int inboundWindow, int outboundMessageCount, int inboundMessageCount) {
        super(executor);
        this.connection = connection;
        this.channelId = channelId;
        this.random = random;
        this.outboundWindow = outboundWindow;
        this.inboundWindow = inboundWindow;
        this.outboundMessageCount = outboundMessageCount;
    }

    @Override
    public MessageOutputStream writeMessage() throws IOException {
        int tries = 50;
        UnlockedReadIntIndexHashMap<OutboundMessage> outboundMessages = this.outboundMessages;
        RemoteConnection remoteConnection = this.connection;
        synchronized (remoteConnection) {
            int messageCount;
            if (this.writeClosed) {
                throw RemoteLogger.log.channelNotOpen();
            }
            while ((messageCount = this.outboundMessageCount) == 0) {
                try {
                    this.connection.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw RemoteLogger.log.writeInterrupted();
                }
            }
            Random random = this.random;
            while (tries > 0) {
                int id = random.nextInt() & 0xFFFE;
                if (!outboundMessages.containsKey(id)) {
                    OutboundMessage message = new OutboundMessage((short)id, this, this.outboundWindow);
                    outboundMessages.put(message);
                    this.outboundMessageCount = messageCount - 1;
                    return message;
                }
                --tries;
            }
            throw RemoteLogger.log.channelBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(OutboundMessage outboundMessage) {
        RemoteConnection remoteConnection = this.connection;
        synchronized (remoteConnection) {
            this.outboundMessages.remove(outboundMessage);
            ++this.outboundMessageCount;
            this.connection.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeShutdown() throws IOException {
        RemoteConnection remoteConnection = this.connection;
        synchronized (remoteConnection) {
            if (this.writeClosed) {
                return;
            }
            this.writeClosed = true;
            Pooled<ByteBuffer> pooled = this.connection.allocate();
            try {
                ByteBuffer byteBuffer = (ByteBuffer)pooled.getResource();
                byteBuffer.put((byte)32);
                byteBuffer.putInt(this.channelId);
                byteBuffer.flip();
                ConnectedMessageChannel channel = this.connection.getChannel();
                Channels.sendBlocking((WritableMessageChannel)channel, (ByteBuffer)byteBuffer);
                Channels.flushBlocking((SuspendableWriteChannel)channel);
            }
            finally {
                pooled.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRemoteClose() {
        RemoteConnection remoteConnection = this.connection;
        synchronized (remoteConnection) {
            this.writeClosed = true;
            if (this.readClosed) {
                return;
            }
            this.readClosed = true;
            for (OutboundMessage message : this.outboundMessages) {
                message.asyncClose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWriteShutdown() {
        Runnable runnable;
        RemoteConnection remoteConnection = this.connection;
        synchronized (remoteConnection) {
            final Channel.Receiver receiver = this.nextReceiver;
            if (receiver == null) {
                return;
            }
            runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        receiver.handleEnd(RemoteConnectionChannel.this);
                    }
                    catch (Throwable t) {
                        RemoteLogger.log.exceptionInUserHandler(t);
                    }
                }
            };
        }
        Executor executor = this.connection.getExecutor();
        try {
            executor.execute(runnable);
        }
        catch (Throwable t) {
            this.connection.handleException(new IOException("Fatal connection error", t));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessage(final Channel.Receiver handler) {
        RemoteConnection remoteConnection = this.connection;
        synchronized (remoteConnection) {
            if (this.inboundMessageQueue.isEmpty()) {
                if (this.nextReceiver != null) {
                    throw new IllegalStateException("Message handler already queued");
                }
                this.nextReceiver = handler;
            } else {
                final InboundMessage message = this.inboundMessageQueue.remove();
                try {
                    this.getExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            handler.handleMessage(RemoteConnectionChannel.this, message.messageInputStream);
                        }
                    });
                }
                catch (Throwable t) {
                    this.connection.handleException(new IOException("Fatal connection error", t));
                    return;
                }
            }
            this.connection.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMessageData(Pooled<ByteBuffer> message) {
        InboundMessage inboundMessage;
        ByteBuffer buffer = (ByteBuffer)message.getResource();
        int id = buffer.getShort() & 0xFFFF;
        int flags = buffer.get() & 0xFF;
        if ((flags & 2) != 0) {
            inboundMessage = new InboundMessage((short)id, this, this.inboundWindow);
            if (this.inboundMessages.putIfAbsent(inboundMessage) != null) {
                this.connection.handleException(new IOException("Protocol error: incoming message with duplicate ID received"));
                return;
            }
            RemoteConnection remoteConnection = this.connection;
            synchronized (remoteConnection) {
                if (this.nextReceiver != null) {
                    final Channel.Receiver receiver = this.nextReceiver;
                    this.nextReceiver = null;
                    try {
                        this.getExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                receiver.handleMessage(RemoteConnectionChannel.this, inboundMessage.messageInputStream);
                            }
                        });
                    }
                    catch (Throwable t) {
                        this.connection.handleException(new IOException("Fatal connection error", t));
                        return;
                    }
                } else {
                    this.inboundMessageQueue.add(inboundMessage);
                }
            }
        } else {
            inboundMessage = this.inboundMessages.get(id);
            if (inboundMessage == null) {
                this.connection.handleException(new IOException("Protocol error: incoming message with unknown ID received"));
                return;
            }
        }
        inboundMessage.handleIncoming(message);
    }

    void handleWindowOpen(Pooled<ByteBuffer> pooled) {
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        int id = buffer.getShort() & 0xFFFF;
        OutboundMessage outboundMessage = this.outboundMessages.get(id);
        if (outboundMessage == null) {
            return;
        }
        outboundMessage.acknowledge(buffer.getInt() & Integer.MAX_VALUE);
    }

    void handleAsyncClose(Pooled<ByteBuffer> pooled) {
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        int id = buffer.getShort() & 0xFFFF;
        OutboundMessage outboundMessage = this.outboundMessages.get(id);
        if (outboundMessage == null) {
            return;
        }
        outboundMessage.asyncClose();
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    @Override
    protected void closeAction() throws IOException {
        try {
            this.writeShutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.handleRemoteClose();
        this.closeComplete();
    }

    RemoteConnection getConnection() {
        return this.connection;
    }

    int getChannelId() {
        return this.channelId;
    }

    void freeOutboundMessage(short id) {
        this.outboundMessages.remove(id & 0xFFFF);
    }

    void freeInboundMessage(short id) {
        this.inboundMessages.remove(id & 0xFFFF);
    }

    Pooled<ByteBuffer> allocate(byte protoId) {
        Pooled<ByteBuffer> pooled = this.connection.allocate();
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        buffer.put(protoId);
        buffer.putInt(this.channelId);
        return pooled;
    }
}

