/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.TUNNEL;
import org.jgroups.stack.RouterStub;
import org.jgroups.stack.RouterStubManager;
import org.jgroups.util.Promise;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;

@DeprecatedProperty(names={"gossip_refresh_rate"})
public class TCPGOSSIP
extends Discovery {
    @Property(description="Max time for socket creation. Default is 1000 msec")
    int sock_conn_timeout = 1000;
    @Property(description="Max time in milliseconds to block on a read. 0 blocks forever")
    int sock_read_timeout = 3000;
    @Property(description="Interval (ms) by which a disconnected stub attempts to reconnect to the GossipRouter")
    long reconnect_interval = 10000L;
    private final List<InetSocketAddress> initial_hosts = new CopyOnWriteArrayList<InetSocketAddress>();
    private volatile RouterStubManager stubManager;

    @Property(name="initial_hosts", description="Comma delimited list of hosts to be contacted for initial membership", converter=PropertyConverters.InitialHosts2.class)
    public void setInitialHosts(List<InetSocketAddress> hosts) {
        if (hosts == null || hosts.isEmpty()) {
            throw new IllegalArgumentException("initial_hosts must contain the address of at least one GossipRouter");
        }
        this.initial_hosts.addAll(hosts);
    }

    public List<InetSocketAddress> getInitialHosts() {
        return this.initial_hosts;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.stubManager = RouterStubManager.emptyGossipClientStubManager(this);
        if (this.timeout <= (long)this.sock_conn_timeout) {
            throw new IllegalArgumentException("timeout (" + this.timeout + ") must be greater than sock_conn_timeout (" + this.sock_conn_timeout + ")");
        }
        TP transport = this.getTransport();
        if (transport instanceof TUNNEL) {
            throw new IllegalStateException("TCPGOSSIP cannot be used with TUNNEL; use either TUNNEL:PING or TCP:TCPGOSSIP as valid configurations");
        }
    }

    @Override
    public void start() throws Exception {
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.stubManager.disconnectStubs();
    }

    @Override
    public void destroy() {
        this.stubManager.destroyStubs();
        super.destroy();
    }

    @Override
    public void handleConnect() {
        if (this.group_addr == null || this.local_addr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("group_addr or local_addr is null, cannot register with GossipRouter(s)");
            }
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace("registering " + this.local_addr + " under " + this.group_addr + " with GossipRouter");
            }
            this.stubManager.destroyStubs();
            this.stubManager = new RouterStubManager(this, this.group_addr, this.local_addr, this.reconnect_interval);
            for (InetSocketAddress host : this.initial_hosts) {
                this.stubManager.createAndRegisterStub(host.getHostName(), host.getPort(), null);
            }
            this.connectAllStubs(this.group_addr, this.local_addr);
        }
    }

    @Override
    public void handleDisconnect() {
        this.stubManager.disconnectStubs();
    }

    @Override
    public void sendGetMembersRequest(String cluster_name, Promise promise, boolean return_views_only) throws Exception {
        if (this.group_addr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("cluster_name is null, cannot get membership");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("fetching members from GossipRouter(s)");
        }
        LinkedList<PingData> responses = new LinkedList<PingData>();
        for (RouterStub stub : this.stubManager.getStubs()) {
            try {
                List<PingData> rsps = stub.getMembers(this.group_addr);
                responses.addAll(rsps);
            }
            catch (Throwable t) {
                this.log.warn("failed fetching members from " + stub.getGossipRouterAddress() + ": " + t);
            }
        }
        HashSet<Address> initial_mbrs = new HashSet<Address>();
        for (PingData rsp : responses) {
            String logical_name;
            Address logical_addr = rsp.getAddress();
            initial_mbrs.add(logical_addr);
            Collection<PhysicalAddress> physical_addrs = rsp.getPhysicalAddrs();
            if (physical_addrs != null) {
                for (PhysicalAddress physical_addr : physical_addrs) {
                    this.down(new Event(89, new Tuple<Address, PhysicalAddress>(logical_addr, physical_addr)));
                }
            }
            if ((logical_name = rsp.getLogicalName()) == null || !(logical_addr instanceof UUID)) continue;
            UUID.add(logical_addr, logical_name);
        }
        if (initial_mbrs.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("[FIND_INITIAL_MBRS]: found no members");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("consolidated mbrs from GossipRouter(s) are " + initial_mbrs);
        }
        PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, this.local_addr));
        PingData data = new PingData(this.local_addr, null, false, UUID.get(this.local_addr), Arrays.asList(physical_addr));
        for (Address mbr_addr : initial_mbrs) {
            Message msg = new Message(mbr_addr);
            msg.setFlag((byte)1);
            PingHeader hdr = new PingHeader(1, data, cluster_name);
            hdr.return_view_only = return_views_only;
            msg.putHeader(this.id, hdr);
            if (this.log.isTraceEnabled()) {
                this.log.trace("[FIND_INITIAL_MBRS] sending GET_MBRS_REQ request to " + mbr_addr);
            }
            this.down_prot.down(new Event(1, msg));
        }
    }

    @ManagedOperation
    public void addInitialHost(String hostname, int port) {
        this.removeInitialHost(hostname, port);
        InetSocketAddress isa = new InetSocketAddress(hostname, port);
        this.initial_hosts.add(isa);
        RouterStub s = new RouterStub(isa.getHostName(), isa.getPort(), null, this.stubManager);
        this.connect(s, this.group_addr, this.local_addr);
        this.stubManager.registerStub(s);
    }

    @ManagedOperation
    public boolean removeInitialHost(String hostname, int port) {
        InetSocketAddress isa = new InetSocketAddress(hostname, port);
        RouterStub unregisterStub = this.stubManager.unregisterStub(isa);
        if (unregisterStub != null) {
            this.stubManager.stopReconnecting(unregisterStub);
            unregisterStub.destroy();
        }
        return this.initial_hosts.remove(isa);
    }

    protected void connectAllStubs(String group, Address logical_addr) {
        ArrayList<PhysicalAddress> physical_addrs;
        String logical_name = UUID.get(logical_addr);
        PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, this.local_addr));
        ArrayList<PhysicalAddress> arrayList = physical_addrs = physical_addr != null ? new ArrayList<PhysicalAddress>() : null;
        if (physical_addr != null) {
            physical_addrs.add(physical_addr);
        }
        for (RouterStub stub : this.stubManager.getStubs()) {
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("trying to connect to " + stub.getGossipRouterAddress());
                }
                stub.connect(group, logical_addr, logical_name, physical_addrs);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failed connecting to " + stub.getGossipRouterAddress() + ": " + e);
                }
                this.stubManager.startReconnecting(stub);
            }
        }
    }

    protected void connect(RouterStub stub, String group, Address logical_addr) {
        ArrayList<PhysicalAddress> physical_addrs;
        String logical_name = UUID.get(logical_addr);
        PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, this.local_addr));
        ArrayList<PhysicalAddress> arrayList = physical_addrs = physical_addr != null ? new ArrayList<PhysicalAddress>() : null;
        if (physical_addr != null) {
            physical_addrs.add(physical_addr);
        }
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("trying to connect to " + stub.getGossipRouterAddress());
            }
            stub.connect(group, logical_addr, logical_name, physical_addrs);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("failed connecting to " + stub.getGossipRouterAddress() + ": " + e);
            }
            this.stubManager.startReconnecting(stub);
        }
    }
}

