/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Digest;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

@MBean(description="Flushes the cluster")
@DeprecatedProperty(names={"auto_flush_conf"})
public class FLUSH
extends Protocol {
    @Property(description="Max time to keep channel blocked in flush. Default is 8000 msec")
    private long timeout = 8000L;
    @Property(description="Timeout (per atttempt) to quiet the cluster during the first flush phase. Default is 2000 msec")
    private long start_flush_timeout = 2000L;
    @Property(description="Timeout to wait for UNBLOCK after STOP_FLUSH is issued. Default is 2000 msec")
    private long end_flush_timeout = 2000L;
    @Property(description="Retry timeout after an unsuccessful attempt to quiet the cluster (first flush phase). Default is 3000 msec")
    private long retry_timeout = 2000L;
    @Property(description="Reconciliation phase toggle. Default is true")
    private boolean enable_reconciliation = true;
    private long startFlushTime;
    private long totalTimeInFlush;
    private int numberOfFlushes;
    private double averageFlushDuration;
    private View currentView = new View(new ViewId(), new Vector<Address>());
    private Address localAddress;
    private Address flushCoordinator;
    private final List<Address> flushMembers = new ArrayList<Address>();
    private final AtomicInteger viewCounter = new AtomicInteger(0);
    private final Map<Address, Digest> flushCompletedMap = new HashMap<Address, Digest>();
    private final List<Address> flushNotCompletedMap = new ArrayList<Address>();
    private final Set<Address> suspected = new TreeSet<Address>();
    private final List<Address> reconcileOks = new ArrayList<Address>();
    private final Object sharedLock = new Object();
    private final ReentrantLock blockMutex = new ReentrantLock();
    private final Condition notBlockedDown = this.blockMutex.newCondition();
    private volatile boolean isBlockingFlushDown = true;
    private boolean flushCompleted = false;
    private final Promise<Boolean> flush_promise = new Promise();
    private final Promise<Boolean> flush_unblock_promise = new Promise();
    private final AtomicBoolean flushInProgress = new AtomicBoolean(false);
    private final AtomicBoolean sentBlock = new AtomicBoolean(false);
    private final AtomicBoolean sentUnblock = new AtomicBoolean(false);

    public long getStartFlushTimeout() {
        return this.start_flush_timeout;
    }

    public void setStartFlushTimeout(long start_flush_timeout) {
        this.start_flush_timeout = start_flush_timeout;
    }

    public long getRetryTimeout() {
        return this.retry_timeout;
    }

    public void setRetryTimeout(long retry_timeout) {
        this.retry_timeout = retry_timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("flush_supported", Boolean.TRUE);
        this.up_prot.up(new Event(56, map));
        this.down_prot.down(new Event(56, map));
        this.viewCounter.set(0);
        this.blockMutex.lock();
        try {
            this.isBlockingFlushDown = true;
        }
        finally {
            this.blockMutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.sharedLock;
        synchronized (object) {
            this.currentView = new View(new ViewId(), new Vector<Address>());
            this.flushCompletedMap.clear();
            this.flushNotCompletedMap.clear();
            this.flushMembers.clear();
            this.suspected.clear();
            this.flushCoordinator = null;
        }
    }

    @ManagedAttribute
    public double getAverageFlushDuration() {
        return this.averageFlushDuration;
    }

    @ManagedAttribute
    public long getTotalTimeInFlush() {
        return this.totalTimeInFlush;
    }

    @ManagedAttribute
    public int getNumberOfFlushes() {
        return this.numberOfFlushes;
    }

    @ManagedOperation(description="Request cluster flush")
    public boolean startFlush() {
        return this.startFlush(new Event(68));
    }

    private boolean startFlush(Event evt) {
        List flushParticipants = (List)evt.getArg();
        return this.startFlush(flushParticipants);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startFlush(List<Address> flushParticipants) {
        boolean successfulFlush = false;
        if (!this.flushInProgress.get()) {
            this.flush_promise.reset();
            Object object = this.sharedLock;
            synchronized (object) {
                if (flushParticipants == null) {
                    flushParticipants = new ArrayList<Address>(this.currentView.getMembers());
                }
            }
            this.onSuspend(flushParticipants);
            try {
                Boolean r = this.flush_promise.getResultWithTimeout(this.start_flush_timeout);
                successfulFlush = r;
            }
            catch (TimeoutException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(this.localAddress + ": timed out waiting for flush responses after " + this.start_flush_timeout + " ms. Rejecting flush to participants " + flushParticipants);
                }
                this.rejectFlush(flushParticipants, this.currentViewId());
            }
        }
        return successfulFlush;
    }

    @ManagedOperation(description="Request end of flush in a cluster")
    public void stopFlush() {
        this.down(new Event(70));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest == null || dest.isMulticastAddress()) {
                    FlushHeader fh = (FlushHeader)msg.getHeader(this.id);
                    if (fh != null && fh.type == 6) {
                        return this.down_prot.down(evt);
                    }
                    this.blockMessageDuringFlush();
                    break;
                }
                return this.down_prot.down(evt);
            }
            case 2: 
            case 92: {
                return this.handleConnect(evt, true);
            }
            case 80: 
            case 93: {
                return this.handleConnect(evt, false);
            }
            case 68: {
                return this.startFlush(evt);
            }
            case 94: {
                if (this.flushInProgress.get()) break;
                this.flush_promise.reset();
                ArrayList<Address> flushParticipants = null;
                Object object = this.sharedLock;
                synchronized (object) {
                    flushParticipants = new ArrayList<Address>(this.currentView.getMembers());
                }
                this.onSuspend(flushParticipants);
                break;
            }
            case 70: {
                this.onResume(evt);
                return null;
            }
            case 8: {
                this.localAddress = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    private Object handleConnect(Event evt, boolean waitForUnblock) {
        Object result;
        if (this.sentBlock.compareAndSet(false, true)) {
            this.sendBlockUpToChannel();
        }
        if ((result = this.down_prot.down(evt)) instanceof Throwable) {
            this.sentBlock.set(false);
        }
        if (waitForUnblock) {
            this.waitForUnblock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockMessageDuringFlush() {
        boolean shouldSuspendByItself = false;
        this.blockMutex.lock();
        try {
            while (this.isBlockingFlushDown) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(this.localAddress + ": blocking for " + (this.timeout <= 0L ? "ever" : this.timeout + "ms"));
                }
                shouldSuspendByItself = !this.notBlockedDown.await(this.timeout, TimeUnit.MILLISECONDS);
            }
            if (shouldSuspendByItself) {
                this.isBlockingFlushDown = false;
                this.log.warn(this.localAddress + ": unblocking after " + this.timeout + "ms");
                this.flush_promise.setResult(Boolean.TRUE);
                this.notBlockedDown.signalAll();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.blockMutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                final FlushHeader fh = (FlushHeader)msg.getHeader(this.id);
                if (fh != null) {
                    switch (fh.type) {
                        case 6: {
                            return this.up_prot.up(evt);
                        }
                        case 0: {
                            boolean amIParticipant;
                            Collection<Address> fp = fh.flushParticipants;
                            boolean bl = amIParticipant = fp != null && fp.contains(this.localAddress) || msg.getSrc().equals(this.localAddress);
                            if (amIParticipant) {
                                this.handleStartFlush(msg, fh);
                                break;
                            }
                            if (!this.log.isDebugEnabled()) break;
                            this.log.debug(this.localAddress + ": received START_FLUSH but I am not flush participant, not responding");
                            break;
                        }
                        case 7: {
                            this.handleFlushReconcile(msg, fh);
                            break;
                        }
                        case 8: {
                            this.onFlushReconcileOK(msg);
                            break;
                        }
                        case 2: {
                            this.onStopFlush();
                            break;
                        }
                        case 5: {
                            boolean participant;
                            Collection<Address> flushParticipants = fh.flushParticipants;
                            boolean bl = participant = flushParticipants != null && flushParticipants.contains(this.localAddress);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug(this.localAddress + ": received ABORT_FLUSH from flush coordinator " + msg.getSrc() + ",  am I flush participant=" + participant);
                            }
                            if (!participant) break;
                            this.resetForNextFlush();
                            break;
                        }
                        case 9: {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug(this.localAddress + ": received FLUSH_NOT_COMPLETED from " + msg.getSrc());
                            }
                            boolean flushCollision = false;
                            Object object = this.sharedLock;
                            synchronized (object) {
                                this.flushNotCompletedMap.add(msg.getSrc());
                                boolean bl = flushCollision = !this.flushCompletedMap.isEmpty();
                                if (flushCollision) {
                                    this.flushNotCompletedMap.clear();
                                    this.flushCompletedMap.clear();
                                }
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug(this.localAddress + ": received FLUSH_NOT_COMPLETED from " + msg.getSrc() + " collision=" + flushCollision);
                            }
                            if (flushCollision) {
                                Runnable r = new Runnable(){

                                    @Override
                                    public void run() {
                                        FLUSH.this.rejectFlush(fh.flushParticipants, fh.viewID);
                                    }
                                };
                                new Thread(r).start();
                            }
                            this.flush_promise.setResult(Boolean.FALSE);
                            break;
                        }
                        case 3: {
                            if (!this.isCurrentFlushMessage(fh)) break;
                            this.onFlushCompleted(msg.getSrc(), fh);
                        }
                    }
                    return null;
                }
                Address dest = msg.getDest();
                if (dest == null || dest.isMulticastAddress()) break;
                return this.up_prot.up(evt);
            }
            case 6: {
                boolean isThisOurFirstView;
                this.up_prot.up(evt);
                View newView = (View)evt.getArg();
                boolean coordinatorLeft = this.onViewChange(newView);
                boolean singletonMember = newView.size() == 1 && newView.containsMember(this.localAddress);
                boolean bl = isThisOurFirstView = this.viewCounter.addAndGet(1) == 1;
                if (isThisOurFirstView && singletonMember || coordinatorLeft) {
                    this.onStopFlush();
                }
                return null;
            }
            case 15: {
                View tmpView = (View)evt.getArg();
                if (tmpView.containsMember(this.localAddress)) break;
                this.onViewChange(tmpView);
                break;
            }
            case 9: {
                this.onSuspect((Address)evt.getArg());
                break;
            }
            case 68: {
                return this.startFlush(evt);
            }
            case 70: {
                this.onResume(evt);
                return null;
            }
            case 75: {
                this.flush_unblock_promise.setResult(Boolean.TRUE);
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForUnblock() {
        try {
            this.flush_unblock_promise.getResultWithTimeout(this.end_flush_timeout);
        }
        catch (TimeoutException t) {
            if (this.log.isWarnEnabled()) {
                this.log.warn(this.localAddress + ": waiting for UNBLOCK timed out after " + this.end_flush_timeout + " ms");
            }
        }
        finally {
            this.flush_unblock_promise.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlushReconcileOK(Message msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.localAddress + ": received reconcile ok from " + msg.getSrc());
        }
        Object object = this.sharedLock;
        synchronized (object) {
            this.reconcileOks.add(msg.getSrc());
            if (this.reconcileOks.size() >= this.flushMembers.size()) {
                this.flush_promise.setResult(Boolean.TRUE);
                if (this.log.isDebugEnabled()) {
                    this.log.debug(this.localAddress + ": all FLUSH_RECONCILE_OK received");
                }
            }
        }
    }

    private void handleFlushReconcile(Message msg, FlushHeader fh) {
        Address requester = msg.getSrc();
        Digest reconcileDigest = fh.digest;
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.localAddress + ": received FLUSH_RECONCILE, passing digest to NAKACK " + reconcileDigest);
        }
        this.down_prot.down(new Event(78, reconcileDigest));
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.localAddress + ": returned from FLUSH_RECONCILE, " + " sending RECONCILE_OK to " + requester);
        }
        Message reconcileOk = new Message(requester);
        reconcileOk.setFlag((byte)1);
        reconcileOk.putHeader(this.id, new FlushHeader(8));
        this.down_prot.down(new Event(1, reconcileOk));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStartFlush(Message msg, FlushHeader fh) {
        Address flushRequester = msg.getSrc();
        boolean proceed = this.flushInProgress.compareAndSet(false, true);
        if (proceed) {
            Object object = this.sharedLock;
            synchronized (object) {
                this.flushCoordinator = flushRequester;
            }
            this.onStartFlush(flushRequester, fh);
        } else {
            FlushHeader fhr = new FlushHeader(9, fh.viewID, fh.flushParticipants);
            Message response = new Message(flushRequester);
            response.putHeader(this.id, fhr);
            this.down_prot.down(new Event(1, response));
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.localAddress + ": received START_FLUSH, responded with FLUSH_NOT_COMPLETED to " + flushRequester);
            }
        }
    }

    private void rejectFlush(Collection<? extends Address> participants, long viewId) {
        for (Address address : participants) {
            Message reject = new Message(address, this.localAddress, null);
            reject.setFlag((byte)1);
            reject.putHeader(this.id, new FlushHeader(5, viewId, participants));
            this.down_prot.down(new Event(1, reject));
        }
    }

    @Override
    public Vector<Integer> providedDownServices() {
        Vector<Integer> retval = new Vector<Integer>(2);
        retval.addElement(new Integer(68));
        retval.addElement(new Integer(70));
        return retval;
    }

    private void sendBlockUpToChannel() {
        this.up(new Event(10));
        this.sentUnblock.set(false);
    }

    private void sendUnBlockUpToChannel() {
        this.sentBlock.set(false);
        this.up(new Event(75));
    }

    private boolean isCurrentFlushMessage(FlushHeader fh) {
        return fh.viewID == this.currentViewId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long currentViewId() {
        long viewId = -1L;
        Object object = this.sharedLock;
        synchronized (object) {
            ViewId view = this.currentView.getVid();
            if (view != null) {
                viewId = view.getId();
            }
        }
        return viewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onViewChange(View view) {
        boolean coordinatorLeft = false;
        Object object = this.sharedLock;
        synchronized (object) {
            this.suspected.retainAll(view.getMembers());
            View oldView = this.currentView;
            this.currentView = view;
            coordinatorLeft = !oldView.getMembers().isEmpty() && !view.getMembers().isEmpty() && !view.containsMember(oldView.getCreator());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.localAddress + ": installing view " + view);
        }
        return coordinatorLeft;
    }

    private void onStopFlush() {
        if (this.stats && this.startFlushTime > 0L) {
            long stopFlushTime = System.currentTimeMillis();
            this.totalTimeInFlush += stopFlushTime - this.startFlushTime;
            if (this.numberOfFlushes > 0) {
                this.averageFlushDuration = (double)this.totalTimeInFlush / (double)this.numberOfFlushes;
            }
            this.startFlushTime = 0L;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.localAddress + ": received STOP_FLUSH, unblocking FLUSH.down() and sending UNBLOCK up");
        }
        this.resetForNextFlush();
        if (this.sentUnblock.compareAndSet(false, true)) {
            this.sendUnBlockUpToChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetForNextFlush() {
        Object object = this.sharedLock;
        synchronized (object) {
            this.flushCompletedMap.clear();
            this.flushNotCompletedMap.clear();
            this.flushMembers.clear();
            this.suspected.clear();
            this.flushCoordinator = null;
            this.flushCompleted = false;
        }
        this.blockMutex.lock();
        try {
            this.isBlockingFlushDown = false;
            this.notBlockedDown.signalAll();
        }
        finally {
            this.blockMutex.unlock();
        }
        this.flushInProgress.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuspend(List<Address> members) {
        Message msg = null;
        List<Address> participantsInFlush = null;
        Object object = this.sharedLock;
        synchronized (object) {
            this.flushCoordinator = this.localAddress;
            participantsInFlush = members;
            participantsInFlush.retainAll(this.currentView.getMembers());
            this.flushMembers.clear();
            this.flushMembers.addAll(participantsInFlush);
            this.flushMembers.removeAll(this.suspected);
            msg = new Message(null, this.localAddress, null);
            msg.putHeader(this.id, new FlushHeader(0, this.currentViewId(), participantsInFlush));
        }
        if (participantsInFlush.isEmpty()) {
            this.flush_promise.setResult(Boolean.TRUE);
        } else {
            this.down_prot.down(new Event(1, msg));
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.localAddress + ": flush coordinator " + " is starting FLUSH with participants " + participantsInFlush);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResume(Event evt) {
        List members = (List)evt.getArg();
        long viewID = this.currentViewId();
        boolean isParticipant = false;
        Object object = this.sharedLock;
        synchronized (object) {
            isParticipant = this.flushMembers.contains(this.localAddress) || members != null && members.contains(this.localAddress);
        }
        if (members == null || members.isEmpty()) {
            Message msg = new Message(null, this.localAddress, null);
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.localAddress + ": received RESUME, sending STOP_FLUSH to all");
            }
            msg.putHeader(this.id, new FlushHeader(2, viewID));
            this.down_prot.down(new Event(1, msg));
        } else {
            for (Address address : members) {
                Message msg = new Message(address, this.localAddress, null);
                if (this.log.isDebugEnabled()) {
                    this.log.debug(this.localAddress + ": received RESUME, sending STOP_FLUSH to " + address);
                }
                msg.putHeader(this.id, new FlushHeader(2, viewID));
                this.down_prot.down(new Event(1, msg));
            }
        }
        if (isParticipant) {
            this.waitForUnblock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStartFlush(Address flushStarter, FlushHeader fh) {
        if (this.stats) {
            this.startFlushTime = System.currentTimeMillis();
            ++this.numberOfFlushes;
        }
        boolean proceed = false;
        boolean amIFlushInitiator = false;
        Object object = this.sharedLock;
        synchronized (object) {
            amIFlushInitiator = flushStarter.equals(this.localAddress);
            if (!amIFlushInitiator) {
                this.flushCoordinator = flushStarter;
                this.flushMembers.clear();
                if (fh.flushParticipants != null) {
                    this.flushMembers.addAll(fh.flushParticipants);
                }
                this.flushMembers.removeAll(this.suspected);
            }
            proceed = this.flushMembers.contains(this.localAddress);
        }
        if (proceed) {
            if (this.sentBlock.compareAndSet(false, true)) {
                this.sendBlockUpToChannel();
                this.blockMutex.lock();
                try {
                    this.isBlockingFlushDown = true;
                }
                finally {
                    this.blockMutex.unlock();
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug(this.localAddress + ": received START_FLUSH, but not sending BLOCK up");
            }
            Digest digest = (Digest)this.down_prot.down(new Event(39));
            FlushHeader fhr = new FlushHeader(3, fh.viewID, fh.flushParticipants);
            fhr.addDigest(digest);
            Message msg = new Message(flushStarter);
            msg.putHeader(this.id, fhr);
            this.down_prot.down(new Event(1, msg));
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.localAddress + ": received START_FLUSH, responded with FLUSH_COMPLETED to " + flushStarter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlushCompleted(Address address, final FlushHeader header) {
        Message msg = null;
        boolean needsReconciliationPhase = false;
        boolean collision = false;
        Digest digest = header.digest;
        Object object = this.sharedLock;
        synchronized (object) {
            this.flushCompletedMap.put(address, digest);
            this.flushCompleted = this.flushCompletedMap.size() >= this.flushMembers.size() && !this.flushMembers.isEmpty() && this.flushCompletedMap.keySet().containsAll(this.flushMembers);
            boolean bl = collision = !this.flushNotCompletedMap.isEmpty();
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.localAddress + ": FLUSH_COMPLETED from " + address + ", completed " + this.flushCompleted + ", flushMembers " + this.flushMembers + ", flushCompleted " + this.flushCompletedMap.keySet());
            }
            boolean bl2 = needsReconciliationPhase = this.enable_reconciliation && this.flushCompleted && this.hasVirtualSynchronyGaps();
            if (needsReconciliationPhase) {
                Digest d = this.findHighestSequences();
                msg = new Message();
                msg.setFlag((byte)1);
                FlushHeader fh = new FlushHeader(7, this.currentViewId(), this.flushMembers);
                this.reconcileOks.clear();
                fh.addDigest(d);
                msg.putHeader(this.id, fh);
                if (this.log.isDebugEnabled()) {
                    this.log.debug(this.localAddress + ": reconciling flush mebers due to virtual synchrony gap, digest is " + d + " flush members are " + this.flushMembers);
                }
                this.flushCompletedMap.clear();
            } else if (this.flushCompleted) {
                this.flushCompletedMap.clear();
            } else if (collision) {
                this.flushNotCompletedMap.clear();
                this.flushCompletedMap.clear();
            }
        }
        if (needsReconciliationPhase) {
            this.down_prot.down(new Event(1, msg));
        } else if (this.flushCompleted) {
            this.flush_promise.setResult(Boolean.TRUE);
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.localAddress + ": all FLUSH_COMPLETED received");
            }
        } else if (collision) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    FLUSH.this.rejectFlush(header.flushParticipants, header.viewID);
                }
            };
            new Thread(r).start();
        }
    }

    private boolean hasVirtualSynchronyGaps() {
        ArrayList<Digest> digests = new ArrayList<Digest>();
        digests.addAll(this.flushCompletedMap.values());
        Digest firstDigest = (Digest)digests.get(0);
        List remainingDigests = digests.subList(1, digests.size());
        for (Digest digest : remainingDigests) {
            Digest diff = firstDigest.difference(digest);
            if (diff == Digest.EMPTY_DIGEST) continue;
            return true;
        }
        return false;
    }

    private Digest findHighestSequences() {
        Digest result = null;
        ArrayList<Digest> digests = new ArrayList<Digest>(this.flushCompletedMap.values());
        result = (Digest)digests.get(0);
        List remainingDigests = digests.subList(1, digests.size());
        for (Digest digestG : remainingDigests) {
            result = result.highestSequence(digestG);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuspect(Address address) {
        boolean amINeighbourOfCrashedFlushCoordinator = false;
        ArrayList<Address> flushMembersCopy = null;
        Object object = this.sharedLock;
        synchronized (object) {
            boolean flushCoordinatorSuspected;
            boolean bl = flushCoordinatorSuspected = address != null && address.equals(this.flushCoordinator);
            if (flushCoordinatorSuspected) {
                int indexOfCoordinator = this.flushMembers.indexOf(this.flushCoordinator);
                int myIndex = this.flushMembers.indexOf(this.localAddress);
                int diff = myIndex - indexOfCoordinator;
                boolean bl2 = amINeighbourOfCrashedFlushCoordinator = diff == 1 || myIndex == 0 && indexOfCoordinator == this.flushMembers.size();
                if (amINeighbourOfCrashedFlushCoordinator) {
                    flushMembersCopy = new ArrayList<Address>(this.flushMembers);
                }
            }
        }
        if (amINeighbourOfCrashedFlushCoordinator) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.localAddress + ": flush coordinator " + this.flushCoordinator + " suspected," + " I am the neighbor, completing the flush ");
            }
            this.onResume(new Event(70, flushMembersCopy));
        }
        boolean flushOkCompleted = false;
        Message m = null;
        long viewID = 0L;
        Object diff = this.sharedLock;
        synchronized (diff) {
            this.suspected.add(address);
            this.flushMembers.removeAll(this.suspected);
            viewID = this.currentViewId();
            boolean bl = flushOkCompleted = !this.flushCompletedMap.isEmpty() && this.flushCompletedMap.keySet().containsAll(this.flushMembers);
            if (flushOkCompleted) {
                m = new Message(this.flushCoordinator, this.localAddress, null);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.localAddress + ": suspect is " + address + ", completed " + flushOkCompleted + ", flushOkSet " + this.flushCompletedMap + ", flushMembers " + this.flushMembers);
            }
        }
        if (flushOkCompleted) {
            Digest digest = (Digest)this.down_prot.down(new Event(39));
            FlushHeader fh = new FlushHeader(3, viewID);
            fh.addDigest(digest);
            m.putHeader(this.id, fh);
            this.down_prot.down(new Event(1, m));
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.localAddress + ": sent FLUSH_COMPLETED message to " + this.flushCoordinator);
            }
        }
    }

    public static class FlushHeader
    extends Header {
        public static final byte START_FLUSH = 0;
        public static final byte STOP_FLUSH = 2;
        public static final byte FLUSH_COMPLETED = 3;
        public static final byte ABORT_FLUSH = 5;
        public static final byte FLUSH_BYPASS = 6;
        public static final byte FLUSH_RECONCILE = 7;
        public static final byte FLUSH_RECONCILE_OK = 8;
        public static final byte FLUSH_NOT_COMPLETED = 9;
        byte type;
        long viewID;
        Collection<Address> flushParticipants;
        Digest digest = null;

        public FlushHeader() {
            this(0, 0L);
        }

        public FlushHeader(byte type) {
            this(type, 0L);
        }

        public FlushHeader(byte type, long viewID) {
            this(type, viewID, null);
        }

        public FlushHeader(byte type, long viewID, Collection<? extends Address> flushView) {
            this.type = type;
            this.viewID = viewID;
            if (flushView != null) {
                this.flushParticipants = new ArrayList<Address>(flushView);
            }
        }

        @Override
        public int size() {
            int retval = 1;
            retval += 8;
            retval = (int)((long)retval + Util.size(this.flushParticipants));
            ++retval;
            if (this.digest != null) {
                retval = (int)((long)retval + this.digest.serializedSize());
            }
            return retval;
        }

        public void addDigest(Digest digest) {
            this.digest = digest;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 0: {
                    return "FLUSH[type=START_FLUSH,viewId=" + this.viewID + ",members=" + this.flushParticipants + "]";
                }
                case 2: {
                    return "FLUSH[type=STOP_FLUSH,viewId=" + this.viewID + "]";
                }
                case 5: {
                    return "FLUSH[type=ABORT_FLUSH,viewId=" + this.viewID + "]";
                }
                case 3: {
                    return "FLUSH[type=FLUSH_COMPLETED,viewId=" + this.viewID + "]";
                }
                case 6: {
                    return "FLUSH[type=FLUSH_BYPASS,viewId=" + this.viewID + "]";
                }
                case 7: {
                    return "FLUSH[type=FLUSH_RECONCILE,viewId=" + this.viewID + ",digest=" + this.digest + "]";
                }
                case 8: {
                    return "FLUSH[type=FLUSH_RECONCILE_OK,viewId=" + this.viewID + "]";
                }
            }
            return "[FLUSH: unknown type (" + this.type + ")]";
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.viewID);
            Util.writeAddresses(this.flushParticipants, out);
            Util.writeStreamable(this.digest, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.viewID = in.readLong();
            this.flushParticipants = Util.readAddresses(in, ArrayList.class);
            this.digest = (Digest)Util.readStreamable(Digest.class, in);
        }
    }
}

