/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import javax.naming.Name;
import org.jboss.as.naming.JndiPermissionCollection;

public final class JndiPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient int mask;
    private transient boolean directory;
    private transient boolean recursive;
    private String actions;
    private transient String cpath;
    private static final char RECURSIVE_CHAR = '-';
    private static final char WILD_CHAR = '*';

    private void init(int mask) {
        int last;
        if ((mask & Action.ALL.mask) != mask) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (mask == Action.NONE.mask) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        this.cpath = this.getName();
        if (this.cpath == null) {
            throw new NullPointerException("name can't be null");
        }
        this.mask = mask;
        if (this.cpath.equals("<<ALL BINDINGS>>")) {
            this.directory = true;
            this.recursive = true;
            this.cpath = "";
            return;
        }
        int len = this.cpath.length();
        int n = last = len > 0 ? (int)this.cpath.charAt(len - 1) : 0;
        if (last == 45 && this.cpath.charAt(len - 2) == '/') {
            this.directory = true;
            this.recursive = true;
            this.cpath = this.cpath.substring(0, --len);
        } else if (last == 42 && this.cpath.charAt(len - 2) == '/') {
            this.directory = true;
            this.cpath = this.cpath.substring(0, --len);
        }
    }

    public JndiPermission(String path, Action ... actions) {
        super(path);
        this.init(JndiPermission.getMask(actions));
    }

    public JndiPermission(Name path, Action ... actions) {
        this(path.toString(), actions);
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof JndiPermission)) {
            return false;
        }
        JndiPermission that = (JndiPermission)p;
        return (this.mask & that.mask) == that.mask && this.impliesIgnoreMask(that);
    }

    boolean impliesIgnoreMask(JndiPermission that) {
        if (this.directory) {
            if (this.recursive) {
                if (that.directory) {
                    return that.cpath.length() >= this.cpath.length() && that.cpath.startsWith(this.cpath);
                }
                return that.cpath.length() >= this.cpath.length() && that.cpath.startsWith(this.cpath);
            }
            if (that.directory) {
                if (that.recursive) {
                    return false;
                }
                return this.cpath.equals(that.cpath);
            }
            int last = that.cpath.lastIndexOf(47);
            if (last == -1) {
                return false;
            }
            return this.cpath.length() == last + 1 && this.cpath.regionMatches(0, that.cpath, 0, last + 1);
        }
        if (that.directory) {
            return false;
        }
        return this.cpath.equals(that.cpath);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JndiPermission)) {
            return false;
        }
        JndiPermission that = (JndiPermission)obj;
        return this.mask == that.mask && this.cpath.equals(that.cpath) && this.directory == that.directory && this.recursive == that.recursive;
    }

    @Override
    public int hashCode() {
        return this.cpath.hashCode();
    }

    private static int getMask(Action[] actions) {
        int mask = Action.NONE.mask;
        if (actions == null || actions.length == 0) {
            return mask;
        }
        if (actions.length == 1) {
            return actions[0].mask;
        }
        for (Action action : actions) {
            mask |= action.mask;
        }
        return mask;
    }

    private static int getMask(String actions) {
        String[] sa;
        int mask = Action.NONE.mask;
        if (actions == null || actions.length() == 0) {
            return mask;
        }
        Action action = Action.forName(actions);
        if (action != null) {
            return action.mask;
        }
        for (String s : sa = actions.split(",")) {
            String key = s.toLowerCase();
            action = Action.forName(key);
            if (action == null) {
                throw new IllegalArgumentException("invalid permission, unknown action: " + s);
            }
            int i = action.mask;
            mask |= i;
        }
        return mask;
    }

    int getMask() {
        return this.mask;
    }

    private static String getActions(int mask) {
        StringBuilder sb = new StringBuilder();
        boolean insertComma = false;
        Action[] allActions = Action.values();
        for (int n = 0; n < allActions.length; ++n) {
            int action = 1 << n;
            if ((mask & action) != action) continue;
            if (insertComma) {
                sb.append(',');
            }
            sb.append(allActions[n].actionName);
            insertComma = true;
        }
        return sb.toString();
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            this.actions = JndiPermission.getActions(this.mask);
        }
        return this.actions;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new JndiPermissionCollection();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(JndiPermission.getMask(this.actions));
    }

    public static enum Action {
        NONE("none", 0),
        BIND("bind", 1),
        REBIND("rebind", 2),
        UNBIND("unbind", 4),
        LOOKUP("lookup", 8),
        LIST("list", 16),
        LIST_BINDINGS("listBindings", 32),
        CREATE_SUBCONTEXT("createSubcontext", 64),
        ALL("all", Action.BIND.mask | Action.REBIND.mask | Action.UNBIND.mask | Action.LOOKUP.mask | Action.LIST.mask | Action.LIST_BINDINGS.mask | Action.CREATE_SUBCONTEXT.mask);

        private String actionName;
        private int mask;

        private Action(String actionName, int mask) {
            this.actionName = actionName;
            this.mask = mask;
        }

        public static Action forName(String actionName) {
            for (Action action : Action.values()) {
                if (!action.actionName.equals(actionName)) continue;
                return action;
            }
            return null;
        }
    }
}

