/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.io.Serializable;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

public class StatefulRemoveInterceptor
implements Interceptor {
    private final boolean retainIfException;

    public StatefulRemoveInterceptor(boolean retainIfException) {
        this.retainIfException = retainIfException;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        Component component = (Component)context.getPrivateData(Component.class);
        if (!(component instanceof StatefulSessionComponent)) {
            throw new RuntimeException("Unexpected component: " + component + " in interceptor context: " + context + " Expected an instance of " + StatefulSessionComponent.class);
        }
        StatefulSessionComponent statefulComponent = (StatefulSessionComponent)component;
        Object invocationResult = null;
        try {
            invocationResult = context.proceed();
        }
        catch (Exception e) {
            if (this.isApplicationException(statefulComponent, e.getClass()) && this.retainIfException) {
                throw e;
            }
            StatefulSessionComponentInstance statefulComponentInstance = (StatefulSessionComponentInstance)((Object)context.getPrivateData(ComponentInstance.class));
            Serializable sessionId = statefulComponentInstance.getId();
            statefulComponent.removeSession(sessionId);
            throw e;
        }
        StatefulSessionComponentInstance statefulComponentInstance = (StatefulSessionComponentInstance)((Object)context.getPrivateData(ComponentInstance.class));
        Serializable sessionId = statefulComponentInstance.getId();
        statefulComponent.removeSession(sessionId);
        return invocationResult;
    }

    private boolean isApplicationException(EJBComponent ejbComponent, Class<?> exceptionClass) {
        return ejbComponent.getApplicationException(exceptionClass) != null;
    }
}

