/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import java.util.Map;
import javax.ejb.Asynchronous;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class AsynchronousAnnotationProcessor
extends AbstractAnnotationEJBProcessor<SessionBeanComponentDescription> {
    private static final DotName ASYNCHRONOUS_ANNOTATION = DotName.createSimple((String)Asynchronous.class.getName());

    @Override
    protected Class<SessionBeanComponentDescription> getComponentDescriptionType() {
        return SessionBeanComponentDescription.class;
    }

    @Override
    protected void processAnnotations(ClassInfo beanClass, CompositeIndex compositeIndex, SessionBeanComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        this.processAsyncAnnotation(beanClass, compositeIndex, componentDescription);
    }

    private void processAsyncAnnotation(ClassInfo beanClass, CompositeIndex compositeIndex, SessionBeanComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        Map classAnnotations;
        ClassInfo superClass;
        DotName superName = beanClass.superName();
        if (superName != null && (superClass = compositeIndex.getClassByName(superName)) != null) {
            this.processAsyncAnnotation(superClass, compositeIndex, componentDescription);
        }
        if ((classAnnotations = beanClass.annotations()) == null) {
            return;
        }
        List annotations = (List)classAnnotations.get(ASYNCHRONOUS_ANNOTATION);
        if (annotations == null) {
            return;
        }
        for (AnnotationInstance annotationInstance : annotations) {
            AnnotationTarget target = annotationInstance.target();
            if (target instanceof ClassInfo) {
                componentDescription.addAsynchronousView(((ClassInfo)ClassInfo.class.cast(target)).name().toString());
                continue;
            }
            if (!(target instanceof MethodInfo)) continue;
            MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
            String[] args = new String[methodInfo.args().length];
            for (int i = 0; i < methodInfo.args().length; ++i) {
                args[i] = methodInfo.args()[i].name().toString();
            }
            componentDescription.addAsynchronousMethod(MethodIdentifier.getIdentifier((String)methodInfo.returnType().name().toString(), (String)methodInfo.name(), (String[])args));
        }
    }
}

