/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateless.StatelessComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeansMetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.ejb.spec.SessionType;
import org.jboss.msc.service.ServiceName;

public class EJBComponentDescriptionFactory
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(EJBComponentDescriptionFactory.class);
    private static final DotName STATELESS_ANNOTATION = DotName.createSimple((String)Stateless.class.getName());
    private static final DotName STATEFUL_ANNOTATION = DotName.createSimple((String)Stateful.class.getName());
    private static final DotName SINGLETON_ANNOTATION = DotName.createSimple((String)Singleton.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        EJBComponentDescriptionFactory.processAnnotations(deploymentUnit);
        EJBComponentDescriptionFactory.processDeploymentDescriptor(deploymentUnit);
    }

    private static SessionBeanComponentDescription.SessionBeanType descriptionOf(SessionType sessionType) {
        if (sessionType == null) {
            return null;
        }
        switch (sessionType) {
            case Stateless: {
                return SessionBeanComponentDescription.SessionBeanType.STATELESS;
            }
            case Stateful: {
                return SessionBeanComponentDescription.SessionBeanType.STATEFUL;
            }
            case Singleton: {
                return SessionBeanComponentDescription.SessionBeanType.SINGLETON;
            }
        }
        throw new IllegalArgumentException("Unknown session bean type: " + sessionType);
    }

    private static EjbJarDescription getEjbJarDescription(DeploymentUnit deploymentUnit) {
        EjbJarDescription ejbJarDescription = (EjbJarDescription)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION);
        EEApplicationClasses applicationClassesDescription = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        if (ejbJarDescription == null) {
            EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            ejbJarDescription = new EjbJarDescription(moduleDescription, applicationClassesDescription, deploymentUnit.getName().endsWith(".war"));
            deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION, (Object)ejbJarDescription);
        }
        return ejbJarDescription;
    }

    private static EnterpriseBeansMetaData getEnterpriseBeansMetaData(DeploymentUnit deploymentUnit) {
        EjbJarMetaData jarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (jarMetaData == null) {
            return null;
        }
        return jarMetaData.getEnterpriseBeans();
    }

    private static <B extends EnterpriseBeanMetaData> B getEnterpriseBeanMetaData(DeploymentUnit deploymentUnit, String name, Class<B> expectedType) {
        EnterpriseBeansMetaData enterpriseBeansMetaData = EJBComponentDescriptionFactory.getEnterpriseBeansMetaData(deploymentUnit);
        if (enterpriseBeansMetaData == null) {
            return null;
        }
        return (B)((EnterpriseBeanMetaData)expectedType.cast(enterpriseBeansMetaData.get(name)));
    }

    private static void processAnnotations(DeploymentUnit deploymentUnit) {
        List sbAnnotations;
        List sfsbAnnotations;
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Skipping EJB annotation processing since no composite annotation index found in unit: " + deploymentUnit));
            }
            return;
        }
        List slsbAnnotations = compositeIndex.getAnnotations(STATELESS_ANNOTATION);
        if (!slsbAnnotations.isEmpty()) {
            EJBComponentDescriptionFactory.processSessionBeans(deploymentUnit, slsbAnnotations, SessionBeanComponentDescription.SessionBeanType.STATELESS);
        }
        if (!(sfsbAnnotations = compositeIndex.getAnnotations(STATEFUL_ANNOTATION)).isEmpty()) {
            EJBComponentDescriptionFactory.processSessionBeans(deploymentUnit, sfsbAnnotations, SessionBeanComponentDescription.SessionBeanType.STATEFUL);
        }
        if (!(sbAnnotations = compositeIndex.getAnnotations(SINGLETON_ANNOTATION)).isEmpty()) {
            EJBComponentDescriptionFactory.processSessionBeans(deploymentUnit, sbAnnotations, SessionBeanComponentDescription.SessionBeanType.SINGLETON);
        }
    }

    private static void processBeanMetaData(DeploymentUnit deploymentUnit, EnterpriseBeanMetaData enterpriseBeanMetaData) throws DeploymentUnitProcessingException {
        if (!(enterpriseBeanMetaData instanceof SessionBeanMetaData)) {
            throw new IllegalArgumentException("Unable to process " + enterpriseBeanMetaData);
        }
        EJBComponentDescriptionFactory.processSessionBeanMetaData(deploymentUnit, (SessionBeanMetaData)enterpriseBeanMetaData);
    }

    private static void processDeploymentDescriptor(DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMetaData == null) {
            return;
        }
        EnterpriseBeansMetaData ejbs = ejbJarMetaData.getEnterpriseBeans();
        if (ejbs != null && !ejbs.isEmpty()) {
            for (EnterpriseBeanMetaData ejb : ejbs) {
                EJBComponentDescriptionFactory.processBeanMetaData(deploymentUnit, ejb);
            }
        }
        EjbDeploymentMarker.mark(deploymentUnit);
    }

    private static void processSessionBeanMetaData(DeploymentUnit deploymentUnit, SessionBeanMetaData sessionBean) throws DeploymentUnitProcessingException {
        SessionBeanComponentDescription sessionBeanDescription;
        String beanName;
        EjbJarDescription ejbJarDescription = EJBComponentDescriptionFactory.getEjbJarDescription(deploymentUnit);
        if (ejbJarDescription.hasComponent(beanName = sessionBean.getName())) {
            return;
        }
        SessionType sessionType = sessionBean.getSessionType();
        if (sessionType == null) {
            throw new DeploymentUnitProcessingException("Unknown session-type for session bean: " + sessionBean.getName() + " in deployment unit: " + deploymentUnit);
        }
        String beanClassName = sessionBean.getEjbClass();
        switch (sessionType) {
            case Stateless: {
                sessionBeanDescription = new StatelessComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName());
                break;
            }
            case Stateful: {
                sessionBeanDescription = new StatefulComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName());
                break;
            }
            case Singleton: {
                sessionBeanDescription = new SingletonComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown session bean type: " + sessionType);
            }
        }
        ejbJarDescription.getEEModuleDescription().addComponent((ComponentDescription)sessionBeanDescription);
    }

    private static void processSessionBeans(DeploymentUnit deploymentUnit, List<AnnotationInstance> sessionBeanAnnotations, SessionBeanComponentDescription.SessionBeanType annotatedSessionBeanType) {
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EjbJarDescription ejbJarDescription = EJBComponentDescriptionFactory.getEjbJarDescription(deploymentUnit);
        ServiceName deploymentUnitServiceName = deploymentUnit.getServiceName();
        for (AnnotationInstance sessionBeanAnnotation : sessionBeanAnnotations) {
            SessionBeanComponentDescription sessionBeanDescription;
            String beanClassName;
            SessionBeanComponentDescription.SessionBeanType sessionBeanType;
            AnnotationTarget target = sessionBeanAnnotation.target();
            if (!(target instanceof ClassInfo)) {
                logger.warn((Object)(sessionBeanAnnotation.name() + " annotation is expected to be only on classes. " + target + " is not a class"));
                continue;
            }
            ClassInfo sessionBeanClassInfo = (ClassInfo)target;
            String ejbName = sessionBeanClassInfo.name().local();
            AnnotationValue nameValue = sessionBeanAnnotation.value("name");
            String beanName = nameValue == null || nameValue.asString().isEmpty() ? ejbName : nameValue.asString();
            SessionBeanMetaData beanMetaData = EJBComponentDescriptionFactory.getEnterpriseBeanMetaData(deploymentUnit, beanName, SessionBeanMetaData.class);
            if (beanMetaData != null) {
                sessionBeanType = EJBComponentDescriptionFactory.override(annotatedSessionBeanType, EJBComponentDescriptionFactory.descriptionOf(beanMetaData.getSessionType()));
                beanClassName = EJBComponentDescriptionFactory.override(sessionBeanClassInfo.name().toString(), beanMetaData.getEjbClass());
            } else {
                sessionBeanType = annotatedSessionBeanType;
                beanClassName = sessionBeanClassInfo.name().toString();
            }
            switch (sessionBeanType) {
                case STATELESS: {
                    sessionBeanDescription = new StatelessComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnitServiceName);
                    break;
                }
                case STATEFUL: {
                    sessionBeanDescription = new StatefulComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnitServiceName);
                    break;
                }
                case SINGLETON: {
                    sessionBeanDescription = new SingletonComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnitServiceName);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown session bean type: " + (Object)((Object)sessionBeanType));
                }
            }
            ejbJarDescription.getEEModuleDescription().addComponent((ComponentDescription)sessionBeanDescription);
        }
        EjbDeploymentMarker.mark(deploymentUnit);
    }

    private static <T> T override(T original, T override) {
        return override != null ? override : original;
    }

    public void undeploy(DeploymentUnit context) {
    }
}

