/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.server.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class ServerEnvironment
implements Serializable {
    private static final long serialVersionUID = -349976376447122910L;
    private static final transient Logger log = Logger.getLogger(ServerEnvironment.class);
    public static final String JAVA_EXT_DIRS = "java.ext.dirs";
    public static final String HOME_DIR = "jboss.home.dir";
    public static final String MODULES_DIR = "jboss.modules.dir";
    public static final String VFS_MODULE_IDENTIFIER = "org.jboss.vfs";
    public static final String SERVER_BASE_DIR = "jboss.server.base.dir";
    public static final String SERVER_CONFIG_DIR = "jboss.server.config.dir";
    public static final String SERVER_DATA_DIR = "jboss.server.data.dir";
    public static final String SERVER_DEPLOY_DIR = "jboss.server.deploy.dir";
    public static final String SERVER_LOG_DIR = "jboss.server.log.dir";
    public static final String SERVER_TEMP_DIR = "jboss.server.temp.dir";
    public static final String SERVER_SYSTEM_DEPLOY_DIR = "jboss.server.system.deploy.dir";
    public static final String NODE_NAME = "jboss.node.name";
    public static final String SERVER_NAME = "jboss.server.name";
    public static final String HOST_NAME = "jboss.host.name";
    public static final String QUALIFIED_HOST_NAME = "jboss.qualified.host.name";
    private final LaunchType launchType;
    private final String qualifiedHostName;
    private final String hostName;
    private final String serverName;
    private final String nodeName;
    private final File[] javaExtDirs;
    private final File homeDir;
    private final File modulesDir;
    private final File serverBaseDir;
    private final File serverConfigurationDir;
    private final ConfigurationFile serverConfigurationFile;
    private final File serverDataDir;
    private final File serverDeployDir;
    private final File serverLogDir;
    private final File serverTempDir;
    private final boolean standalone;
    private static final File[] NO_FILES = new File[0];

    public ServerEnvironment(Properties props, Map<String, String> env, String serverConfig, LaunchType launchType) {
        if (props == null) {
            throw new IllegalArgumentException("props is null");
        }
        this.launchType = launchType;
        this.standalone = launchType != LaunchType.DOMAIN;
        String hostName = props.getProperty(HOST_NAME);
        String qualifiedHostName = props.getProperty(QUALIFIED_HOST_NAME);
        if (qualifiedHostName == null) {
            qualifiedHostName = hostName;
            if (qualifiedHostName == null) {
                qualifiedHostName = env.get("HOSTNAME");
            }
            if (qualifiedHostName == null) {
                qualifiedHostName = env.get("COMPUTERNAME");
            }
            if (qualifiedHostName == null) {
                try {
                    qualifiedHostName = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    qualifiedHostName = null;
                }
            }
            if (qualifiedHostName != null && qualifiedHostName.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$|:")) {
                qualifiedHostName = null;
            }
            if (qualifiedHostName == null) {
                qualifiedHostName = "unknown-host.unknown-domain";
            }
            qualifiedHostName = qualifiedHostName.trim().toLowerCase();
        }
        this.qualifiedHostName = qualifiedHostName;
        if (hostName == null) {
            int idx = qualifiedHostName.indexOf(46);
            hostName = idx == -1 ? qualifiedHostName : qualifiedHostName.substring(0, idx);
        }
        this.hostName = hostName;
        String serverName = props.getProperty(SERVER_NAME);
        if (serverName == null) {
            serverName = hostName;
        }
        this.serverName = serverName;
        String nodeName = props.getProperty(NODE_NAME);
        if (nodeName == null) {
            nodeName = serverName;
        }
        this.nodeName = nodeName;
        this.javaExtDirs = this.getFilesFromProperty(JAVA_EXT_DIRS, props);
        this.homeDir = this.getFileFromProperty(HOME_DIR, props);
        if (this.homeDir == null) {
            throw new IllegalStateException("Missing configuration value for: jboss.home.dir");
        }
        File tmp = this.getFileFromProperty(MODULES_DIR, props);
        if (tmp == null) {
            tmp = new File(this.homeDir, "modules");
        }
        this.modulesDir = tmp;
        tmp = this.getFileFromProperty(SERVER_BASE_DIR, props);
        if (tmp == null) {
            tmp = new File(this.homeDir, this.standalone ? "standalone" : "domain/servers/" + serverName);
        }
        this.serverBaseDir = tmp;
        tmp = this.getFileFromProperty(SERVER_CONFIG_DIR, props);
        if (tmp == null) {
            tmp = new File(this.serverBaseDir, "configuration");
        }
        this.serverConfigurationDir = tmp;
        this.serverConfigurationFile = this.standalone ? new ConfigurationFile(this.serverConfigurationDir, "standalone.xml", serverConfig) : null;
        tmp = this.getFileFromProperty(SERVER_DATA_DIR, props);
        if (tmp == null) {
            tmp = new File(this.serverBaseDir, "data");
        }
        this.serverDataDir = tmp;
        tmp = this.getFileFromProperty(SERVER_DEPLOY_DIR, props);
        if (tmp == null) {
            tmp = new File(this.serverDataDir, "content");
        }
        this.serverDeployDir = tmp;
        tmp = this.getFileFromProperty(SERVER_LOG_DIR, props);
        if (tmp == null) {
            tmp = new File(this.serverBaseDir, "log");
        }
        this.serverLogDir = tmp;
        tmp = this.getFileFromProperty(SERVER_TEMP_DIR, props);
        if (tmp == null) {
            tmp = new File(this.serverBaseDir, "tmp");
        }
        this.serverTempDir = tmp;
    }

    void install() {
        SecurityActions.setSystemProperty(QUALIFIED_HOST_NAME, this.qualifiedHostName);
        SecurityActions.setSystemProperty(HOST_NAME, this.hostName);
        SecurityActions.setSystemProperty(SERVER_NAME, this.serverName);
        SecurityActions.setSystemProperty(NODE_NAME, this.nodeName);
        SecurityActions.setSystemProperty(HOME_DIR, this.homeDir.getAbsolutePath());
        SecurityActions.setSystemProperty(MODULES_DIR, this.modulesDir.getAbsolutePath());
        SecurityActions.setSystemProperty(SERVER_BASE_DIR, this.serverBaseDir.getAbsolutePath());
        SecurityActions.setSystemProperty(SERVER_CONFIG_DIR, this.serverConfigurationDir.getAbsolutePath());
        SecurityActions.setSystemProperty(SERVER_DATA_DIR, this.serverDataDir.getAbsolutePath());
        SecurityActions.setSystemProperty(SERVER_DEPLOY_DIR, this.serverDeployDir.getAbsolutePath());
        SecurityActions.setSystemProperty(SERVER_LOG_DIR, this.serverLogDir.getAbsolutePath());
        SecurityActions.setSystemProperty(SERVER_TEMP_DIR, this.serverTempDir.getAbsolutePath());
        try {
            ModuleLoader bootLoader = Module.getBootModuleLoader();
            Module vfsModule = bootLoader.loadModule(ModuleIdentifier.create((String)VFS_MODULE_IDENTIFIER));
            Module.registerURLStreamHandlerFactoryModule((Module)vfsModule);
        }
        catch (Exception ex) {
            log.errorf((Throwable)ex, "Cannot add module '%s' as URLStreamHandlerFactory provider", (Object)VFS_MODULE_IDENTIFIER);
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getQualifiedHostName() {
        return this.qualifiedHostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public File[] getJavaExtDirs() {
        return (File[])this.javaExtDirs.clone();
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    public File getModulesDir() {
        return this.modulesDir;
    }

    public File getServerBaseDir() {
        return this.serverBaseDir;
    }

    public File getServerConfigurationDir() {
        return this.serverConfigurationDir;
    }

    public ConfigurationFile getServerConfigurationFile() {
        return this.serverConfigurationFile;
    }

    public File getServerDataDir() {
        return this.serverDataDir;
    }

    public File getServerDeployDir() {
        return this.serverDeployDir;
    }

    public File getServerLogDir() {
        return this.serverLogDir;
    }

    public File getServerTempDir() {
        return this.serverTempDir;
    }

    public LaunchType getLaunchType() {
        return this.launchType;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    private File getFileFromProperty(String name, Properties props) {
        String value = props.getProperty(name, null);
        if (value != null) {
            File f = new File(value);
            return f;
        }
        return null;
    }

    private File[] getFilesFromProperty(String name, Properties props) {
        String sep = props.getProperty("path.separator");
        String value = props.getProperty(name, null);
        if (value != null) {
            String[] paths = value.split(Pattern.quote(sep));
            int len = paths.length;
            File[] files = new File[len];
            for (int i = 0; i < len; ++i) {
                files[i] = new File(paths[i]);
            }
            return files;
        }
        return NO_FILES;
    }

    public static enum LaunchType {
        DOMAIN,
        STANDALONE,
        EMBEDDED;

    }
}

