/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.AbstractExecutorService;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.BundleStorageState;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.launch.Framework;
import org.osgi.service.startlevel.StartLevel;

public final class StartLevelPlugin
extends AbstractExecutorService<StartLevel>
implements StartLevel {
    static final int BUNDLE_STARTLEVEL_UNSPECIFIED = -1;
    final Logger log = Logger.getLogger(StartLevelPlugin.class);
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<SystemBundleState> injectedSystemBundle = new InjectedValue();
    private final InjectedValue<FrameworkEventsPlugin> injectedFrameworkEvents = new InjectedValue();
    private int initialBundleStartLevel = 1;
    private ServiceRegistration registration;
    private int startLevel = 0;

    static void addService(ServiceTarget serviceTarget) {
        StartLevelPlugin service = new StartLevelPlugin();
        ServiceBuilder builder = serviceTarget.addService(Services.START_LEVEL, (Service)service);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.addDependency(InternalServices.FRAMEWORK_EVENTS_PLUGIN, FrameworkEventsPlugin.class, service.injectedFrameworkEvents);
        builder.addDependency(Services.SYSTEM_BUNDLE, SystemBundleState.class, service.injectedSystemBundle);
        builder.addDependency(Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private StartLevelPlugin() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        BundleContext systemContext = ((SystemBundleState)this.injectedSystemBundle.getValue()).getBundleContext();
        this.registration = systemContext.registerService(StartLevel.class.getName(), (Object)this, null);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.registration.unregister();
        this.registration = null;
    }

    public StartLevelPlugin getValue() {
        return this;
    }

    @Override
    ExecutorService createExecutorService() {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable run) {
                Thread thread = new Thread(run);
                thread.setName("OSGi StartLevel Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public synchronized int getStartLevel() {
        return this.startLevel;
    }

    public synchronized void setStartLevel(final int level) {
        final FrameworkEventsPlugin eventsPlugin = (FrameworkEventsPlugin)((Object)this.injectedFrameworkEvents.getValue());
        final AbstractBundleState bundleState = (AbstractBundleState)this.injectedSystemBundle.getValue();
        if (level > this.getStartLevel()) {
            this.log.infof("About to increase start level from %s to %s", (Object)this.getStartLevel(), (Object)level);
            this.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    StartLevelPlugin.this.log.infof("Increasing start level from %s to %s", (Object)StartLevelPlugin.this.getStartLevel(), (Object)level);
                    StartLevelPlugin.this.increaseStartLevel(level);
                    eventsPlugin.fireFrameworkEvent(bundleState, 8, null);
                }
            });
        } else if (level < this.getStartLevel()) {
            this.log.infof("About to decrease start level from %s to %s", (Object)this.getStartLevel(), (Object)level);
            this.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    StartLevelPlugin.this.log.infof("Decreasing start level from %s to %s", (Object)StartLevelPlugin.this.getStartLevel(), (Object)level);
                    StartLevelPlugin.this.decreaseStartLevel(level);
                    eventsPlugin.fireFrameworkEvent(bundleState, 8, null);
                }
            });
        }
    }

    public int getBundleStartLevel(Bundle bundle) {
        if (bundle instanceof Framework) {
            return 0;
        }
        AbstractBundleState b = AbstractBundleState.assertBundleState(bundle);
        if (b instanceof SystemBundleState) {
            return 0;
        }
        if (b instanceof HostBundleState) {
            return ((HostBundleState)b).getStartLevel();
        }
        return -1;
    }

    public void setBundleStartLevel(Bundle bundle, int level) {
        if (bundle.getBundleId() == 0L) {
            throw new IllegalArgumentException("Cannot set the start level of the System Bundle");
        }
        final FrameworkEventsPlugin eventsPlugin = (FrameworkEventsPlugin)((Object)this.injectedFrameworkEvents.getValue());
        final HostBundleState hostBundle = HostBundleState.assertBundleState(bundle);
        hostBundle.setStartLevel(level);
        if (level <= this.getStartLevel() && hostBundle.isPersistentlyStarted()) {
            if ((bundle.getState() & 0x28) > 0) {
                return;
            }
            this.log.infof("Start Level Service about to start: %s", (Object)hostBundle);
            this.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    StartLevelPlugin.this.log.infof("Start Level Service starting: %s", (Object)hostBundle);
                    try {
                        int opts = 1;
                        if (StartLevelPlugin.this.isBundleActivationPolicyUsed(hostBundle)) {
                            opts |= 2;
                        }
                        hostBundle.start(opts);
                    }
                    catch (BundleException e) {
                        eventsPlugin.fireFrameworkEvent(hostBundle, 2, e);
                    }
                }
            });
        } else {
            if ((bundle.getState() & 0x28) == 0) {
                return;
            }
            this.log.infof("Start Level Service about to stop: %s", (Object)hostBundle);
            this.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    StartLevelPlugin.this.log.infof("Start Level Service stopping: %s", (Object)hostBundle);
                    try {
                        hostBundle.stop(1);
                    }
                    catch (BundleException e) {
                        eventsPlugin.fireFrameworkEvent(hostBundle, 2, e);
                    }
                }
            });
        }
    }

    public synchronized int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    public synchronized void setInitialBundleStartLevel(int startlevel) {
        this.initialBundleStartLevel = startlevel;
    }

    public boolean isBundlePersistentlyStarted(Bundle bundle) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle);
        BundleStorageState storageState = bundleState.getBundleStorageState();
        return storageState.isPersistentlyStarted();
    }

    public boolean isBundleActivationPolicyUsed(Bundle bundle) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle);
        BundleStorageState storageState = bundleState.getBundleStorageState();
        return storageState.isBundleActivationPolicyUsed();
    }

    synchronized void increaseStartLevel(int level) {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        Set<AbstractBundleState> bundles = bundleManager.getBundles();
        while (this.startLevel < level) {
            ++this.startLevel;
            this.log.infof("Starting bundles for start level: %s", (Object)this.startLevel);
            for (AbstractBundleState bundle : bundles) {
                HostBundleState hostBundle;
                if (!(bundle instanceof HostBundleState) || (hostBundle = (HostBundleState)bundle).getStartLevel() != this.startLevel || !hostBundle.isPersistentlyStarted()) continue;
                try {
                    int opts = 1;
                    if (this.isBundleActivationPolicyUsed(bundle)) {
                        opts |= 2;
                    }
                    bundle.start(opts);
                }
                catch (Throwable e) {
                    FrameworkEventsPlugin eventsPlugin = (FrameworkEventsPlugin)((Object)this.injectedFrameworkEvents.getValue());
                    eventsPlugin.fireFrameworkEvent(bundle, 2, e);
                }
            }
        }
    }

    synchronized void decreaseStartLevel(int sl) {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        while (this.startLevel > sl) {
            this.log.infof("Stopping bundles for start level: %s", (Object)this.startLevel);
            Set<AbstractBundleState> bundles = bundleManager.getBundles();
            for (AbstractBundleState bundleState : bundles) {
                HostBundleState hostBundle;
                if (!(bundleState instanceof HostBundleState) || (hostBundle = (HostBundleState)bundleState).getStartLevel() != this.startLevel) continue;
                try {
                    bundleState.stopInternal(1);
                }
                catch (Throwable e) {
                    FrameworkEventsPlugin eventsPlugin = (FrameworkEventsPlugin)((Object)this.injectedFrameworkEvents.getValue());
                    eventsPlugin.fireFrameworkEvent(bundleState, 2, e);
                }
            }
            --this.startLevel;
        }
    }
}

