/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.security.Principal;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.security.CacheableManager;
import org.jboss.security.SimplePrincipal;

class SecurityDomainOperations {
    static final String LIST_CACHED_PRINCIPALS = "list-cached-principals";
    static final String FLUSH_CACHE = "flush-cache";
    private static final String PRINCIPAL_ARGUMENT = "principal";
    static final OperationStepHandler LIST_CACHED_PRINCIPALS_OP = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode opAddr = operation.require("address");
            PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
            final String securityDomain = address.getLastElement().getValue();
            if (context.getType() == OperationContext.Type.SERVER) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        ServiceController controller = context.getServiceRegistry(false).getRequiredService(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomain}));
                        if (controller != null) {
                            SecurityDomainContext sdc = (SecurityDomainContext)controller.getValue();
                            CacheableManager manager = (CacheableManager)sdc.getAuthenticationManager();
                            Set cachedPrincipals = manager.getCachedKeys();
                            ModelNode result = context.getResult();
                            for (Principal principal : cachedPrincipals) {
                                result.add(principal.getName());
                            }
                            if (!result.isDefined()) {
                                result.setEmptyList();
                            }
                        } else {
                            context.getResult().set("authentication cache for security domain " + securityDomain + " available");
                        }
                        context.completeStep();
                    }
                }, OperationContext.Stage.RUNTIME);
            } else {
                context.getResult().set("authentication cache for security domain " + securityDomain + " available");
            }
            context.completeStep();
        }
    };
    static final OperationStepHandler FLUSH_CACHE_OP = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode opAddr = operation.require("address");
            PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
            final String securityDomain = address.getLastElement().getValue();
            String principal = null;
            if (operation.hasDefined(SecurityDomainOperations.PRINCIPAL_ARGUMENT)) {
                principal = operation.get(SecurityDomainOperations.PRINCIPAL_ARGUMENT).asString();
            }
            final String principalName = principal;
            if (context.getType() == OperationContext.Type.SERVER) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        ServiceController controller = context.getServiceRegistry(false).getRequiredService(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomain}));
                        if (controller != null) {
                            SecurityDomainContext sdc = (SecurityDomainContext)controller.getValue();
                            CacheableManager manager = (CacheableManager)sdc.getAuthenticationManager();
                            if (principalName != null) {
                                manager.flushCache((Object)new SimplePrincipal(principalName));
                            } else {
                                manager.flushCache();
                            }
                        } else {
                            context.getResult().set("authentication cache for security domain " + securityDomain + " available");
                        }
                        context.completeStep();
                    }
                }, OperationContext.Stage.RUNTIME);
            } else {
                context.getResult().set("authentication cache for security domain " + securityDomain + " available");
            }
            context.completeStep();
        }
    };

    SecurityDomainOperations() {
    }
}

