/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.security.Namespace;
import org.jboss.as.security.SecurityDomainAdd;
import org.jboss.as.security.SecurityDomainOperations;
import org.jboss.as.security.SecurityDomainRemove;
import org.jboss.as.security.SecuritySubsystemAdd;
import org.jboss.as.security.SecuritySubsystemDescriptions;
import org.jboss.as.security.SecuritySubsystemParser;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceName;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class SecurityExtension
implements Extension {
    public static final ServiceName JBOSS_SECURITY = ServiceName.JBOSS.append(new String[]{"security"});
    public static final String SUBSYSTEM_NAME = "security";
    private static final SecuritySubsystemParser PARSER = SecuritySubsystemParser.getInstance();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(SecuritySubsystemDescriptions.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)SecuritySubsystemAdd.INSTANCE, SecuritySubsystemDescriptions.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)SecurityDescribeHandler.INSTANCE, SecuritySubsystemDescriptions.SUBSYSTEM_DESCRIBE, false, OperationEntry.EntryType.PRIVATE);
        ManagementResourceRegistration securityDomain = registration.registerSubModel(PathElement.pathElement((String)"security-domain"), SecuritySubsystemDescriptions.SECURITY_DOMAIN);
        securityDomain.registerOperationHandler("add", (OperationStepHandler)SecurityDomainAdd.INSTANCE, SecuritySubsystemDescriptions.SECURITY_DOMAIN_ADD, false);
        securityDomain.registerOperationHandler("remove", (OperationStepHandler)SecurityDomainRemove.INSTANCE, SecuritySubsystemDescriptions.SECURITY_DOMAIN_REMOVE, false);
        securityDomain.registerOperationHandler("list-cached-principals", SecurityDomainOperations.LIST_CACHED_PRINCIPALS_OP, SecuritySubsystemDescriptions.LIST_CACHED_PRINCIPALS);
        securityDomain.registerOperationHandler("flush-cache", SecurityDomainOperations.FLUSH_CACHE_OP, SecuritySubsystemDescriptions.FLUSH_CACHE);
        subsystem.registerXMLElementWriter((XMLElementWriter)PARSER);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)PARSER);
    }

    private static class SecurityDescribeHandler
    implements OperationStepHandler {
        static final SecurityDescribeHandler INSTANCE = new SecurityDescribeHandler();

        private SecurityDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").add("subsystem", SecurityExtension.SUBSYSTEM_NAME);
            if (model.hasDefined("authentication-manager-class-name")) {
                subsystem.get("authentication-manager-class-name").set(model.get("authentication-manager-class-name"));
            }
            if (model.hasDefined("deep-copy-subject-mode")) {
                subsystem.get("deep-copy-subject-mode").set(model.get("deep-copy-subject-mode"));
            }
            if (model.hasDefined("default-callback-handler-class-name")) {
                subsystem.get("default-callback-handler-class-name").set(model.get("default-callback-handler-class-name"));
            }
            if (model.hasDefined("subject-factory-class-name")) {
                subsystem.get("subject-factory-class-name").set(model.get("subject-factory-class-name"));
            }
            if (model.hasDefined("authorization-manager-class-name")) {
                subsystem.get("authorization-manager-class-name").set(model.get("authorization-manager-class-name"));
            }
            if (model.hasDefined("audit-manager-class-name")) {
                subsystem.get("audit-manager-class-name").set(model.get("audit-manager-class-name"));
            }
            if (model.hasDefined("identity-trust-manager-class-name")) {
                subsystem.get("identity-trust-manager-class-name").set(model.get("identity-trust-manager-class-name"));
            }
            if (model.hasDefined("mapping-manager-class-name")) {
                subsystem.get("mapping-manager-class-name").set(model.get("mapping-manager-class-name"));
            }
            if (model.hasDefined("security-properties")) {
                subsystem.get("security-properties").set(model.get("security-properties"));
            }
            ModelNode result = context.getResult();
            result.add(subsystem);
            if (model.hasDefined("security-domain")) {
                for (Property prop : model.get("security-domain").asPropertyList()) {
                    ModelNode addr = subsystem.get("address").clone().add("security-domain", prop.getName());
                    result.add(SecurityDomainAdd.getRecreateOperation(addr, prop.getValue()));
                }
            }
            context.completeStep();
        }
    }
}

