/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ra.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.MergeUtil;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.ra.AuthenticationMechanism;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.MergeableMetadata;
import org.jboss.jca.common.api.metadata.ra.OutboundResourceAdapter;

public class OutboundResourceAdapterImpl
implements OutboundResourceAdapter {
    private static final long serialVersionUID = 421345307326415666L;
    private ArrayList<ConnectionDefinition> connectionDefinition;
    private TransactionSupportEnum transactionSupport;
    private final ArrayList<AuthenticationMechanism> authenticationMechanism;
    private final boolean reauthenticationSupport;
    private final String id;

    public OutboundResourceAdapterImpl(List<ConnectionDefinition> connectionDefinition, TransactionSupportEnum transactionSupport, List<AuthenticationMechanism> authenticationMechanism, boolean reauthenticationSupport, String id) {
        if (connectionDefinition != null) {
            this.connectionDefinition = new ArrayList(connectionDefinition.size());
            this.connectionDefinition.addAll(connectionDefinition);
        } else {
            this.connectionDefinition = new ArrayList(0);
        }
        this.transactionSupport = transactionSupport;
        if (authenticationMechanism != null) {
            this.authenticationMechanism = new ArrayList(authenticationMechanism.size());
            this.authenticationMechanism.addAll(authenticationMechanism);
        } else {
            this.authenticationMechanism = new ArrayList(0);
        }
        this.reauthenticationSupport = reauthenticationSupport;
        this.id = id;
    }

    public synchronized List<ConnectionDefinition> getConnectionDefinitions() {
        return this.connectionDefinition == null ? null : Collections.unmodifiableList(this.connectionDefinition);
    }

    public synchronized void forceConnectionDefinitionsContent(List<ConnectionDefinition> newContent) {
        if (newContent != null) {
            this.connectionDefinition = new ArrayList(newContent.size());
            this.connectionDefinition.addAll(newContent);
        } else {
            this.connectionDefinition = new ArrayList(0);
        }
    }

    public synchronized TransactionSupportEnum getTransactionSupport() {
        return this.transactionSupport;
    }

    public synchronized void forceNewTrasactionSupport(TransactionSupportEnum newTransactionSupport) {
        this.transactionSupport = newTransactionSupport;
    }

    public List<AuthenticationMechanism> getAuthenticationMechanisms() {
        return this.authenticationMechanism == null ? null : Collections.unmodifiableList(this.authenticationMechanism);
    }

    public boolean getReauthenticationSupport() {
        return this.reauthenticationSupport;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authenticationMechanism == null ? 0 : this.authenticationMechanism.hashCode());
        result = 31 * result + (this.connectionDefinition == null ? 0 : this.connectionDefinition.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.transactionSupport == null ? 0 : this.transactionSupport.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutboundResourceAdapterImpl)) {
            return false;
        }
        OutboundResourceAdapterImpl other = (OutboundResourceAdapterImpl)obj;
        if (this.authenticationMechanism == null ? other.authenticationMechanism != null : !this.authenticationMechanism.equals(other.authenticationMechanism)) {
            return false;
        }
        if (this.connectionDefinition == null ? other.connectionDefinition != null : !this.connectionDefinition.equals(other.connectionDefinition)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.reauthenticationSupport != other.reauthenticationSupport) {
            return false;
        }
        return this.transactionSupport == other.transactionSupport;
    }

    public String toString() {
        return "OutboundResourceAdapter [connectionDefinition=" + this.connectionDefinition + ", transactionSupport=" + this.transactionSupport + ", authenticationMechanism=" + this.authenticationMechanism + ", reauthenticationSupport=" + this.reauthenticationSupport + ", id=" + this.id + "]";
    }

    public boolean validationAsBoolean() {
        if (this.getConnectionDefinitions() == null || this.getConnectionDefinitions().size() == 0) {
            return false;
        }
        ConnectionDefinition cdm = this.getConnectionDefinitions().get(0);
        return cdm.getManagedConnectionFactoryClass() != null && cdm.getConnectionFactoryInterface() != null && cdm.getConnectionFactoryImplClass() != null && cdm.getConnectionInterface() != null && cdm.getConnectionImplClass() != null;
    }

    public OutboundResourceAdapter merge(MergeableMetadata<?> jmd) throws Exception {
        if (jmd instanceof OutboundResourceAdapterImpl) {
            OutboundResourceAdapterImpl input = (OutboundResourceAdapterImpl)jmd;
            String newId = this.id == null ? input.id : this.id;
            ArrayList<ConnectionDefinition> newConnDef = new ArrayList<ConnectionDefinition>(this.connectionDefinition.size());
            newConnDef.addAll(this.connectionDefinition);
            for (ConnectionDefinition rcd : input.connectionDefinition) {
                boolean isNew = true;
                for (ConnectionDefinition lcd : this.connectionDefinition) {
                    if (lcd.getManagedConnectionFactoryClass() != null && !rcd.getManagedConnectionFactoryClass().equals((Object)lcd.getManagedConnectionFactoryClass())) continue;
                    newConnDef.remove(lcd);
                    newConnDef.add((ConnectionDefinition)lcd.merge((MergeableMetadata)rcd));
                    isNew = false;
                }
                if (!isNew) continue;
                newConnDef.add(rcd);
            }
            TransactionSupportEnum newTransactionSupport = this.transactionSupport == null ? input.transactionSupport : this.transactionSupport;
            boolean newReauthenticationSupport = this.reauthenticationSupport || input.reauthenticationSupport;
            List newAuthenticationMechanism = MergeUtil.mergeList(this.authenticationMechanism, input.authenticationMechanism);
            return new OutboundResourceAdapterImpl(newConnDef, newTransactionSupport, newAuthenticationMechanism, newReauthenticationSupport, newId);
        }
        return this;
    }

    public CopyableMetaData copy() {
        return new OutboundResourceAdapterImpl(CopyUtil.cloneList(this.connectionDefinition), this.transactionSupport, CopyUtil.cloneList(this.authenticationMechanism), this.reauthenticationSupport, CopyUtil.cloneString((String)this.id));
    }
}

