/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.logging.Logger;
import org.xnio.AbstractChannelThread;
import org.xnio.ChannelThread;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.nio.Log;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioSetter;
import org.xnio.nio.SelectorTask;
import org.xnio.nio.SynchronousHolder;

abstract class AbstractNioChannelThread
extends AbstractChannelThread {
    private static final Logger log = Logger.getLogger((String)"org.xnio.nio.channel-thread");
    private static final long LONGEST_DELAY = 9223372036853L;
    private volatile int keyLoad;
    private volatile boolean shutdown;
    private final Selector selector;
    private final Object workLock = new Object();
    private final Queue<SelectorTask> selectorWorkQueue = new ArrayDeque<SelectorTask>();
    private final Set<TimeKey> delayWorkQueue = new TreeSet<TimeKey>();
    protected final Thread thread;
    private final Runnable task = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            selector = AbstractNioChannelThread.access$000(AbstractNioChannelThread.this);
            lock = AbstractNioChannelThread.access$100(AbstractNioChannelThread.this);
            workQueue = AbstractNioChannelThread.access$200(AbstractNioChannelThread.this);
            delayQueue = AbstractNioChannelThread.access$300(AbstractNioChannelThread.this);
            AbstractNioChannelThread.access$400().debugf("Started channel thread '%s', selector %s", (Object)Thread.currentThread().getName(), (Object)selector);
            runQueue = new ArrayDeque<Runnable>();
            try {
                while (true) {
                    block23: {
                        var13_12 = lock;
                        synchronized (var13_12) {
                            task = (SelectorTask)workQueue.poll();
                            if (task == null) {
                                iterator = delayQueue.iterator();
                                delayTime = 0x7FFFFFFFFFFFFFFFL;
                                if (iterator.hasNext()) {
                                    now = System.nanoTime();
                                    do {
                                        if (TimeKey.access$500(key = (TimeKey)iterator.next()) > now) {
                                            delayTime = TimeKey.access$500(key) - now;
                                            break;
                                        }
                                        runQueue.add(TimeKey.access$600(key));
                                        iterator.remove();
                                    } while (iterator.hasNext());
                                }
                                break block23;
                            }
                        }
                        AbstractNioChannelThread.access$700(selector, task);
                        continue;
                    }
                    while ((command = (Runnable)runQueue.poll()) != null) {
                        AbstractNioChannelThread.access$800(command);
                    }
                    if (AbstractNioChannelThread.access$900(AbstractNioChannelThread.this)) {
                        var13_12 = lock;
                        synchronized (var13_12) {
                            block24: {
                                if (AbstractNioChannelThread.access$1002(AbstractNioChannelThread.this, selector.keys().size()) != 0 || !workQueue.isEmpty() || !delayQueue.isEmpty()) break block24;
                                Log.log.tracef("Shutting down channel thread \"%s\"", (Object)AbstractNioChannelThread.this);
                                return;
                            }
                            ** try [egrp 4[TRYBLOCK] [4 : 313->319)] { 
                            {
                            }
                        }
                    }
lbl48:
                    // 3 sources

                    try {
                        if (delayTime == 0x7FFFFFFFFFFFFFFFL) {
                            Log.log.tracef("Beginning select on %s", (Object)selector);
                            selector.select();
                        } else {
                            millis = 1L + delayTime / 1000000L;
                            Log.log.tracef("Beginning select on %s (with timeout)", (Object)selector);
                            selector.select(millis);
                        }
                    }
                    catch (IOException e) {
                        AbstractNioChannelThread.access$400().warnf("Received an I/O error on selection: %s", (Object)e);
                    }
                    Log.log.tracef("Selected on %s", (Object)selector);
                    selectedKeys = selector.selectedKeys();
                    keyIterator = new ArrayList<SelectionKey>(selectedKeys).iterator();
                    while (true) {
                        if (!keyIterator.hasNext()) ** break;
                        key = keyIterator.next();
                        Log.log.tracef("Selected key %s", (Object)key);
                        ((NioHandle)key.attachment()).invoke();
                        selectedKeys.remove(key);
                    }
                    break;
                }
            }
            finally {
                IoUtils.safeClose((Selector)selector);
                AbstractNioChannelThread.this.done();
            }
        }
    };
    private static final Thread.UncaughtExceptionHandler HANDLER = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.errorf(e, "Thread named \"%s\" threw an uncaught exception", (Object)t);
        }
    };

    private static void safeRun(Selector selector, SelectorTask task) {
        try {
            log.tracef("Running selector task %s on %s", (Object)task, (Object)selector);
            task.run(selector);
        }
        catch (Throwable t) {
            log.error((Object)"Task failed on channel thread", t);
        }
    }

    private static void safeRun(Runnable command) {
        try {
            log.tracef("Running task %s", (Object)command);
            command.run();
        }
        catch (Throwable t) {
            log.error((Object)"Task failed on channel thread", t);
        }
    }

    protected AbstractNioChannelThread(ThreadGroup threadGroup, OptionMap optionMap) throws IOException {
        String threadName = optionMap.contains(Options.THREAD_NAME) ? (String)optionMap.get(Options.THREAD_NAME) : this.generateName();
        Thread thread = new Thread(threadGroup, this.task, threadName, optionMap.get(Options.STACK_SIZE, 0L));
        thread.setDaemon(optionMap.get(Options.THREAD_DAEMON, false));
        thread.setPriority(optionMap.get(Options.THREAD_PRIORITY, 5));
        thread.setContextClassLoader(null);
        thread.setUncaughtExceptionHandler(HANDLER);
        this.thread = thread;
        this.selector = Selector.open();
        log.tracef("Creating channel thread '%s', selector %s", (Object)this, (Object)this.selector);
    }

    protected abstract String generateName();

    protected void start() {
        this.thread.start();
    }

    protected void startShutdown() {
        this.shutdown = true;
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final Runnable command) {
        Object object = this.workLock;
        synchronized (object) {
            this.selectorWorkQueue.add(new SelectorTask(){

                @Override
                public void run(Selector selector) {
                    AbstractNioChannelThread.safeRun(command);
                }
            });
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelThread.Key executeAfter(Runnable command, long time) {
        if (this.shutdown) {
            throw new RejectedExecutionException("Thread is terminating");
        }
        if (time <= 0L) {
            this.execute(command);
            return ChannelThread.Key.IMMEDIATE;
        }
        Object object = this.workLock;
        synchronized (object) {
            long deadline = time > 9223372036853L ? System.nanoTime() + 9223372036853L : System.nanoTime() + time * 1000000L;
            TimeKey key = new TimeKey(deadline, command);
            this.delayWorkQueue.add(key);
            if (this.delayWorkQueue.iterator().next() == key) {
                this.selector.wakeup();
            }
            return key;
        }
    }

    void done() {
        this.shutdownFinished();
    }

    public int getLoad() {
        return this.keyLoad;
    }

    <C extends Channel> NioHandle<C> addChannel(final AbstractSelectableChannel channel, final C xnioChannel, final int ops, final NioSetter<C> setter) throws ClosedChannelException {
        log.tracef("Adding channel %s to %s for XNIO channel %s", (Object)channel, (Object)this, xnioChannel);
        if (this.thread == Thread.currentThread()) {
            if (this.shutdown) {
                throw new IllegalStateException(String.format("Cannot add channel %s to %s (stopping)", new Object[]{xnioChannel, this}));
            }
            SelectionKey key = channel.register(this.selector, ops);
            NioHandle<C> handle = new NioHandle<C>(key, this, setter, xnioChannel);
            key.attach(handle);
            key.interestOps(ops);
            return handle;
        }
        final SynchronousHolder holder = new SynchronousHolder(ClosedChannelException.class);
        this.queueTask(new SelectorTask(){

            @Override
            public void run(Selector selector) {
                try {
                    if (AbstractNioChannelThread.this.shutdown) {
                        holder.setProblem(new IllegalStateException(String.format("Cannot add channel %s to %s (stopping)", new Object[]{xnioChannel, AbstractNioChannelThread.this})));
                        return;
                    }
                    SelectionKey key = channel.register(selector, ops);
                    NioHandle<Channel> handle = new NioHandle<Channel>(key, AbstractNioChannelThread.this, setter, xnioChannel);
                    key.attach(handle);
                    key.interestOps(ops);
                    holder.set(handle);
                }
                catch (ClosedChannelException e) {
                    holder.setProblem(e);
                }
            }
        });
        this.selector.wakeup();
        return (NioHandle)holder.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueTask(SelectorTask task) {
        Object object = this.workLock;
        synchronized (object) {
            this.selectorWorkQueue.add(task);
        }
    }

    void cancelKey(final SelectionKey key) {
        if (this.thread == Thread.currentThread()) {
            log.tracef("Cancelling key %s of %s from same thread", (Object)key, (Object)key.channel());
            key.cancel();
            try {
                this.selector.selectNow();
            }
            catch (IOException e) {
                log.warnf("Received an I/O error on selection: %s", (Object)e);
            }
        } else {
            this.queueTask(new SelectorTask(){

                @Override
                public void run(Selector selector) {
                    log.tracef("Cancelling key %s of %s from queue", (Object)key, (Object)key.channel());
                    key.cancel();
                    try {
                        selector.selectNow();
                    }
                    catch (IOException e) {
                        log.warnf("Received an I/O error on selection: %s", (Object)e);
                    }
                }
            });
            log.tracef("Enqueued cancellation of key '%s'", (Object)key);
            this.selector.wakeup();
        }
    }

    void setOps(final SelectionKey key, final int ops) {
        if (this.thread == Thread.currentThread()) {
            try {
                key.interestOps(ops);
            }
            catch (CancelledKeyException cancelledKeyException) {}
        } else {
            this.queueTask(new SelectorTask(){

                @Override
                public void run(Selector selector) {
                    try {
                        key.interestOps(ops);
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        // empty catch block
                    }
                }
            });
            this.selector.wakeup();
        }
    }

    public String toString() {
        return String.format("Channel thread \"%s\"", this.thread.getName());
    }

    static /* synthetic */ Selector access$000(AbstractNioChannelThread x0) {
        return x0.selector;
    }

    static /* synthetic */ Queue access$200(AbstractNioChannelThread x0) {
        return x0.selectorWorkQueue;
    }

    static /* synthetic */ void access$700(Selector x0, SelectorTask x1) {
        AbstractNioChannelThread.safeRun(x0, x1);
    }

    static /* synthetic */ int access$1002(AbstractNioChannelThread x0, int x1) {
        x0.keyLoad = x1;
        return x0.keyLoad;
    }

    final class TimeKey
    implements ChannelThread.Key {
        private final long deadline;
        private final Runnable command;

        TimeKey(long deadline, Runnable command) {
            this.deadline = deadline;
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove() {
            Object object = AbstractNioChannelThread.this.workLock;
            synchronized (object) {
                return AbstractNioChannelThread.this.delayWorkQueue.remove(this);
            }
        }

        static /* synthetic */ long access$500(TimeKey x0) {
            return x0.deadline;
        }

        static /* synthetic */ Runnable access$600(TimeKey x0) {
            return x0.command;
        }
    }
}

