/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx2.impl;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Random;
import javax.ejb.ApplicationException;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb3.tx2.spi.TransactionalComponent;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionTimeoutConfiguration;
import org.jboss.util.deadlock.ApplicationDeadlockException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CMTTxInterceptor {
    private static final Logger log = Logger.getLogger(CMTTxInterceptor.class);
    private static final int MAX_RETRIES = 5;
    private static final Random RANDOM = new Random();

    protected abstract TransactionalComponent getTransactionalComponent();

    protected void endTransaction(TransactionManager tm, Transaction tx) {
        try {
            if (tx != tm.getTransaction()) {
                throw new IllegalStateException("Wrong tx on thread: expected " + tx + ", actual " + tm.getTransaction());
            }
            if (tx.getStatus() == 1) {
                tm.rollback();
            } else {
                tm.commit();
            }
        }
        catch (RollbackException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
        catch (HeuristicMixedException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
        catch (HeuristicRollbackException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
        catch (SystemException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
    }

    protected int getCurrentTransactionTimeout() throws SystemException {
        TransactionManager tm = this.getTransactionManager();
        if (tm instanceof TransactionTimeoutConfiguration) {
            return ((TransactionTimeoutConfiguration)tm).getTransactionTimeout();
        }
        return 0;
    }

    protected void handleEndTransactionException(Exception e) {
        if (e instanceof RollbackException) {
            throw new EJBTransactionRolledbackException("Transaction rolled back", e);
        }
        throw new EJBException(e);
    }

    protected void handleInCallerTx(InvocationContext invocation, Throwable t, Transaction tx) throws Exception {
        ApplicationException ae = this.getApplicationException(t.getClass());
        if (ae != null) {
            if (ae.rollback()) {
                this.setRollbackOnly(tx);
            }
            throw (Exception)t;
        }
        if (!(t instanceof EJBTransactionRolledbackException)) {
            if (t instanceof Error) {
                Throwable cause = t;
                t = new EJBTransactionRolledbackException("Unexpected Error");
                t.initCause(cause);
            } else if (!(t instanceof EJBException) && !(t instanceof RemoteException)) {
                if (t instanceof RuntimeException) {
                    t = new EJBTransactionRolledbackException(t.getMessage(), (Exception)t);
                } else {
                    throw (Exception)t;
                }
            }
        }
        this.setRollbackOnly(tx);
        log.error((Object)t);
        throw (Exception)t;
    }

    public void handleExceptionInOurTx(InvocationContext invocation, Throwable t, Transaction tx) throws Exception {
        ApplicationException ae = this.getApplicationException(t.getClass());
        if (ae != null) {
            if (ae.rollback()) {
                this.setRollbackOnly(tx);
            }
            throw (Exception)t;
        }
        if (!(t instanceof EJBException) && !(t instanceof RemoteException)) {
            if (t instanceof Error) {
                Throwable cause = t;
                t = new EJBException("Unexpected Error");
                t.initCause(cause);
            } else if (t instanceof RuntimeException) {
                t = new EJBException((Exception)t);
            } else {
                throw (Exception)t;
            }
        }
        this.setRollbackOnly(tx);
        throw (Exception)t;
    }

    @AroundInvoke
    public Object invoke(InvocationContext invocation) throws Exception {
        Method invokedMethod = invocation.getMethod();
        TransactionAttributeType txAttr = this.getTransactionalComponent().getTransactionAttributeType(invokedMethod);
        switch (txAttr) {
            case MANDATORY: {
                return this.mandatory(invocation);
            }
            case NEVER: {
                return this.never(invocation);
            }
            case NOT_SUPPORTED: {
                return this.notSupported(invocation);
            }
            case REQUIRED: {
                return this.required(invocation);
            }
            case REQUIRES_NEW: {
                return this.requiresNew(invocation);
            }
            case SUPPORTS: {
                return this.supports(invocation);
            }
        }
        throw new IllegalStateException("Unexpected tx attribute " + txAttr + " on " + invocation);
    }

    protected Object invokeInCallerTx(InvocationContext invocation, Transaction tx) throws Exception {
        try {
            return invocation.proceed();
        }
        catch (Throwable t) {
            this.handleInCallerTx(invocation, t, tx);
            throw new RuntimeException("UNREACHABLE");
        }
    }

    protected Object invokeInNoTx(InvocationContext invocation) throws Exception {
        return invocation.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInOurTx(InvocationContext invocation, TransactionManager tm) throws Exception {
        for (int i = 0; i < 5; ++i) {
            tm.begin();
            Transaction tx = tm.getTransaction();
            try {
                Object object = invocation.proceed();
                this.endTransaction(tm, tx);
                return object;
            }
            catch (Throwable t) {
                try {
                    try {
                        this.handleExceptionInOurTx(invocation, t, tx);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.endTransaction(tm, tx);
                    }
                }
                catch (Exception ex) {
                    ApplicationDeadlockException deadlock = ApplicationDeadlockException.isADE((Throwable)ex);
                    if (deadlock != null) {
                        if (!deadlock.retryable() || i + 1 >= 5) {
                            throw deadlock;
                        }
                        log.warn((Object)(deadlock.getMessage() + " retrying " + (i + 1)));
                        Thread.sleep(RANDOM.nextInt(1 + i), RANDOM.nextInt(1000));
                        continue;
                    }
                    throw ex;
                }
            }
        }
        throw new RuntimeException("UNREACHABLE");
    }

    protected Object mandatory(InvocationContext invocation) throws Exception {
        TransactionManager tm = this.getTransactionManager();
        Transaction tx = tm.getTransaction();
        if (tx == null) {
            throw new EJBTransactionRequiredException("Transaction is required for invocation: " + invocation);
        }
        return this.invokeInCallerTx(invocation, tx);
    }

    protected Object never(InvocationContext invocation) throws Exception {
        TransactionManager tm = this.getTransactionManager();
        if (tm.getTransaction() != null) {
            throw new EJBException("Transaction present on server in Never call (EJB3 13.6.2.6)");
        }
        return this.invokeInNoTx(invocation);
    }

    protected Object notSupported(InvocationContext invocation) throws Exception {
        TransactionManager tm = this.getTransactionManager();
        Transaction tx = tm.getTransaction();
        if (tx != null) {
            tm.suspend();
            try {
                Object object = this.invokeInNoTx(invocation);
                return object;
            }
            catch (Exception e) {
                if (this.getApplicationException(e.getClass()) != null) {
                    throw e;
                }
                throw new EJBException(e);
            }
            finally {
                tm.resume(tx);
            }
        }
        return this.invokeInNoTx(invocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object required(InvocationContext invocation) throws Exception {
        int oldTimeout = this.getCurrentTransactionTimeout();
        Method invokedMethod = invocation.getMethod();
        int timeout = this.getTransactionalComponent().getTransactionTimeout(invokedMethod);
        TransactionManager tm = this.getTransactionManager();
        try {
            Transaction tx;
            if (timeout != -1 && tm != null) {
                tm.setTransactionTimeout(timeout);
            }
            if ((tx = tm.getTransaction()) == null) {
                Object object = this.invokeInOurTx(invocation, tm);
                return object;
            }
            Object object = this.invokeInCallerTx(invocation, tx);
            return object;
        }
        finally {
            if (tm != null) {
                tm.setTransactionTimeout(oldTimeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object requiresNew(InvocationContext invocation) throws Exception {
        int oldTimeout = this.getCurrentTransactionTimeout();
        Method invokedMethod = invocation.getMethod();
        int timeout = this.getTransactionalComponent().getTransactionTimeout(invokedMethod);
        TransactionManager tm = this.getTransactionManager();
        try {
            Transaction tx;
            if (timeout != -1 && tm != null) {
                tm.setTransactionTimeout(timeout);
            }
            if ((tx = tm.getTransaction()) != null) {
                tm.suspend();
                try {
                    Object object = this.invokeInOurTx(invocation, tm);
                    return object;
                }
                finally {
                    tm.resume(tx);
                }
            }
            Object object = this.invokeInOurTx(invocation, tm);
            return object;
        }
        finally {
            if (tm != null) {
                tm.setTransactionTimeout(oldTimeout);
            }
        }
    }

    protected void setRollbackOnly(Transaction tx) {
        try {
            tx.setRollbackOnly();
        }
        catch (SystemException ex) {
            log.error((Object)"SystemException while setting transaction for rollback only", (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            log.error((Object)"IllegalStateException while setting transaction for rollback only", (Throwable)ex);
        }
    }

    protected Object supports(InvocationContext invocation) throws Exception {
        Transaction tx = this.getTransactionManager().getTransaction();
        if (tx == null) {
            return this.invokeInNoTx(invocation);
        }
        return this.invokeInCallerTx(invocation, tx);
    }

    private TransactionManager getTransactionManager() {
        return this.getTransactionalComponent().getTransactionManager();
    }

    private ApplicationException getApplicationException(Class<?> exceptionClass) {
        TransactionalComponent txComponent = this.getTransactionalComponent();
        return txComponent.getApplicationException(exceptionClass);
    }
}

