/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.Closeable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleManagerService;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleId;
import org.jboss.osgi.framework.internal.BundleStorageState;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.FragmentBundleInstalledService;
import org.jboss.osgi.framework.internal.FragmentBundleResolvedService;
import org.jboss.osgi.framework.internal.FrameworkBuilder;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleActiveService;
import org.jboss.osgi.framework.internal.HostBundleInstalledService;
import org.jboss.osgi.framework.internal.HostBundleResolvedService;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.SecurityActions;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.util.Java;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XVersionRange;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public final class BundleManager
extends AbstractService<BundleManagerService>
implements BundleManagerService {
    static final Logger log = Logger.getLogger(BundleManager.class);
    private static String OSGi_FRAMEWORK_EXECUTIONENVIRONMENT;
    private static String OSGi_FRAMEWORK_LANGUAGE;
    private static String OSGi_FRAMEWORK_OS_NAME;
    private static String OSGi_FRAMEWORK_OS_VERSION;
    private static String OSGi_FRAMEWORK_PROCESSOR;
    private static String OSGi_FRAMEWORK_VENDOR;
    private static String OSGi_FRAMEWORK_VERSION;
    private static String implementationTitle;
    private static String implementationVersion;
    final InjectedValue<FrameworkState> injectedFramework = new InjectedValue();
    final InjectedValue<SystemBundleState> injectedSystemBundle = new InjectedValue();
    private final FrameworkBuilder frameworkBuilder;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final AtomicLong identityGenerator = new AtomicLong();
    private final AtomicBoolean shutdownInitiated = new AtomicBoolean();
    private final Map<Long, AbstractBundleState> bundleMap = Collections.synchronizedMap(new HashMap());
    private final ServiceTarget serviceTarget;
    private ServiceContainer serviceContainer;

    static BundleManager addService(ServiceTarget serviceTarget, FrameworkBuilder frameworkBuilder) {
        BundleManager service = new BundleManager(frameworkBuilder, serviceTarget);
        ServiceBuilder builder = serviceTarget.addService(Services.BUNDLE_MANAGER, (Service)service);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
        return service;
    }

    private BundleManager(FrameworkBuilder frameworkBuilder, ServiceTarget serviceTarget) {
        this.frameworkBuilder = frameworkBuilder;
        this.serviceTarget = serviceTarget;
        this.properties.putAll(frameworkBuilder.getProperties());
        if (this.getProperty("org.osgi.framework.executionenvironment") == null) {
            this.setProperty("org.osgi.framework.executionenvironment", OSGi_FRAMEWORK_EXECUTIONENVIRONMENT);
        }
        if (this.getProperty("org.osgi.framework.language") == null) {
            this.setProperty("org.osgi.framework.language", OSGi_FRAMEWORK_LANGUAGE);
        }
        if (this.getProperty("org.osgi.framework.os.name") == null) {
            this.setProperty("org.osgi.framework.os.name", OSGi_FRAMEWORK_OS_NAME);
        }
        if (this.getProperty("org.osgi.framework.os.version") == null) {
            this.setProperty("org.osgi.framework.os.version", OSGi_FRAMEWORK_OS_VERSION);
        }
        if (this.getProperty("org.osgi.framework.processor") == null) {
            this.setProperty("org.osgi.framework.processor", OSGi_FRAMEWORK_PROCESSOR);
        }
        if (this.getProperty("org.osgi.framework.vendor") == null) {
            this.setProperty("org.osgi.framework.vendor", OSGi_FRAMEWORK_VENDOR);
        }
        if (this.getProperty("org.osgi.framework.version") == null) {
            this.setProperty("org.osgi.framework.version", OSGi_FRAMEWORK_VERSION);
        }
        log.debugf("Framework properties", new Object[0]);
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            log.debugf(" %s = %s", (Object)entry.getKey(), entry.getValue());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                BundleManager.this.shutdownInitiated.set(true);
            }
        });
    }

    public void start(StartContext context) throws StartException {
        super.start(context);
        log.infof(implementationTitle + " - " + implementationVersion, new Object[0]);
        this.serviceContainer = context.getController().getServiceContainer();
    }

    public void stop(StopContext context) {
        super.stop(context);
    }

    public BundleManager getValue() throws IllegalStateException {
        return this;
    }

    FrameworkBuilder getFrameworkBuilder() {
        return this.frameworkBuilder;
    }

    ServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }

    ServiceTarget getServiceTarget() {
        return this.serviceTarget;
    }

    SystemBundleState getSystemBundle() {
        return (SystemBundleState)this.injectedSystemBundle.getValue();
    }

    boolean isFrameworkActive() {
        return !this.shutdownInitiated.get() && this.getFrameworkState() != null;
    }

    void assertFrameworkActive() {
        if (!this.isFrameworkActive()) {
            throw new IllegalStateException("Framework not ACTIVE");
        }
    }

    FrameworkState getFrameworkState() {
        return (FrameworkState)this.injectedFramework.getOptionalValue();
    }

    Object getProperty(String key) {
        Object value = this.properties.get(key);
        if (value == null) {
            value = SecurityActions.getSystemProperty(key, null);
        }
        return value;
    }

    Map<String, Object> getProperties() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            m.put(entry.getKey().toString(), entry.getValue());
        }
        m.putAll(this.properties);
        return m;
    }

    void setProperty(String key, Object value) {
        if (this.isFrameworkActive()) {
            throw new IllegalStateException("Cannot add property to ACTIVE framwork");
        }
        this.properties.put(key, value);
    }

    static ServiceName getServiceName(Deployment dep) {
        long bundleId = ((BundleId)dep.getAttachment(BundleId.class)).longValue();
        return BundleManager.getServiceNameInternal(bundleId, dep.getSymbolicName(), Version.parseVersion((String)dep.getVersion()));
    }

    @Override
    public ServiceName getServiceName(Bundle bundle) {
        return BundleManager.getServiceNameInternal(bundle.getBundleId(), bundle.getSymbolicName(), bundle.getVersion());
    }

    private static ServiceName getServiceNameInternal(long bundleId, String symbolicName, Version version) {
        return ServiceName.of((ServiceName)Services.BUNDLE_BASE_NAME, (String[])new String[]{"" + bundleId, "" + symbolicName, "" + version});
    }

    void addBundle(AbstractBundleState bundleState) {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        long bundleId = bundleState.getBundleId();
        if (this.bundleMap.containsKey(bundleId)) {
            throw new IllegalStateException("Bundle already added: " + bundleState);
        }
        log.infof("Install bundle: %s", (Object)bundleState);
        this.bundleMap.put(bundleState.getBundleId(), bundleState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<AbstractBundleState> getBundles() {
        HashSet<AbstractBundleState> result = new HashSet<AbstractBundleState>();
        Map<Long, AbstractBundleState> map = this.bundleMap;
        synchronized (map) {
            for (AbstractBundleState aux : this.bundleMap.values()) {
                if (aux.getState() == 1) continue;
                result.add(aux);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    AbstractBundleState getBundleById(long bundleId) {
        return bundleId == 0L ? this.getFrameworkState().getSystemBundle() : this.bundleMap.get(bundleId);
    }

    AbstractBundleState getBundleByLocation(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Null location");
        }
        for (AbstractBundleState aux : this.getBundles()) {
            String auxLocation = aux.getLocation();
            if (!location.equals(auxLocation)) continue;
            return aux;
        }
        return null;
    }

    @Override
    public Bundle getBundle(ModuleIdentifier identifier) {
        ModuleManagerPlugin moduleManager = this.getFrameworkState().getModuleManagerPlugin();
        AbstractBundleState bundleState = moduleManager.getBundleState(identifier);
        return bundleState != null ? bundleState : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<AbstractBundleState> getBundles(String symbolicName, String versionRange) {
        HashSet<AbstractBundleState> resultSet = new HashSet<AbstractBundleState>();
        Map<Long, AbstractBundleState> map = this.bundleMap;
        synchronized (map) {
            for (AbstractBundleState aux : this.bundleMap.values()) {
                if (symbolicName != null && !symbolicName.equals(aux.getSymbolicName()) || versionRange != null && !XVersionRange.parse((String)versionRange).isInRange(aux.getVersion())) continue;
                resultSet.add(aux);
            }
        }
        return Collections.unmodifiableSet(resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<AbstractBundleState> getBundles(Integer states) {
        HashSet<AbstractBundleState> result = new HashSet<AbstractBundleState>();
        Map<Long, AbstractBundleState> map = this.bundleMap;
        synchronized (map) {
            for (AbstractBundleState aux : this.bundleMap.values()) {
                if (states != null && (aux.getState() & states) == 0) continue;
                result.add(aux);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public ServiceName registerModule(ServiceTarget serviceTarget, Module module, OSGiMetaData metadata) throws BundleException {
        DeploymentFactoryPlugin plugin = this.getFrameworkState().getDeploymentFactoryPlugin();
        Deployment dep = plugin.createDeployment(module, metadata);
        plugin.createOSGiMetaData(dep);
        return this.installBundle(serviceTarget, dep);
    }

    @Override
    public ServiceName installBundle(ServiceTarget serviceTarget, Deployment dep) throws BundleException {
        ServiceName serviceName;
        if (dep == null) {
            throw new IllegalArgumentException("Null deployment");
        }
        AbstractBundleState bundleState = this.getBundleByLocation(dep.getLocation());
        if (bundleState != null) {
            serviceName = bundleState.getServiceName(2);
        } else {
            try {
                BundleStorageState storageState = (BundleStorageState)dep.getAttachment(BundleStorageState.class);
                long bundleId = storageState != null ? storageState.getBundleId() : this.getNextBundleId();
                dep.addAttachment(BundleId.class, (Object)new BundleId(bundleId));
                OSGiMetaData metadata = (OSGiMetaData)dep.getAttachment(OSGiMetaData.class);
                if (metadata == null) {
                    DeploymentFactoryPlugin plugin = this.getFrameworkState().getDeploymentFactoryPlugin();
                    metadata = plugin.createOSGiMetaData(dep);
                }
                if (metadata.getFragmentHost() == null) {
                    serviceName = HostBundleInstalledService.addService(serviceTarget, this.getFrameworkState(), dep);
                    HostBundleResolvedService.addService(serviceTarget, this.getFrameworkState(), serviceName.getParent());
                    HostBundleActiveService.addService(serviceTarget, this.getFrameworkState(), serviceName.getParent());
                } else {
                    serviceName = FragmentBundleInstalledService.addService(serviceTarget, this.getFrameworkState(), dep);
                    FragmentBundleResolvedService.addService(serviceTarget, this.getFrameworkState(), serviceName.getParent());
                }
            }
            catch (RuntimeException rte) {
                VFSUtils.safeClose((Closeable)dep.getRoot());
                throw rte;
            }
            catch (BundleException ex) {
                VFSUtils.safeClose((Closeable)dep.getRoot());
                throw ex;
            }
        }
        dep.addAttachment(ServiceName.class, (Object)serviceName);
        return serviceName;
    }

    long getNextBundleId() {
        return this.identityGenerator.incrementAndGet();
    }

    @Override
    public void uninstallBundle(Deployment dep) {
        Bundle bundle = (Bundle)dep.getAttachment(Bundle.class);
        UserBundleState userBundle = UserBundleState.assertBundleState(bundle);
        this.uninstallBundle(userBundle, 0);
    }

    @Override
    public void unregisterModule(ModuleIdentifier identifier) {
        ModuleManagerPlugin moduleManager = this.getFrameworkState().getModuleManagerPlugin();
        AbstractBundleState bundleState = moduleManager.getBundleState(identifier);
        if (bundleState == null) {
            log.errorf("Cannot find bundle associated with module: %s", (Object)identifier);
            return;
        }
        UserBundleState userBundle = UserBundleState.assertBundleState(bundleState);
        this.uninstallBundle(userBundle, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninstallBundle(UserBundleState userBundle, int options) {
        if (userBundle.aquireUninstallLock()) {
            try {
                int state = userBundle.getState();
                if (state == 1) {
                    return;
                }
                if (!(userBundle.isFragment() || state != 32 && state != 8 && state != 16)) {
                    try {
                        userBundle.stopInternal(options);
                    }
                    catch (Exception ex) {
                        this.fireFrameworkError(userBundle, "stopping bundle: " + userBundle, ex);
                    }
                }
                FrameworkEventsPlugin eventsPlugin = userBundle.getFrameworkState().getFrameworkEventsPlugin();
                userBundle.changeState(1, 0);
                userBundle.removeServices();
                boolean hasActiveWires = userBundle.hasActiveWires();
                if (!hasActiveWires) {
                    this.removeBundle(userBundle, options);
                }
                eventsPlugin.fireBundleEvent(userBundle, 16);
                Set<AbstractBundleState> uninstalled = this.getBundles(1);
                for (AbstractBundleState auxState : uninstalled) {
                    UserBundleState auxUser = UserBundleState.assertBundleState(auxState);
                    if (auxUser.hasActiveWires()) continue;
                    this.removeBundle(auxUser, options);
                }
            }
            finally {
                userBundle.releaseUninstallLock();
            }
        }
    }

    void removeBundle(UserBundleState userBundle, int options) {
        log.tracef("Start removing bundle: %s", (Object)userBundle);
        if ((options & 1) == 0) {
            BundleStorageState storageState = userBundle.getBundleStorageState();
            storageState.deleteBundleStorage();
        }
        ResolverPlugin resolverPlugin = this.getFrameworkState().getResolverPlugin();
        for (UserBundleRevision abr : userBundle.getRevisions()) {
            XModule resModule = abr.getResolverModule();
            resolverPlugin.removeModule(resModule);
        }
        FrameworkEventsPlugin eventsPlugin = this.getFrameworkState().getFrameworkEventsPlugin();
        eventsPlugin.fireBundleEvent(userBundle, 64);
        ModuleManagerPlugin moduleManager = this.getFrameworkState().getModuleManagerPlugin();
        Iterator<UserBundleRevision> i$ = userBundle.getRevisions().iterator();
        while (i$.hasNext()) {
            UserBundleRevision rev;
            UserBundleRevision userRev = rev = i$.next();
            if (!userBundle.isFragment()) {
                ModuleIdentifier identifier = moduleManager.getModuleIdentifier(rev.getResolverModule());
                moduleManager.removeModule(identifier);
            }
            userRev.close();
        }
        log.debugf("Remove bundle: %s", (Object)userBundle);
        this.bundleMap.remove(userBundle.getBundleId());
    }

    void setServiceMode(ServiceName serviceName, ServiceController.Mode mode) {
        ServiceController controller = this.serviceContainer.getService(serviceName);
        if (controller == null) {
            log.debugf("Cannot set mode %s on non-existing service: %s", (Object)mode, (Object)serviceName);
        } else {
            this.setServiceMode(controller, mode);
        }
    }

    void setServiceMode(ServiceController<?> controller, ServiceController.Mode mode) {
        block2: {
            try {
                log.tracef("Set mode %s on service: %s", (Object)mode, (Object)controller.getName());
                controller.setMode(mode);
            }
            catch (IllegalArgumentException rte) {
                if (rte.getMessage().equals("Container is shutting down")) break block2;
                throw rte;
            }
        }
    }

    void fireFrameworkError(AbstractBundleState bundleState, String context, Throwable t) {
        FrameworkEventsPlugin plugin = this.getFrameworkState().getFrameworkEventsPlugin();
        if (t instanceof BundleException) {
            plugin.fireFrameworkEvent(bundleState, 2, t);
        } else if (bundleState != null) {
            plugin.fireFrameworkEvent(bundleState, 2, new BundleException("Error " + context + " bundle: " + bundleState, t));
        } else {
            SystemBundleState systemBundle = (SystemBundleState)this.injectedSystemBundle.getValue();
            plugin.fireFrameworkEvent(systemBundle, 2, new BundleException("Error " + context, t));
        }
    }

    void fireFrameworkWarning(AbstractBundleState bundleState, String context, Throwable t) {
        FrameworkEventsPlugin plugin = this.getFrameworkState().getFrameworkEventsPlugin();
        if (t instanceof BundleException) {
            plugin.fireFrameworkEvent(bundleState, 16, t);
        } else if (bundleState != null) {
            plugin.fireFrameworkEvent(bundleState, 16, new BundleException("Error " + context + " bundle: " + bundleState, t));
        } else {
            SystemBundleState systemBundle = (SystemBundleState)this.injectedSystemBundle.getValue();
            plugin.fireFrameworkEvent(systemBundle, 16, new BundleException("Error " + context, t));
        }
    }

    static String getOSVersionInOSGiFormat() {
        int i;
        StringBuilder osgiVersion = new StringBuilder();
        String sysVersion = SecurityActions.getSystemProperty("os.version", null);
        String[] elements = sysVersion.split("\\.");
        for (i = 0; i < 3 && i < elements.length; ++i) {
            try {
                Integer.parseInt(elements[i]);
                if (i > 0) {
                    osgiVersion.append('.');
                }
                osgiVersion.append(elements[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                break;
            }
        }
        if (i == 3 && elements.length > 3) {
            osgiVersion.append('.');
            osgiVersion.append(elements[3]);
        }
        return osgiVersion.toString();
    }

    static {
        OSGi_FRAMEWORK_LANGUAGE = Locale.getDefault().getLanguage();
        OSGi_FRAMEWORK_VENDOR = "jboss.org";
        OSGi_FRAMEWORK_VERSION = "1.5";
        implementationTitle = BundleManager.class.getPackage().getImplementationTitle();
        implementationVersion = BundleManager.class.getPackage().getImplementationVersion();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ArrayList<String> execEnvironments = new ArrayList<String>();
                if (Java.isCompatible(2)) {
                    execEnvironments.add("OSGi/Minimum-1.1");
                    execEnvironments.add("J2SE-1.1");
                }
                if (Java.isCompatible(3)) {
                    execEnvironments.add("OSGi/Minimum-1.2");
                    execEnvironments.add("J2SE-1.2");
                }
                if (Java.isCompatible(4)) {
                    execEnvironments.add("J2SE-1.3");
                }
                if (Java.isCompatible(5)) {
                    execEnvironments.add("J2SE-1.4");
                }
                if (Java.isCompatible(6)) {
                    execEnvironments.add("J2SE-1.5");
                }
                if (Java.isCompatible(7)) {
                    execEnvironments.add("JavaSE-1.6");
                }
                String envlist = ((Object)execEnvironments).toString();
                envlist = envlist.substring(1, envlist.length() - 1);
                OSGi_FRAMEWORK_EXECUTIONENVIRONMENT = envlist;
                OSGi_FRAMEWORK_OS_NAME = SecurityActions.getSystemProperty("os.name", null);
                OSGi_FRAMEWORK_OS_VERSION = BundleManager.getOSVersionInOSGiFormat();
                OSGi_FRAMEWORK_PROCESSOR = SecurityActions.getSystemProperty("os.arch", null);
                SecurityActions.setSystemProperty("org.osgi.vendor.framework", "org.jboss.osgi.framework");
                return null;
            }
        });
    }
}

