/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml;

import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.DOMURIDereferencer;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSecSignatureSAML
extends WSSecSignature {
    private static Log log = LogFactory.getLog(WSSecSignatureSAML.class);
    private boolean senderVouches = false;
    private SecurityTokenReference secRefSaml = null;
    private String secRefID = null;
    private Element samlToken = null;
    private Crypto userCrypto = null;
    private Crypto issuerCrypto = null;
    private String issuerKeyName = null;
    private String issuerKeyPW = null;
    private boolean useDirectReferenceToAssertion = false;
    private KeyInfoFactory keyInfoFactory = KeyInfoFactory.getInstance("DOM");

    public WSSecSignatureSAML() {
        this.doDebug = log.isDebugEnabled();
    }

    public WSSecSignatureSAML(WSSConfig config) {
        super(config);
        this.doDebug = log.isDebugEnabled();
    }

    public Document build(Document doc, Crypto uCrypto, AssertionWrapper assertion, Crypto iCrypto, String iKeyName, String iKeyPW, WSSecHeader secHeader) throws WSSecurityException {
        WSEncryptionPart encP;
        this.prepare(doc, uCrypto, assertion, iCrypto, iKeyName, iKeyPW, secHeader);
        String soapNamespace = WSSecurityUtil.getSOAPNamespace(doc.getDocumentElement());
        if (this.parts == null) {
            this.parts = new ArrayList(1);
            encP = new WSEncryptionPart("Body", soapNamespace, "Content");
            this.parts.add(encP);
        } else {
            for (WSEncryptionPart part : this.parts) {
                if (!"STRTransform".equals(part.getName()) || part.getId() != null) continue;
                part.setId(this.strUri);
            }
        }
        if (this.secRefID != null) {
            encP = new WSEncryptionPart("STRTransform", soapNamespace, "Content");
            encP.setId(this.secRefID);
            this.parts.add(encP);
        }
        List<Reference> referenceList = this.addReferencesToSign(this.parts, secHeader);
        this.prependSAMLElementsToHeader(secHeader);
        if (this.senderVouches) {
            this.computeSignature(referenceList, secHeader, this.secRefSaml.getElement());
        } else {
            this.computeSignature(referenceList, secHeader, this.samlToken);
        }
        if (this.bstToken != null) {
            this.prependBSTElementToHeader(secHeader);
        }
        return doc;
    }

    public void prepare(Document doc, Crypto uCrypto, AssertionWrapper assertion, Crypto iCrypto, String iKeyName, String iKeyPW, WSSecHeader secHeader) throws WSSecurityException {
        Element elem;
        String valueType;
        Element keyId;
        org.apache.ws.security.message.token.Reference ref;
        if (this.doDebug) {
            log.debug((Object)"Beginning ST signing...");
        }
        this.userCrypto = uCrypto;
        this.issuerCrypto = iCrypto;
        this.document = doc;
        this.issuerKeyName = iKeyName;
        this.issuerKeyPW = iKeyPW;
        this.keyInfoFactory = KeyInfoFactory.getInstance("DOM");
        this.signatureFactory = XMLSignatureFactory.getInstance("DOM");
        this.samlToken = assertion.toDOM(doc);
        String confirmMethod = null;
        List<String> methods = assertion.getConfirmationMethods();
        if (methods != null && methods.size() > 0) {
            confirmMethod = methods.get(0);
        }
        if (OpenSAMLUtil.isMethodSenderVouches(confirmMethod)) {
            this.senderVouches = true;
        }
        this.wsDocInfo = new WSDocInfo(doc);
        X509Certificate[] certs = null;
        Key publicKey = null;
        if (this.senderVouches) {
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
            cryptoType.setAlias(this.issuerKeyName);
            certs = this.issuerCrypto.getX509Certificates(cryptoType);
            this.wsDocInfo.setCrypto(this.issuerCrypto);
        } else {
            if (this.userCrypto == null || !assertion.isSigned()) {
                throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"for SAML Signature (Key Holder)"});
            }
            if (this.secretKey == null) {
                RequestData data = new RequestData();
                data.setSigCrypto(this.userCrypto);
                data.setWssConfig(this.getWsConfig());
                SAMLKeyInfo samlKeyInfo = SAMLUtil.getCredentialFromSubject(assertion, data, this.wsDocInfo, this.getWsConfig().isWsiBSPCompliant());
                publicKey = samlKeyInfo.getPublicKey();
                certs = samlKeyInfo.getCerts();
                this.wsDocInfo.setCrypto(this.userCrypto);
            }
        }
        if ((certs == null || certs.length == 0 || certs[0] == null) && publicKey == null && this.secretKey == null) {
            throw new WSSecurityException(0, "noCertsFound", new Object[]{"SAML signature"});
        }
        if (this.sigAlgo == null) {
            Key key = null;
            if (certs != null && certs[0] != null) {
                key = certs[0].getPublicKey();
            } else if (publicKey != null) {
                key = publicKey;
            }
            String pubKeyAlgo = key.getAlgorithm();
            log.debug((Object)("automatic sig algo detection: " + pubKeyAlgo));
            if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            } else if (pubKeyAlgo.equalsIgnoreCase("RSA")) {
                this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            } else {
                throw new WSSecurityException(0, "unknownSignatureAlgorithm", new Object[]{pubKeyAlgo});
            }
        }
        this.sig = null;
        try {
            ExcC14NParameterSpec c14nSpec = null;
            if (this.getWsConfig().isWsiBSPCompliant() && this.canonAlgo.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
                List<String> prefixes = this.getInclusivePrefixes(secHeader.getSecurityHeader(), false);
                c14nSpec = new ExcC14NParameterSpec(prefixes);
            }
            this.c14nMethod = this.signatureFactory.newCanonicalizationMethod(this.canonAlgo, c14nSpec);
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            throw new WSSecurityException(10, "noXMLSig", null, ex);
        }
        this.keyInfoUri = this.getWsConfig().getIdAllocator().createSecureId("KeyId-", this.keyInfo);
        this.secRef = new SecurityTokenReference(doc);
        this.strUri = this.getWsConfig().getIdAllocator().createSecureId("STRId-", this.secRef);
        this.secRef.setID(this.strUri);
        if (certs != null && certs.length != 0) {
            this.certUri = this.getWsConfig().getIdAllocator().createSecureId("CertId-", certs[0]);
        }
        try {
            if (this.senderVouches) {
                this.secRefSaml = new SecurityTokenReference(doc);
                this.secRefID = this.getWsConfig().getIdAllocator().createSecureId("STRSAMLId-", this.secRefSaml);
                this.secRefSaml.setID(this.secRefID);
                if (this.useDirectReferenceToAssertion) {
                    ref = new org.apache.ws.security.message.token.Reference(doc);
                    ref.setURI("#" + assertion.getId());
                    if (assertion.getSaml1() != null) {
                        ref.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                        this.secRefSaml.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                    } else if (assertion.getSaml2() != null) {
                        this.secRefSaml.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                    }
                    this.secRefSaml.setReference(ref);
                } else {
                    keyId = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:KeyIdentifier");
                    valueType = null;
                    if (assertion.getSaml1() != null) {
                        valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
                        this.secRefSaml.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                    } else if (assertion.getSaml2() != null) {
                        valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";
                        this.secRefSaml.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                    }
                    keyId.setAttributeNS(null, "ValueType", valueType);
                    keyId.appendChild(doc.createTextNode(assertion.getId()));
                    elem = this.secRefSaml.getElement();
                    elem.appendChild(keyId);
                }
                this.wsDocInfo.addTokenElement(this.secRefSaml.getElement(), false);
            }
        }
        catch (Exception ex) {
            throw new WSSecurityException(10, "noXMLSig", null, ex);
        }
        if (this.senderVouches) {
            switch (this.keyIdentifierType) {
                case 1: {
                    ref = new org.apache.ws.security.message.token.Reference(doc);
                    ref.setURI("#" + this.certUri);
                    this.bstToken = new X509Security(doc);
                    ((X509Security)this.bstToken).setX509Certificate(certs[0]);
                    this.bstToken.setID(this.certUri);
                    this.wsDocInfo.addTokenElement(this.bstToken.getElement(), false);
                    ref.setValueType(this.bstToken.getValueType());
                    this.secRef.setReference(ref);
                    break;
                }
                case 3: {
                    this.secRef.setKeyIdentifier(certs[0]);
                    break;
                }
                default: {
                    throw new WSSecurityException(0, "unsupportedKeyId");
                }
            }
        } else if (this.useDirectReferenceToAssertion) {
            ref = new org.apache.ws.security.message.token.Reference(doc);
            ref.setURI("#" + assertion.getId());
            if (assertion.getSaml1() != null) {
                ref.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                this.secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            } else if (assertion.getSaml2() != null) {
                this.secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            }
            this.secRef.setReference(ref);
        } else {
            keyId = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:KeyIdentifier");
            valueType = null;
            if (assertion.getSaml1() != null) {
                valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
                this.secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            } else if (assertion.getSaml2() != null) {
                valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";
                this.secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            }
            keyId.setAttributeNS(null, "ValueType", valueType);
            keyId.appendChild(doc.createTextNode(assertion.getId()));
            elem = this.secRef.getElement();
            elem.appendChild(keyId);
        }
        DOMStructure structure = new DOMStructure(this.secRef.getElement());
        this.wsDocInfo.addTokenElement(this.secRef.getElement(), false);
        this.keyInfo = this.keyInfoFactory.newKeyInfo(Collections.singletonList(structure), this.keyInfoUri);
        this.wsDocInfo.addTokenElement(this.samlToken, false);
    }

    public void prependSAMLElementsToHeader(WSSecHeader secHeader) {
        if (this.senderVouches) {
            WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.secRefSaml.getElement());
        }
        WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.samlToken);
    }

    public void computeSignature(List<Reference> referenceList, WSSecHeader secHeader, Element siblingElement) throws WSSecurityException {
        try {
            Key key = this.senderVouches ? this.issuerCrypto.getPrivateKey(this.issuerKeyName, this.issuerKeyPW) : (this.secretKey != null ? WSSecurityUtil.prepareSecretKey(this.sigAlgo, this.secretKey) : this.userCrypto.getPrivateKey(this.user, this.password));
            SignatureMethod signatureMethod = this.signatureFactory.newSignatureMethod(this.sigAlgo, null);
            SignedInfo signedInfo = this.signatureFactory.newSignedInfo(this.c14nMethod, signatureMethod, referenceList);
            this.sig = this.signatureFactory.newXMLSignature(signedInfo, this.keyInfo, null, this.getWsConfig().getIdAllocator().createId("SIG-", null), null);
            Element securityHeaderElement = secHeader.getSecurityHeader();
            DOMSignContext signContext = null;
            signContext = siblingElement != null && siblingElement.getNextSibling() != null ? new DOMSignContext(key, (Node)securityHeaderElement, siblingElement.getNextSibling()) : new DOMSignContext(key, (Node)securityHeaderElement);
            signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this.canonAlgo)) {
                signContext.putNamespacePrefix("http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
            }
            signContext.setProperty("transform_ws_doc_info", this.wsDocInfo);
            this.wsDocInfo.setCallbackLookup(this.callbackLookup);
            DOMURIDereferencer dereferencer = new DOMURIDereferencer();
            dereferencer.setWsDocInfo(this.wsDocInfo);
            signContext.setURIDereferencer(dereferencer);
            this.sig.sign(signContext);
            this.signatureValue = this.sig.getSignatureValue().getValue();
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new WSSecurityException(10, null, null, ex);
        }
    }

    public boolean isUseDirectReferenceToAssertion() {
        return this.useDirectReferenceToAssertion;
    }

    public void setUseDirectReferenceToAssertion(boolean useDirectReferenceToAssertion) {
        this.useDirectReferenceToAssertion = useDirectReferenceToAssertion;
    }
}

