/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.framework;

import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.jsfunit.framework.RequestListener;

public class JSFUnitWebConnection
implements WebConnection {
    private WebConnection wrappedConnection;
    private List<RequestListener> listeners = new ArrayList<RequestListener>();

    public JSFUnitWebConnection(WebConnection wrappedConnection) {
        this.wrappedConnection = wrappedConnection;
    }

    public WebResponse getResponse(WebRequest webRequest) throws IOException {
        this.notifyListenersBefore(webRequest);
        WebResponse response = null;
        try {
            response = this.wrappedConnection.getResponse(webRequest);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            this.notifyListenersAfter(response);
        }
        return response;
    }

    private void notifyListenersBefore(WebRequest webRequest) {
        Iterator<RequestListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().beforeRequest(webRequest);
        }
    }

    private void notifyListenersAfter(WebResponse response) {
        Iterator<RequestListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().afterRequest(response);
        }
    }

    public void addListener(RequestListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RequestListener listener) {
        this.listeners.remove(listener);
    }
}

