/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.UNICAST2;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class UnicastTestRpc
extends ReceiverAdapter {
    private JChannel channel;
    private Address local_addr;
    private RpcDispatcher disp;
    static final String groupname = "UnicastTest-Group";
    private long sleep_time = 0L;
    private boolean sync = false;
    private boolean oob = false;
    private boolean anycasting = false;
    private int num_threads = 1;
    private int num_msgs = 50000;
    private int msg_size = 1000;
    private int anycast_count = 1;
    private final Collection<Address> anycast_mbrs = new ArrayList<Address>();
    private Address destination = null;
    private boolean started = false;
    private long start = 0L;
    private long stop = 0L;
    private AtomicInteger current_value = new AtomicInteger(0);
    private int num_values = 0;
    private int print;
    private AtomicLong total_bytes = new AtomicLong(0L);
    private static final Method START;
    private static final Method RECEIVE;
    private static final Method[] METHODS;
    private static final Class<?>[] unicast_protocols;
    private final AtomicInteger COUNTER = new AtomicInteger(1);
    long tot = 0L;
    int num_reqs = 0;

    public void init(String props, long sleep_time, boolean sync, boolean oob, String name) throws Exception {
        this.sleep_time = sleep_time;
        this.sync = sync;
        this.oob = oob;
        this.channel = new JChannel(props);
        if (name != null) {
            this.channel.setName(name);
        }
        this.disp = new RpcDispatcher((Channel)this.channel, null, (MembershipListener)this, (Object)this);
        this.disp.setMethodLookup(new MethodLookup(){

            @Override
            public Method findMethod(short id) {
                return METHODS[id];
            }
        });
        this.disp.setRequestMarshaller(new CustomMarshaller());
        this.channel.connect(groupname);
        this.local_addr = this.channel.getAddress();
        try {
            MBeanServer server = Util.getMBeanServer();
            JmxConfigurator.registerChannel(this.channel, server, "jgroups", this.channel.getClusterName(), true);
        }
        catch (Throwable ex) {
            System.err.println("registering the channel in JMX failed: " + ex);
        }
    }

    void stop() {
        if (this.disp != null) {
            this.disp.stop();
        }
        Util.close((Channel)this.channel);
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("** view: " + new_view);
    }

    public void startTest(int num_values) {
        if (this.started) {
            System.err.println("UnicastTest.run(): received START data, but am already processing data");
        } else {
            this.started = true;
            this.current_value.set(0);
            this.total_bytes.set(0L);
            this.num_values = num_values;
            this.print = num_values / 10;
            this.tot = 0L;
            this.num_reqs = 0;
            this.start = System.currentTimeMillis();
        }
    }

    public long receiveData(long value, byte[] buffer) {
        long diff = System.currentTimeMillis() - value;
        this.tot += diff;
        ++this.num_reqs;
        long new_val = this.current_value.incrementAndGet();
        this.total_bytes.addAndGet(buffer.length);
        if (this.print > 0 && new_val % (long)this.print == 0L) {
            System.out.println("received " + this.current_value);
        }
        if (new_val >= (long)this.num_values) {
            this.stop = System.currentTimeMillis();
            long total_time = this.stop - this.start;
            long msgs_per_sec = (long)((double)this.num_values / ((double)total_time / 1000.0));
            double throughput = (double)this.total_bytes.get() / ((double)total_time / 1000.0);
            System.out.println("\n-- received " + this.num_values + " messages in " + total_time + " ms (" + msgs_per_sec + " messages/sec, " + Util.printBytes(throughput) + " / sec)");
            double time_per_req = (double)this.tot / (double)this.num_reqs;
            System.out.println("received " + this.num_reqs + " requests in " + this.tot + " ms, " + time_per_req + " ms / req (only request)\n");
            this.started = false;
        }
        return System.currentTimeMillis();
    }

    public void eventLoop() throws Throwable {
        block18: while (true) {
            System.out.print("[1] Send msgs [2] Print view [3] Print conns [4] Trash conn [5] Trash all conns\n[6] Set sender threads (" + this.num_threads + ") [7] Set num msgs (" + this.num_msgs + ") " + "[8] Set msg size (" + Util.printBytes(this.msg_size) + ")" + " [9] Set anycast count (" + this.anycast_count + ")" + "\n[o] Toggle OOB (" + this.oob + ") [s] Toggle sync (" + this.sync + ") [a] Toggle anycasting (" + this.anycasting + ")" + "\n[q] Quit\n");
            System.out.flush();
            int c = System.in.read();
            switch (c) {
                case -1: {
                    continue block18;
                }
                case 49: {
                    try {
                        this.invokeRpcs();
                    }
                    catch (Throwable t) {
                        System.err.println(t);
                    }
                    continue block18;
                }
                case 50: {
                    this.printView();
                    continue block18;
                }
                case 51: {
                    this.printConnections();
                    continue block18;
                }
                case 52: {
                    this.removeConnection();
                    continue block18;
                }
                case 53: {
                    this.removeAllConnections();
                    continue block18;
                }
                case 54: {
                    this.setSenderThreads();
                    continue block18;
                }
                case 55: {
                    this.setNumMessages();
                    continue block18;
                }
                case 56: {
                    this.setMessageSize();
                    continue block18;
                }
                case 57: {
                    this.setAnycastCount();
                    continue block18;
                }
                case 111: {
                    this.oob = !this.oob;
                    System.out.println("oob=" + this.oob);
                    continue block18;
                }
                case 115: {
                    this.sync = !this.sync;
                    System.out.println("sync=" + this.sync);
                    continue block18;
                }
                case 97: {
                    this.anycasting = !this.anycasting;
                    System.out.println("anycasting=" + this.anycasting);
                    continue block18;
                }
                case 113: {
                    this.channel.close();
                    return;
                }
            }
        }
    }

    private void printConnections() {
        Protocol prot = this.channel.getProtocolStack().findProtocol(unicast_protocols);
        if (prot instanceof UNICAST) {
            System.out.println("connections:\n" + ((UNICAST)prot).printConnections());
        } else if (prot instanceof UNICAST2) {
            System.out.println("connections:\n" + ((UNICAST2)prot).printConnections());
        }
    }

    private void removeConnection() {
        Address member = this.getReceiver();
        if (member != null) {
            Protocol prot = this.channel.getProtocolStack().findProtocol(unicast_protocols);
            if (prot instanceof UNICAST) {
                ((UNICAST)prot).removeConnection(member);
            } else if (prot instanceof UNICAST2) {
                ((UNICAST2)prot).removeConnection(member);
            }
        }
    }

    private void removeAllConnections() {
        Protocol prot = this.channel.getProtocolStack().findProtocol(unicast_protocols);
        if (prot instanceof UNICAST) {
            ((UNICAST)prot).removeAllConnections();
        } else if (prot instanceof UNICAST2) {
            ((UNICAST2)prot).removeAllConnections();
        }
    }

    void invokeRpcs() throws Throwable {
        if (this.num_threads > 1 && this.num_msgs % this.num_threads != 0) {
            System.err.println("num_msgs (" + this.num_msgs + " ) has to be divisible by num_threads (" + this.num_threads + ")");
            return;
        }
        if (this.anycasting) {
            this.populateAnycastList(this.channel.getView());
        } else {
            this.destination = this.getReceiver();
            if (this.destination == null) {
                System.err.println("UnicastTest.invokeRpcs(): receiver is null, cannot send messages");
                return;
            }
        }
        System.out.println("invoking " + this.num_msgs + " RPCs of " + Util.printBytes(this.msg_size) + " on " + (this.anycasting ? this.anycast_mbrs : this.destination) + ", sync=" + this.sync + ", oob=" + this.oob + ", anycasting=" + this.anycasting);
        RequestOptions options = new RequestOptions(2, 0L, this.anycasting, null);
        if (this.sync) {
            options.setFlags((byte)2);
        }
        if (this.oob) {
            options.setFlags((byte)1);
        }
        if (this.anycasting) {
            this.disp.callRemoteMethods(this.anycast_mbrs, new MethodCall(0, this.num_msgs), options);
        } else {
            this.disp.callRemoteMethod(this.destination, new MethodCall(0, this.num_msgs), options);
        }
        options.setMode(this.sync ? 2 : 6);
        Invoker[] invokers = new Invoker[this.num_threads];
        for (int i = 0; i < invokers.length; ++i) {
            invokers[i] = this.anycasting ? new Invoker(this.anycast_mbrs, options, this.num_msgs / this.num_threads) : new Invoker(this.destination, options, this.num_msgs / this.num_threads);
        }
        for (Invoker invoker : invokers) {
            invoker.start();
        }
        for (Invoker invoker : invokers) {
            invoker.join();
        }
        System.out.println("done invoking " + this.num_msgs + " in " + this.destination);
    }

    void setSenderThreads() throws Exception {
        int threads = Util.readIntFromStdin("Number of sender threads: ");
        int old = this.num_threads;
        this.num_threads = threads;
        System.out.println("sender threads set to " + this.num_threads + " (from " + old + ")");
    }

    void setNumMessages() throws Exception {
        this.num_msgs = Util.readIntFromStdin("Number of RPCs: ");
        System.out.println("Set num_msgs=" + this.num_msgs);
        this.print = this.num_msgs / 10;
    }

    void setMessageSize() throws Exception {
        this.msg_size = Util.readIntFromStdin("Message size: ");
        System.out.println("set msg_size=" + this.msg_size);
    }

    void setAnycastCount() throws Exception {
        View view;
        int tmp = Util.readIntFromStdin("Anycast count: ");
        if (tmp > (view = this.channel.getView()).size()) {
            System.err.println("anycast count must be smaller or equal to the view size (" + view + ")\n");
            return;
        }
        this.anycast_count = tmp;
        System.out.println("set anycast_count=" + this.anycast_count);
    }

    void populateAnycastList(View view) {
        if (!this.anycasting) {
            return;
        }
        this.anycast_mbrs.clear();
        Vector<Address> mbrs = view.getMembers();
        int index = mbrs.indexOf(this.local_addr);
        for (int i = index + 1; i < index + 1 + this.anycast_count; ++i) {
            int new_index = i % mbrs.size();
            this.anycast_mbrs.add(mbrs.get(new_index));
        }
        System.out.println("local_addr=" + this.local_addr + ", anycast_mbrs = " + this.anycast_mbrs);
    }

    void printView() {
        System.out.println("\n-- view: " + this.channel.getView() + '\n');
        try {
            System.in.skip(System.in.available());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Address getReceiver() {
        try {
            Vector<Address> mbrs = this.channel.getView().getMembers();
            System.out.println("pick receiver from the following members:");
            for (int i = 0; i < mbrs.size(); ++i) {
                if (mbrs.elementAt(i).equals(this.channel.getAddress())) {
                    System.out.println("[" + i + "]: " + mbrs.elementAt(i) + " (self)");
                    continue;
                }
                System.out.println("[" + i + "]: " + mbrs.elementAt(i));
            }
            System.out.flush();
            System.in.skip(System.in.available());
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String str = reader.readLine().trim();
            int index = Integer.parseInt(str);
            return mbrs.elementAt(index);
        }
        catch (Exception e) {
            System.err.println("UnicastTest.getReceiver(): " + e);
            return null;
        }
    }

    public static void main(String[] args) {
        block8: {
            long sleep_time = 0L;
            String props = null;
            boolean sync = false;
            boolean oob = false;
            String name = null;
            for (int i = 0; i < args.length; ++i) {
                if ("-props".equals(args[i])) {
                    props = args[++i];
                    continue;
                }
                if ("-sleep".equals(args[i])) {
                    sleep_time = Long.parseLong(args[++i]);
                    continue;
                }
                if ("-sync".equals(args[i])) {
                    sync = true;
                    continue;
                }
                if ("-oob".equals(args[i])) {
                    oob = true;
                    continue;
                }
                if ("-name".equals(args[i])) {
                    name = args[++i];
                    continue;
                }
                UnicastTestRpc.help();
                return;
            }
            UnicastTestRpc test = null;
            try {
                test = new UnicastTestRpc();
                test.init(props, sleep_time, sync, oob, name);
                test.eventLoop();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (test == null) break block8;
                test.stop();
            }
        }
    }

    static void help() {
        System.out.println("UnicastTestRpc [-help] [-props <props>] [-name name] [-sleep <time in ms between msg sends] [-exit_on_end] [-busy-sleep]");
    }

    static {
        METHODS = new Method[2];
        unicast_protocols = new Class[]{UNICAST.class, UNICAST2.class};
        try {
            START = UnicastTestRpc.class.getMethod("startTest", Integer.TYPE);
            RECEIVE = UnicastTestRpc.class.getMethod("receiveData", Long.TYPE, byte[].class);
            UnicastTestRpc.METHODS[0] = START;
            UnicastTestRpc.METHODS[1] = RECEIVE;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    static class CustomMarshaller
    implements RpcDispatcher.Marshaller {
        CustomMarshaller() {
        }

        @Override
        public byte[] objectToByteBuffer(Object obj) throws Exception {
            MethodCall call = (MethodCall)obj;
            if (call.getId() == 0) {
                Integer arg = (Integer)call.getArgs()[0];
                ByteBuffer buf = ByteBuffer.allocate(5);
                buf.put((byte)0).putInt(arg);
                return buf.array();
            }
            if (call.getId() == 1) {
                Long arg = (Long)call.getArgs()[0];
                byte[] arg2 = (byte[])call.getArgs()[1];
                ByteBuffer buf = ByteBuffer.allocate(13 + arg2.length);
                buf.put((byte)1).putLong(arg).putInt(arg2.length).put(arg2, 0, arg2.length);
                return buf.array();
            }
            throw new IllegalStateException("method " + call.getMethod() + " not known");
        }

        @Override
        public Object objectFromByteBuffer(byte[] buffer) throws Exception {
            ByteBuffer buf = ByteBuffer.wrap(buffer);
            byte type = buf.get();
            switch (type) {
                case 0: {
                    int arg = buf.getInt();
                    return new MethodCall(0, arg);
                }
                case 1: {
                    Long longarg = buf.getLong();
                    int len = buf.getInt();
                    byte[] arg2 = new byte[len];
                    buf.get(arg2, 0, arg2.length);
                    return new MethodCall(1, longarg, arg2);
                }
            }
            throw new IllegalStateException("type " + type + " not known");
        }
    }

    private class Invoker
    extends Thread {
        private final Address dest;
        private final Collection<Address> dests;
        private final RequestOptions options;
        private final int number_of_msgs;
        long total_req = 0L;
        long total_rsp = 0L;

        public Invoker(Address dest, RequestOptions options, int number_of_msgs) {
            this.dest = dest;
            this.dests = null;
            this.options = options;
            this.number_of_msgs = number_of_msgs;
            this.setName("Invoker-" + UnicastTestRpc.this.COUNTER.getAndIncrement());
        }

        public Invoker(Collection<Address> dests, RequestOptions options, int number_of_msgs) {
            this.dest = null;
            this.dests = dests;
            this.options = options;
            this.number_of_msgs = number_of_msgs;
            this.setName("Invoker-" + UnicastTestRpc.this.COUNTER.getAndIncrement());
        }

        @Override
        public void run() {
            byte[] buf = new byte[UnicastTestRpc.this.msg_size];
            Object[] args = new Object[]{0, buf};
            MethodCall call = new MethodCall(1, args);
            for (int i = 1; i <= this.number_of_msgs; ++i) {
                Object retval = null;
                try {
                    long start = System.currentTimeMillis();
                    args[0] = start;
                    if (this.dests != null) {
                        UnicastTestRpc.this.disp.callRemoteMethods(this.dests, call, this.options);
                    } else {
                        retval = UnicastTestRpc.this.disp.callRemoteMethod(this.dest, call, this.options);
                    }
                    long current_time = System.currentTimeMillis();
                    long diff = current_time - start;
                    this.total_req += diff;
                    if (UnicastTestRpc.this.sync && retval instanceof Long) {
                        diff = System.currentTimeMillis() - (Long)retval;
                        this.total_rsp += diff;
                    }
                    if (UnicastTestRpc.this.print > 0 && i % UnicastTestRpc.this.print == 0) {
                        System.out.println("-- invoked " + i);
                    }
                    if (UnicastTestRpc.this.sleep_time <= 0L) continue;
                    Util.sleep(UnicastTestRpc.this.sleep_time);
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            double time_per_req = (double)this.total_req / (double)this.number_of_msgs;
            System.out.println("\ninvoked " + this.number_of_msgs + " requests in " + this.total_req + " ms: " + time_per_req + " ms / req (entire request)");
            if (UnicastTestRpc.this.sync) {
                double time_per_rsp = (double)this.total_rsp / (double)this.number_of_msgs;
                System.out.println("received " + this.number_of_msgs + " responses in " + this.total_rsp + " ms: " + time_per_rsp + " ms / rsp (only response)\n");
            }
        }
    }
}

