/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.action.internal.EntityIdentityInsertAction;
import org.hibernate.action.internal.EntityInsertAction;
import org.hibernate.bytecode.instrumentation.internal.FieldInterceptionHelper;
import org.hibernate.bytecode.instrumentation.spi.FieldInterceptor;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.internal.Nullability;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractReassociateEventListener;
import org.hibernate.event.internal.WrapVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.jboss.logging.Logger;

public abstract class AbstractSaveEventListener
extends AbstractReassociateEventListener {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)AbstractSaveEventListener.class.getName());

    protected Serializable saveWithRequestedId(Object entity, Serializable requestedId, String entityName, Object anything, EventSource source) {
        return this.performSave(entity, requestedId, source.getEntityPersister(entityName, entity), false, anything, source, true);
    }

    protected Serializable saveWithGeneratedId(Object entity, String entityName, Object anything, EventSource source, boolean requiresImmediateIdAccess) {
        EntityPersister persister = source.getEntityPersister(entityName, entity);
        Serializable generatedId = persister.getIdentifierGenerator().generate(source, entity);
        if (generatedId == null) {
            throw new IdentifierGenerationException("null id generated for:" + entity.getClass());
        }
        if (generatedId == IdentifierGeneratorHelper.SHORT_CIRCUIT_INDICATOR) {
            return source.getIdentifier(entity);
        }
        if (generatedId == IdentifierGeneratorHelper.POST_INSERT_INDICATOR) {
            return this.performSave(entity, null, persister, true, anything, source, requiresImmediateIdAccess);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Generated identifier: %s, using strategy: %s", persister.getIdentifierType().toLoggableString(generatedId, source.getFactory()), persister.getIdentifierGenerator().getClass().getName());
        }
        return this.performSave(entity, generatedId, persister, false, anything, source, true);
    }

    protected Serializable performSave(Object entity, Serializable id, EntityPersister persister, boolean useIdentityColumn, Object anything, EventSource source, boolean requiresImmediateIdAccess) {
        EntityKey key;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Saving " + MessageHelper.infoString(persister, id, source.getFactory()));
        }
        if (!useIdentityColumn) {
            key = source.generateEntityKey(id, persister);
            Object old = source.getPersistenceContext().getEntity(key);
            if (old != null) {
                if (source.getPersistenceContext().getEntry(old).getStatus() == Status.DELETED) {
                    source.forceFlush(source.getPersistenceContext().getEntry(old));
                } else {
                    throw new NonUniqueObjectException(id, persister.getEntityName());
                }
            }
            persister.setIdentifier(entity, id, source);
        } else {
            key = null;
        }
        if (this.invokeSaveLifecycle(entity, persister, source)) {
            return id;
        }
        return this.performSaveOrReplicate(entity, key, persister, useIdentityColumn, anything, source, requiresImmediateIdAccess);
    }

    protected boolean invokeSaveLifecycle(Object entity, EntityPersister persister, EventSource source) {
        if (persister.implementsLifecycle()) {
            LOG.debugf("Calling onSave()", new Object[0]);
            if (((Lifecycle)entity).onSave(source)) {
                LOG.debugf("Insertion vetoed by onSave()", new Object[0]);
                return true;
            }
        }
        return false;
    }

    protected Serializable performSaveOrReplicate(Object entity, EntityKey key, EntityPersister persister, boolean useIdentityColumn, Object anything, EventSource source, boolean requiresImmediateIdAccess) {
        Serializable id = key == null ? null : key.getIdentifier();
        boolean inTxn = source.getTransactionCoordinator().isTransactionInProgress();
        boolean shouldDelayIdentityInserts = !inTxn && !requiresImmediateIdAccess;
        source.getPersistenceContext().addEntry(entity, Status.SAVING, null, null, id, null, LockMode.WRITE, useIdentityColumn, persister, false, false);
        this.cascadeBeforeSave(source, persister, entity, anything);
        if (useIdentityColumn && !shouldDelayIdentityInserts) {
            LOG.trace("Executing insertions");
            source.getActionQueue().executeInserts();
        }
        Object[] values = persister.getPropertyValuesToInsert(entity, this.getMergeMap(anything), source);
        Type[] types = persister.getPropertyTypes();
        boolean substitute = this.substituteValuesIfNecessary(entity, id, values, persister, source);
        if (persister.hasCollections()) {
            boolean bl = substitute = substitute || this.visitCollectionsBeforeSave(entity, id, values, types, source);
        }
        if (substitute) {
            persister.setPropertyValues(entity, values);
        }
        TypeHelper.deepCopy(values, types, persister.getPropertyUpdateability(), values, source);
        new ForeignKeys.Nullifier(entity, false, useIdentityColumn, source).nullifyTransientReferences(values, types);
        new Nullability(source).checkNullability(values, persister, false);
        if (useIdentityColumn) {
            EntityIdentityInsertAction insert = new EntityIdentityInsertAction(values, entity, persister, source, shouldDelayIdentityInserts);
            if (!shouldDelayIdentityInserts) {
                LOG.debugf("Executing identity-insert immediately", new Object[0]);
                source.getActionQueue().execute(insert);
                id = insert.getGeneratedId();
                key = source.generateEntityKey(id, persister);
                source.getPersistenceContext().checkUniqueness(key, entity);
            } else {
                LOG.debugf("Delaying identity-insert due to no transaction in progress", new Object[0]);
                source.getActionQueue().addAction(insert);
                key = insert.getDelayedEntityKey();
            }
        }
        Object version = Versioning.getVersion(values, persister);
        source.getPersistenceContext().addEntity(entity, persister.isMutable() ? Status.MANAGED : Status.READ_ONLY, values, key, version, LockMode.WRITE, useIdentityColumn, persister, this.isVersionIncrementDisabled(), false);
        if (!useIdentityColumn) {
            source.getActionQueue().addAction(new EntityInsertAction(id, values, entity, version, persister, source));
        }
        this.cascadeAfterSave(source, persister, entity, anything);
        this.markInterceptorDirty(entity, persister, source);
        return id;
    }

    private void markInterceptorDirty(Object entity, EntityPersister persister, EventSource source) {
        if (FieldInterceptionHelper.isInstrumented(entity)) {
            FieldInterceptor interceptor = FieldInterceptionHelper.injectFieldInterceptor(entity, persister.getEntityName(), null, source);
            interceptor.dirty();
        }
    }

    protected Map getMergeMap(Object anything) {
        return null;
    }

    protected boolean isVersionIncrementDisabled() {
        return false;
    }

    protected boolean visitCollectionsBeforeSave(Object entity, Serializable id, Object[] values, Type[] types, EventSource source) {
        WrapVisitor visitor = new WrapVisitor(source);
        visitor.processEntityPropertyValues(values, types);
        return visitor.isSubstitutionRequired();
    }

    protected boolean substituteValuesIfNecessary(Object entity, Serializable id, Object[] values, EntityPersister persister, SessionImplementor source) {
        boolean substitute = source.getInterceptor().onSave(entity, id, values, persister.getPropertyNames(), persister.getPropertyTypes());
        if (persister.isVersioned()) {
            substitute = Versioning.seedVersion(values, persister.getVersionProperty(), persister.getVersionType(), source) || substitute;
        }
        return substitute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeBeforeSave(EventSource source, EntityPersister persister, Object entity, Object anything) {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadeAction(), 2, source).cascade(persister, entity, anything);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeAfterSave(EventSource source, EntityPersister persister, Object entity, Object anything) {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadeAction(), 1, source).cascade(persister, entity, anything);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected abstract CascadingAction getCascadeAction();

    protected EntityState getEntityState(Object entity, String entityName, EntityEntry entry, SessionImplementor source) {
        if (entry != null) {
            if (entry.getStatus() != Status.DELETED) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Persistent instance of: " + this.getLoggableName(entityName, entity));
                }
                return EntityState.PERSISTENT;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Deleted instance of: " + this.getLoggableName(entityName, entity));
            }
            return EntityState.DELETED;
        }
        if (ForeignKeys.isTransient(entityName, entity, this.getAssumedUnsaved(), source)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Transient instance of: " + this.getLoggableName(entityName, entity));
            }
            return EntityState.TRANSIENT;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Detached instance of: " + this.getLoggableName(entityName, entity));
        }
        return EntityState.DETACHED;
    }

    protected String getLoggableName(String entityName, Object entity) {
        return entityName == null ? entity.getClass().getName() : entityName;
    }

    protected Boolean getAssumedUnsaved() {
        return null;
    }

    public static enum EntityState {
        PERSISTENT,
        TRANSIENT,
        DETACHED,
        DELETED;

    }
}

