/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.metamodel.binding.AbstractAttributeBinding;
import org.hibernate.metamodel.binding.AbstractCollectionElement;
import org.hibernate.metamodel.binding.AttributeBindingContainer;
import org.hibernate.metamodel.binding.BasicCollectionElement;
import org.hibernate.metamodel.binding.CollectionElementNature;
import org.hibernate.metamodel.binding.CollectionKey;
import org.hibernate.metamodel.binding.CompositeCollectionElement;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.ManyToAnyCollectionElement;
import org.hibernate.metamodel.binding.ManyToManyCollectionElement;
import org.hibernate.metamodel.binding.OneToManyCollectionElement;
import org.hibernate.metamodel.binding.PluralAttributeBinding;
import org.hibernate.metamodel.domain.PluralAttribute;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.relational.TableSpecification;

public abstract class AbstractPluralAttributeBinding
extends AbstractAttributeBinding
implements PluralAttributeBinding {
    private final CollectionKey collectionKey;
    private final AbstractCollectionElement collectionElement;
    private Table collectionTable;
    private CascadeStyle cascadeStyle;
    private FetchMode fetchMode;
    private boolean extraLazy;
    private boolean inverse;
    private boolean mutable = true;
    private boolean subselectLoadable;
    private String cacheConcurrencyStrategy;
    private String cacheRegionName;
    private String orderBy;
    private String where;
    private String referencedPropertyName;
    private boolean sorted;
    private Comparator comparator;
    private String comparatorClassName;
    private boolean orphanDelete;
    private int batchSize = -1;
    private boolean embedded = true;
    private boolean optimisticLocked = true;
    private Class collectionPersisterClass;
    private final Map filters = new HashMap();
    private final Set<String> synchronizedTables = new HashSet<String>();
    private CustomSQL customSQLInsert;
    private CustomSQL customSQLUpdate;
    private CustomSQL customSQLDelete;
    private CustomSQL customSQLDeleteAll;
    private String loaderName;

    protected AbstractPluralAttributeBinding(AttributeBindingContainer container, PluralAttribute attribute, CollectionElementNature collectionElementNature) {
        super(container, attribute);
        this.collectionKey = new CollectionKey(this);
        this.collectionElement = this.interpretNature(collectionElementNature);
    }

    private AbstractCollectionElement interpretNature(CollectionElementNature collectionElementNature) {
        switch (collectionElementNature) {
            case BASIC: {
                return new BasicCollectionElement(this);
            }
            case COMPOSITE: {
                return new CompositeCollectionElement(this);
            }
            case ONE_TO_MANY: {
                return new OneToManyCollectionElement(this);
            }
            case MANY_TO_MANY: {
                return new ManyToManyCollectionElement(this);
            }
            case MANY_TO_ANY: {
                return new ManyToAnyCollectionElement(this);
            }
        }
        throw new AssertionFailure("Unknown collection element nature : " + (Object)((Object)collectionElementNature));
    }

    @Override
    public PluralAttribute getAttribute() {
        return (PluralAttribute)super.getAttribute();
    }

    @Override
    public boolean isAssociation() {
        return this.collectionElement.getCollectionElementNature() == CollectionElementNature.MANY_TO_ANY || this.collectionElement.getCollectionElementNature() == CollectionElementNature.MANY_TO_MANY || this.collectionElement.getCollectionElementNature() == CollectionElementNature.ONE_TO_MANY;
    }

    @Override
    public TableSpecification getCollectionTable() {
        return this.collectionTable;
    }

    public void setCollectionTable(Table collectionTable) {
        this.collectionTable = collectionTable;
    }

    @Override
    public CollectionKey getCollectionKey() {
        return this.collectionKey;
    }

    @Override
    public AbstractCollectionElement getCollectionElement() {
        return this.collectionElement;
    }

    @Override
    public CascadeStyle getCascadeStyle() {
        return this.cascadeStyle;
    }

    @Override
    public void setCascadeStyles(Iterable<CascadeStyle> cascadeStyles) {
        ArrayList<CascadeStyle> cascadeStyleList = new ArrayList<CascadeStyle>();
        for (CascadeStyle style : cascadeStyles) {
            if (style == CascadeStyle.NONE) continue;
            cascadeStyleList.add(style);
        }
        this.cascadeStyle = cascadeStyleList.isEmpty() ? CascadeStyle.NONE : (cascadeStyleList.size() == 1 ? (CascadeStyle)cascadeStyleList.get(0) : new CascadeStyle.MultipleCascadeStyle(cascadeStyleList.toArray(new CascadeStyle[cascadeStyleList.size()])));
    }

    @Override
    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    @Override
    public void setFetchMode(FetchMode fetchMode) {
        this.fetchMode = fetchMode;
    }

    public boolean isExtraLazy() {
        return this.extraLazy;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isSubselectLoadable() {
        return this.subselectLoadable;
    }

    @Override
    public String getCacheConcurrencyStrategy() {
        return this.cacheConcurrencyStrategy;
    }

    @Override
    public String getCacheRegionName() {
        return this.cacheRegionName;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public String getComparatorClassName() {
        return this.comparatorClassName;
    }

    public boolean isOrphanDelete() {
        return this.orphanDelete;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public Class getCollectionPersisterClass() {
        return this.collectionPersisterClass;
    }

    public void addFilter(String name, String condition) {
        this.filters.put(name, condition);
    }

    public Map getFilterMap() {
        return this.filters;
    }

    public CustomSQL getCustomSQLInsert() {
        return this.customSQLInsert;
    }

    public CustomSQL getCustomSQLUpdate() {
        return this.customSQLUpdate;
    }

    public CustomSQL getCustomSQLDelete() {
        return this.customSQLDelete;
    }

    public CustomSQL getCustomSQLDeleteAll() {
        return this.customSQLDeleteAll;
    }

    public String getLoaderName() {
        return this.loaderName;
    }
}

