/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ManagedReferenceObjectFactory;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.util.NameParser;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class BinderService
implements Service<ManagedReferenceFactory> {
    private static final Logger logger = Logger.getLogger(BinderService.class);
    private final InjectedValue<NamingStore> namingStoreValue = new InjectedValue();
    private final String name;
    private final InjectedValue<ManagedReferenceFactory> managedReferenceFactory = new InjectedValue();
    private final Object source;
    private short refcnt = 0;
    private ServiceController<?> controller;

    public BinderService(String name, Object source) {
        this.name = name.startsWith("java:") ? name.substring(name.indexOf(47) + 1) : name;
        this.source = source;
    }

    public BinderService(String name) {
        this(name, null);
    }

    public Object getSource() {
        return this.source;
    }

    public synchronized void acquire() {
        this.refcnt = (short)(this.refcnt + 1);
    }

    public synchronized void release() {
        this.refcnt = (short)(this.refcnt - 1);
        if (this.refcnt <= 0) {
            this.controller.setMode(ServiceController.Mode.REMOVE);
        }
    }

    public synchronized void start(StartContext context) throws StartException {
        NamingStore namingStore = (NamingStore)this.namingStoreValue.getValue();
        try {
            ServiceController controller;
            this.controller = controller = context.getController();
            Reference reference = ManagedReferenceObjectFactory.createReference(controller.getName());
            Name name = NameParser.INSTANCE.parse(this.name);
            namingStore.bind(name, reference);
            logger.tracef("Bound resource %s into naming store %s", (Object)name, (Object)namingStore);
        }
        catch (NamingException e) {
            throw new StartException("Failed to bind resource into naming store [" + namingStore + "] at location [" + this.name + "]", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        NamingStore namingStore = (NamingStore)this.namingStoreValue.getValue();
        try {
            namingStore.unbind(NameParser.INSTANCE.parse(this.name));
        }
        catch (NamingException e) {
            throw new IllegalStateException("Failed to unbind resource from naming store [" + namingStore + "] at location [" + this.name + "]", e);
        }
    }

    public synchronized ManagedReferenceFactory getValue() throws IllegalStateException {
        return (ManagedReferenceFactory)this.managedReferenceFactory.getValue();
    }

    public Injector<ManagedReferenceFactory> getManagedObjectInjector() {
        return this.managedReferenceFactory;
    }

    public Injector<NamingStore> getNamingStoreInjector() {
        return this.namingStoreValue;
    }
}

