/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2;

import java.util.List;
import java.util.Timer;
import java.util.concurrent.ExecutorService;
import javax.ejb.TimerService;
import javax.transaction.TransactionManager;
import org.jboss.ejb3.timerservice.mk2.TimerServiceImpl;
import org.jboss.ejb3.timerservice.mk2.TimerServiceRegistry;
import org.jboss.ejb3.timerservice.mk2.persistence.TimerPersistence;
import org.jboss.ejb3.timerservice.spi.ScheduleTimer;
import org.jboss.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.ejb3.timerservice.spi.TimerServiceFactory;
import org.jboss.logging.Logger;

public class TimerServiceFactoryImpl
implements TimerServiceFactory {
    private static final Logger logger = Logger.getLogger(TimerServiceFactoryImpl.class);
    private final TimerPersistence timerPersistence;
    private final TransactionManager transactionManager;
    private final ExecutorService executor;
    private final Timer timer;

    public TimerServiceFactoryImpl(TimerPersistence timerPersistence, TransactionManager transactionManager, ExecutorService executor) {
        this.timerPersistence = timerPersistence;
        this.transactionManager = transactionManager;
        this.executor = executor;
        this.timer = new Timer("EJB Timer Thread", true);
    }

    public TimerService createTimerService(TimedObjectInvoker invoker) {
        TimerServiceImpl timerService = new TimerServiceImpl(this.timer, invoker, this.timerPersistence, this.transactionManager, this.executor);
        String timedObjectId = invoker.getTimedObjectId();
        if (TimerServiceRegistry.isRegistered(timedObjectId)) {
            TimerServiceRegistry.unregisterTimerService(timedObjectId);
            logger.warn((Object)("Unregistered an already registered Timerservice with id " + timedObjectId + " and a new instance will be registered"));
        }
        TimerServiceRegistry.registerTimerService(timerService);
        return timerService;
    }

    public void restoreTimerService(TimerService timerService, List<ScheduleTimer> autoTimers) {
        TimerServiceImpl mk2TimerService = (TimerServiceImpl)timerService;
        String timedObjectId = mk2TimerService.getInvoker().getTimedObjectId();
        if (!TimerServiceRegistry.isRegistered(timedObjectId)) {
            TimerServiceRegistry.registerTimerService(mk2TimerService);
        }
        logger.debug((Object)("Restoring timerservice for timedObjectId: " + timedObjectId));
        mk2TimerService.restoreTimers(autoTimers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendTimerService(TimerService timerService) {
        TimerServiceImpl mk2TimerService = (TimerServiceImpl)timerService;
        try {
            logger.debug((Object)("Suspending timerservice for timedObjectId: " + mk2TimerService.getInvoker().getTimedObjectId()));
            mk2TimerService.suspendTimers();
        }
        finally {
            String timedObjectId = mk2TimerService.getInvoker().getTimedObjectId();
            if (TimerServiceRegistry.isRegistered(timedObjectId)) {
                TimerServiceRegistry.unregisterTimerService(timedObjectId);
            }
        }
    }
}

