/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ExtensionListEntry;
import org.jboss.as.server.deployment.module.FilterSpecification;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class DeploymentStructureDescriptorParser
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.deployment.module.deployment-structure-descriptor-processor");
    public static final String[] DEPLOYMENT_STRUCTURE_DESCRIPTOR_LOCATIONS = new String[]{"META-INF/jboss-deployment-structure.xml", "WEB-INF/jboss-deployment-structure.xml"};
    private static final String NAMESPACE = "urn:jboss:deployment-structure:1.0";
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot resourceRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        ServiceModuleLoader moduleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        VirtualFile deploymentFile = null;
        for (String loc : DEPLOYMENT_STRUCTURE_DESCRIPTOR_LOCATIONS) {
            VirtualFile file = resourceRoot.getRoot().getChild(loc);
            if (!file.exists()) continue;
            deploymentFile = file;
            break;
        }
        if (deploymentFile == null) {
            return;
        }
        if (deploymentUnit.getParent() != null) {
            log.warnf("%s in subdeployment ignored. jboss-deployment-structure.xml is only parsed for top level deployments.", (Object)deploymentFile.getPathName());
            return;
        }
        try {
            ParseResult result = DeploymentStructureDescriptorParser.parse(deploymentFile.getPhysicalFile(), deploymentUnit, moduleLoader);
            ModuleSpecification moduleSpec = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
            if (result.earSubDeploymentsIsolated != null) {
                moduleSpec.setSubDeploymentModulesIsolated(result.earSubDeploymentsIsolated);
            }
            if (result.rootDeploymentSpecification != null) {
                moduleSpec.addUserDependencies(result.rootDeploymentSpecification.getModuleDependencies());
                moduleSpec.addExclusions(result.rootDeploymentSpecification.getExclusions());
                for (ResourceRoot additionalResourceRoot : result.rootDeploymentSpecification.getResourceRoots()) {
                    deploymentUnit.addToAttachmentList(Attachments.RESOURCE_ROOTS, additionalResourceRoot);
                }
                for (String classFileTransformer : result.rootDeploymentSpecification.getClassFileTransformers()) {
                    moduleSpec.addClassFileTransformer(classFileTransformer);
                }
            }
            List<DeploymentUnit> subDeployments = deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
            HashMap<String, DeploymentUnit> subDeploymentMap = new HashMap<String, DeploymentUnit>();
            for (DeploymentUnit deploymentUnit2 : subDeployments) {
                ResourceRoot subDeploymentRoot = deploymentUnit2.getAttachment(Attachments.DEPLOYMENT_ROOT);
                String path = subDeploymentRoot.getRoot().getPathNameRelativeTo(resourceRoot.getRoot());
                subDeploymentMap.put(path, deploymentUnit2);
            }
            for (Map.Entry entry : result.subDeploymentSpecifications.entrySet()) {
                String path = (String)entry.getKey();
                ModuleStructureSpec spec = (ModuleStructureSpec)entry.getValue();
                if (!subDeploymentMap.containsKey(path)) {
                    throw this.subDeploymentNotFound(path, subDeploymentMap.keySet());
                }
                DeploymentUnit subDeployment = (DeploymentUnit)subDeploymentMap.get(path);
                ModuleSpecification subModuleSpec = subDeployment.getAttachment(Attachments.MODULE_SPECIFICATION);
                subModuleSpec.addUserDependencies(spec.getModuleDependencies());
                subModuleSpec.addExclusions(spec.getExclusions());
                for (ResourceRoot additionalResourceRoot : spec.getResourceRoots()) {
                    subDeployment.addToAttachmentList(Attachments.RESOURCE_ROOTS, additionalResourceRoot);
                }
                for (String classFileTransformer : spec.getClassFileTransformers()) {
                    subModuleSpec.addClassFileTransformer(classFileTransformer);
                }
            }
            for (ModuleStructureSpec moduleStructureSpec : result.additionalModules) {
                AdditionalModuleSpecification additional = new AdditionalModuleSpecification(moduleStructureSpec.getModuleIdentifier(), moduleStructureSpec.getResourceRoots());
                additional.addSystemDependencies(moduleStructureSpec.getModuleDependencies());
                deploymentUnit.addToAttachmentList(Attachments.ADDITIONAL_MODULES, additional);
            }
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException(e);
        }
    }

    private DeploymentUnitProcessingException subDeploymentNotFound(String path, Collection<String> subDeployments) {
        StringBuilder builder = new StringBuilder();
        builder.append("Sub deployment ");
        builder.append(path);
        builder.append(" in jboss-structure.xml was not found. Available sub deployments: ");
        for (String dep : subDeployments) {
            builder.append(dep);
            builder.append(", ");
        }
        return new DeploymentUnitProcessingException(builder.toString());
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ParseResult parse(File file, DeploymentUnit deploymentUnit, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new DeploymentUnitProcessingException("No jboss-deployment-structure.xml file found at " + file);
        }
        try {
            ParseResult parseResult = DeploymentStructureDescriptorParser.parse(fis, file, deploymentUnit, moduleLoader);
            return parseResult;
        }
        finally {
            DeploymentStructureDescriptorParser.safeClose(fis);
        }
    }

    private static void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult parse(InputStream source, File file, DeploymentUnit deploymentUnit, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        ParseResult parseResult;
        XMLInputFactory inputFactory = INPUT_FACTORY;
        DeploymentStructureDescriptorParser.setIfSupported(inputFactory, "javax.xml.stream.isValidating", Boolean.FALSE);
        DeploymentStructureDescriptorParser.setIfSupported(inputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
        XMLStreamReader streamReader = inputFactory.createXMLStreamReader(source);
        try {
            ParseResult result = new ParseResult();
            DeploymentStructureDescriptorParser.parseDocument(deploymentUnit, streamReader, result, moduleLoader);
            parseResult = result;
        }
        catch (Throwable throwable) {
            try {
                DeploymentStructureDescriptorParser.safeClose(streamReader);
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw new DeploymentUnitProcessingException("Error loading jboss-structure.xml from " + file.getPath(), e);
            }
        }
        DeploymentStructureDescriptorParser.safeClose(streamReader);
        return parseResult;
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void safeClose(XMLStreamReader streamReader) {
        if (streamReader != null) {
            try {
                streamReader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }

    private static XMLStreamException unexpectedContent(XMLStreamReader reader) {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity declaration";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation declaration";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        StringBuilder b = new StringBuilder("Unexpected content of type '").append(kind).append('\'');
        if (reader.hasName()) {
            b.append(" named '").append(reader.getName()).append('\'');
        }
        if (reader.hasText()) {
            b.append(", text is: '").append(reader.getText()).append('\'');
        }
        return new XMLStreamException(b.toString(), reader.getLocation());
    }

    private static XMLStreamException endOfDocument(Location location) {
        return new XMLStreamException("Unexpected end of document", location);
    }

    private static XMLStreamException missingAttributes(Location location, Set<Attribute> required) {
        StringBuilder b = new StringBuilder("Missing one or more required attributes:");
        for (Attribute attribute : required) {
            b.append(' ').append((Object)attribute);
        }
        return new XMLStreamException(b.toString(), location);
    }

    private static void parseDocument(DeploymentUnit deploymentUnit, XMLStreamReader reader, ParseResult result, ModuleLoader moduleLoader) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 7: {
                    DeploymentStructureDescriptorParser.parseRootElement(deploymentUnit, reader, result, moduleLoader);
                    return;
                }
                case 1: {
                    if (Element.of(reader.getName()) != Element.JBOSS_DEPLOYMENT_STRUCTURE) {
                        throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                    }
                    DeploymentStructureDescriptorParser.parseStructureContents(deploymentUnit, reader, result, moduleLoader);
                    DeploymentStructureDescriptorParser.parseEndDocument(reader);
                    return;
                }
            }
            throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
        }
        throw DeploymentStructureDescriptorParser.endOfDocument(reader.getLocation());
    }

    private static void parseRootElement(DeploymentUnit deploymentUnit, XMLStreamReader reader, ParseResult result, ModuleLoader moduleLoader) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    if (Element.of(reader.getName()) != Element.JBOSS_DEPLOYMENT_STRUCTURE) {
                        throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                    }
                    DeploymentStructureDescriptorParser.parseStructureContents(deploymentUnit, reader, result, moduleLoader);
                    DeploymentStructureDescriptorParser.parseEndDocument(reader);
                    return;
                }
            }
            throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
        }
        throw DeploymentStructureDescriptorParser.endOfDocument(reader.getLocation());
    }

    private static void parseStructureContents(DeploymentUnit deploymentUnit, XMLStreamReader reader, ParseResult result, ModuleLoader moduleLoader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        if (count != 0) {
            throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
        }
        boolean deploymentVisited = false;
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case EAR_SUBDEPLOYMENTS_ISOLATED: {
                            String value = reader.getElementText();
                            if (value == null || value.isEmpty()) {
                                result.earSubDeploymentsIsolated = true;
                                continue block10;
                            }
                            result.earSubDeploymentsIsolated = Boolean.valueOf(value);
                            continue block10;
                        }
                        case DEPLOYMENT: {
                            if (deploymentVisited) {
                                throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                            }
                            deploymentVisited = true;
                            DeploymentStructureDescriptorParser.parseDeployment(deploymentUnit, reader, result, moduleLoader);
                            continue block10;
                        }
                        case SUB_DEPLOYMENT: {
                            DeploymentStructureDescriptorParser.parseSubDeployment(deploymentUnit, reader, result, moduleLoader);
                            continue block10;
                        }
                        case MODULE: {
                            DeploymentStructureDescriptorParser.parseModule(deploymentUnit, reader, result, moduleLoader);
                            continue block10;
                        }
                    }
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
            throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
        }
        throw DeploymentStructureDescriptorParser.endOfDocument(reader.getLocation());
    }

    private static void parseDeployment(DeploymentUnit deploymentUnit, XMLStreamReader reader, ParseResult result, ModuleLoader moduleLoader) throws XMLStreamException {
        result.rootDeploymentSpecification = new ModuleStructureSpec();
        DeploymentStructureDescriptorParser.parseModuleStructureSpec(deploymentUnit, reader, result.rootDeploymentSpecification, moduleLoader);
    }

    private static void parseSubDeployment(DeploymentUnit deploymentUnit, XMLStreamReader reader, ParseResult result, ModuleLoader moduleLoader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw DeploymentStructureDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        if (result.subDeploymentSpecifications.containsKey(name)) {
            throw new XMLStreamException("Sub deployment " + name + " is listed twice in jboss-structure.xml");
        }
        ModuleStructureSpec moduleSpecification = new ModuleStructureSpec();
        result.subDeploymentSpecifications.put(name, moduleSpecification);
        DeploymentStructureDescriptorParser.parseModuleStructureSpec(deploymentUnit, reader, moduleSpecification, moduleLoader);
    }

    private static void parseModule(DeploymentUnit deploymentUnit, XMLStreamReader reader, ParseResult result, ModuleLoader moduleLoader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        String slot = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw DeploymentStructureDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        if (!name.startsWith("deployment.")) {
            throw new XMLStreamException("Additional module name " + name + " is not valid. Names must start with 'deployment.'");
        }
        ModuleStructureSpec moduleSpecification = new ModuleStructureSpec();
        moduleSpecification.setModuleIdentifier(ModuleIdentifier.create((String)name, slot));
        result.additionalModules.add(moduleSpecification);
        DeploymentStructureDescriptorParser.parseModuleStructureSpec(deploymentUnit, reader, moduleSpecification, moduleLoader);
    }

    private static void parseModuleStructureSpec(DeploymentUnit deploymentUnit, XMLStreamReader reader, ModuleStructureSpec moduleSpec, ModuleLoader moduleLoader) throws XMLStreamException {
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (visited.contains((Object)element)) {
                        throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case EXPORTS: {
                            DeploymentStructureDescriptorParser.parseFilterList(reader, moduleSpec.getExportFilters());
                            continue block11;
                        }
                        case DEPENDENCIES: {
                            DeploymentStructureDescriptorParser.parseDependencies(reader, moduleSpec, moduleLoader);
                            continue block11;
                        }
                        case RESOURCES: {
                            DeploymentStructureDescriptorParser.parseResources(deploymentUnit, reader, moduleSpec);
                            continue block11;
                        }
                        case TRANSFORMERS: {
                            DeploymentStructureDescriptorParser.parseTransformers(reader, moduleSpec);
                            continue block11;
                        }
                        case EXCLUSIONS: {
                            DeploymentStructureDescriptorParser.parseExclusions(reader, moduleSpec);
                            continue block11;
                        }
                    }
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
            throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
        }
        throw DeploymentStructureDescriptorParser.endOfDocument(reader.getLocation());
    }

    private static void parseDependencies(XMLStreamReader reader, ModuleStructureSpec specBuilder, ModuleLoader moduleLoader) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case MODULE: {
                            DeploymentStructureDescriptorParser.parseModuleDependency(reader, specBuilder, moduleLoader);
                            continue block7;
                        }
                    }
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
            throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
        }
        throw DeploymentStructureDescriptorParser.endOfDocument(reader.getLocation());
    }

    private static void parseModuleDependency(XMLStreamReader reader, ModuleStructureSpec specBuilder, ModuleLoader moduleLoader) throws XMLStreamException {
        String name = null;
        String slot = null;
        boolean export = false;
        boolean optional = false;
        Disposition services = Disposition.NONE;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block15;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block15;
                }
                case EXPORT: {
                    export = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block15;
                }
                case SERVICES: {
                    services = Disposition.of(reader.getAttributeValue(i));
                    continue block15;
                }
                case OPTIONAL: {
                    optional = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block15;
                }
                default: {
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw DeploymentStructureDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        ModuleDependency dependency = new ModuleDependency(moduleLoader, ModuleIdentifier.create(name, slot), optional, export, services == Disposition.IMPORT);
        specBuilder.addModuleDependency(dependency);
        block16: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (services == Disposition.EXPORT) {
                        dependency.addExportFilter(PathFilters.getMetaInfServicesFilter(), true);
                    }
                    if (export) {
                        dependency.addExportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                        dependency.addExportFilter(PathFilters.getMetaInfFilter(), false);
                    }
                    if (dependency.getImportFilters().isEmpty()) {
                        dependency.addImportFilter(services == Disposition.NONE ? PathFilters.getDefaultImportFilter() : PathFilters.getDefaultImportFilterWithServices(), true);
                    } else {
                        if (services != Disposition.NONE) {
                            dependency.addImportFilter(PathFilters.getMetaInfServicesFilter(), true);
                        }
                        dependency.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                        dependency.addImportFilter(PathFilters.getMetaInfFilter(), false);
                    }
                    specBuilder.addModuleDependency(dependency);
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case EXPORTS: {
                            DeploymentStructureDescriptorParser.parseFilterList(reader, dependency.getExportFilters());
                            continue block16;
                        }
                        case IMPORTS: {
                            DeploymentStructureDescriptorParser.parseFilterList(reader, dependency.getImportFilters());
                            continue block16;
                        }
                    }
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
            throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
        }
    }

    private static void parseResources(DeploymentUnit deploymentUnit, XMLStreamReader reader, ModuleStructureSpec specBuilder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case RESOURCE_ROOT: {
                            DeploymentStructureDescriptorParser.parseResourceRoot(deploymentUnit, reader, specBuilder);
                            continue block7;
                        }
                    }
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
            throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
        }
        throw DeploymentStructureDescriptorParser.endOfDocument(reader.getLocation());
    }

    private static void parseResourceRoot(DeploymentUnit deploymentUnit, XMLStreamReader reader, ModuleStructureSpec specBuilder) throws XMLStreamException {
        String name = null;
        String path = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block13;
                }
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block13;
                }
                default: {
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw DeploymentStructureDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        if (name == null) {
            name = path;
        }
        ArrayList<FilterSpecification> resourceFilters = new ArrayList<FilterSpecification>();
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        if (reader.hasNext()) {
            block5 : switch (reader.nextTag()) {
                case 2: {
                    if (path.startsWith("/")) {
                        throw new XMLStreamException("External resource roots not supported, resource roots may not start with a '/' :" + path);
                    }
                    try {
                        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
                        VirtualFile deploymentRootFile = deploymentRoot.getRoot();
                        VirtualFile child = deploymentRootFile.getChild(path);
                        Closeable closable = child.isFile() ? VFS.mountZip((VirtualFile)child, (VirtualFile)child, (TempFileProvider)TempFileProviderService.provider()) : null;
                        MountHandle mountHandle = new MountHandle(closable);
                        ResourceRoot resourceRoot = new ResourceRoot(name, child, mountHandle);
                        for (FilterSpecification filter : resourceFilters) {
                            resourceRoot.getExportFilters().add(filter);
                        }
                        specBuilder.addResourceRoot(resourceRoot);
                    }
                    catch (IOException e) {
                        throw new XMLStreamException(e);
                    }
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (!encountered.add(element)) {
                        throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                    }
                    switch (element) {
                        case FILTER: {
                            DeploymentStructureDescriptorParser.parseFilterList(reader, resourceFilters);
                            break block5;
                        }
                    }
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
            throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
        }
    }

    private static void parseFilterList(XMLStreamReader reader, List<FilterSpecification> filters) throws XMLStreamException {
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case INCLUDE: {
                            DeploymentStructureDescriptorParser.parsePath(reader, true, filters);
                            continue block10;
                        }
                        case EXCLUDE: {
                            DeploymentStructureDescriptorParser.parsePath(reader, false, filters);
                            continue block10;
                        }
                        case INCLUDE_SET: {
                            DeploymentStructureDescriptorParser.parseSet(reader, true, filters);
                            continue block10;
                        }
                        case EXCLUDE_SET: {
                            DeploymentStructureDescriptorParser.parseSet(reader, false, filters);
                            continue block10;
                        }
                    }
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
            throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
        }
        throw DeploymentStructureDescriptorParser.endOfDocument(reader.getLocation());
    }

    private static void parsePath(XMLStreamReader reader, boolean include, List<FilterSpecification> filters) throws XMLStreamException {
        boolean literal;
        String path = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw DeploymentStructureDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        boolean bl = literal = path.indexOf(42) == -1 && path.indexOf(63) == -1;
        if (literal) {
            if (path.charAt(path.length() - 1) == '/') {
                filters.add(new FilterSpecification(PathFilters.isChildOf((String)path), include));
            } else {
                filters.add(new FilterSpecification(PathFilters.is((String)path), include));
            }
        } else {
            filters.add(new FilterSpecification(PathFilters.match((String)path), include));
        }
        DeploymentStructureDescriptorParser.parseNoContent(reader);
    }

    private static void parseSet(XMLStreamReader reader, boolean include, List<FilterSpecification> filters) throws XMLStreamException {
        HashSet<String> set = new HashSet<String>();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    filters.add(new FilterSpecification(PathFilters.in(set), include));
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case PATH: {
                            DeploymentStructureDescriptorParser.parsePathName(reader, set);
                        }
                    }
                }
            }
        }
    }

    private static void parsePathName(XMLStreamReader reader, Set<String> set) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw DeploymentStructureDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        set.add(name);
        DeploymentStructureDescriptorParser.parseNoContent(reader);
    }

    private static void parseTransformers(XMLStreamReader reader, ModuleStructureSpec moduleSpec) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case TRANSFORMER: {
                            DeploymentStructureDescriptorParser.parseTransformer(reader, moduleSpec.getClassFileTransformers());
                            continue block7;
                        }
                    }
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
            throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
        }
        throw DeploymentStructureDescriptorParser.endOfDocument(reader.getLocation());
    }

    private static void parseTransformer(XMLStreamReader reader, List<String> transformerClassNames) throws XMLStreamException {
        String className = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.CLASS);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CLASS: {
                    className = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw DeploymentStructureDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        transformerClassNames.add(className);
        DeploymentStructureDescriptorParser.parseNoContent(reader);
    }

    private static void parseNoContent(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
            }
            throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
        }
        throw DeploymentStructureDescriptorParser.endOfDocument(reader.getLocation());
    }

    private static void parseEndDocument(XMLStreamReader reader) throws XMLStreamException {
        block5: while (reader.hasNext()) {
            switch (reader.next()) {
                case 8: {
                    return;
                }
                case 4: {
                    if (reader.isWhiteSpace()) continue block5;
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
                case 5: 
                case 6: {
                    continue block5;
                }
            }
            throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
        }
    }

    private static void parseExclusions(XMLStreamReader reader, ModuleStructureSpec specBuilder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case MODULE: {
                            DeploymentStructureDescriptorParser.parseModuleExclusion(reader, specBuilder);
                            continue block7;
                        }
                    }
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
            throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
        }
        throw DeploymentStructureDescriptorParser.endOfDocument(reader.getLocation());
    }

    private static void parseModuleExclusion(XMLStreamReader reader, ModuleStructureSpec specBuilder) throws XMLStreamException {
        String name = null;
        String slot = "main";
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block7;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block7;
                }
                default: {
                    throw DeploymentStructureDescriptorParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw DeploymentStructureDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        specBuilder.getExclusions().add(ModuleIdentifier.create(name, (String)slot));
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
            }
            DeploymentStructureDescriptorParser.unexpectedContent(reader);
        }
    }

    static enum Disposition {
        NONE("none"),
        IMPORT("import"),
        EXPORT("export");

        private static final Map<String, Disposition> values;
        private final String value;

        private Disposition(String value) {
            this.value = value;
        }

        static Disposition of(String value) {
            Disposition disposition = values.get(value);
            return disposition == null ? NONE : disposition;
        }

        static {
            HashMap<String, Disposition> map = new HashMap<String, Disposition>();
            for (Disposition d : Disposition.values()) {
                map.put(d.value, d);
            }
            values = map;
        }
    }

    static enum Attribute {
        NAME,
        SLOT,
        EXPORT,
        SERVICES,
        PATH,
        OPTIONAL,
        CLASS,
        UNKNOWN;

        private static final Map<QName, Attribute> attributes;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName("name"), NAME);
            attributesMap.put(new QName("slot"), SLOT);
            attributesMap.put(new QName("export"), EXPORT);
            attributesMap.put(new QName("services"), SERVICES);
            attributesMap.put(new QName("path"), PATH);
            attributesMap.put(new QName("optional"), OPTIONAL);
            attributesMap.put(new QName("class"), CLASS);
            attributes = attributesMap;
        }
    }

    static enum Element {
        JBOSS_DEPLOYMENT_STRUCTURE,
        EAR_SUBDEPLOYMENTS_ISOLATED,
        DEPLOYMENT,
        SUB_DEPLOYMENT,
        MODULE,
        DEPENDENCIES,
        EXPORTS,
        IMPORTS,
        INCLUDE,
        INCLUDE_SET,
        EXCLUDE,
        EXCLUDE_SET,
        RESOURCES,
        RESOURCE_ROOT,
        PATH,
        FILTER,
        TRANSFORMERS,
        TRANSFORMER,
        EXCLUSIONS,
        UNKNOWN;

        private static final Map<QName, Element> elements;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(DeploymentStructureDescriptorParser.NAMESPACE, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "jboss-deployment-structure"), JBOSS_DEPLOYMENT_STRUCTURE);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "ear-subdeployments-isolated"), EAR_SUBDEPLOYMENTS_ISOLATED);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "deployment"), DEPLOYMENT);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "sub-deployment"), SUB_DEPLOYMENT);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "module"), MODULE);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "dependencies"), DEPENDENCIES);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "resources"), RESOURCES);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "resource-root"), RESOURCE_ROOT);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "path"), PATH);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "exports"), EXPORTS);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "imports"), IMPORTS);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "include"), INCLUDE);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "exclude"), EXCLUDE);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "exclusions"), EXCLUSIONS);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "include-set"), INCLUDE_SET);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "exclude-set"), EXCLUDE_SET);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "filter"), FILTER);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "transformers"), TRANSFORMERS);
            elementsMap.put(new QName(DeploymentStructureDescriptorParser.NAMESPACE, "transformer"), TRANSFORMER);
            elements = elementsMap;
        }
    }

    private static class ParseResult {
        private Boolean earSubDeploymentsIsolated = null;
        private ModuleStructureSpec rootDeploymentSpecification;
        private final Map<String, ModuleStructureSpec> subDeploymentSpecifications = new HashMap<String, ModuleStructureSpec>();
        private final List<ModuleStructureSpec> additionalModules = new ArrayList<ModuleStructureSpec>();

        private ParseResult() {
        }
    }

    private static class ModuleStructureSpec {
        private ModuleIdentifier moduleIdentifier;
        private final List<ModuleDependency> moduleDependencies = new ArrayList<ModuleDependency>();
        private final List<ResourceRoot> resourceRoots = new ArrayList<ResourceRoot>();
        private final List<ExtensionListEntry> moduleExtensionDependencies = new ArrayList<ExtensionListEntry>();
        private final List<FilterSpecification> exportFilters = new ArrayList<FilterSpecification>();
        private final List<ModuleIdentifier> exclusions = new ArrayList<ModuleIdentifier>();
        private final List<String> classFileTransformers = new ArrayList<String>();

        private ModuleStructureSpec() {
        }

        public ModuleIdentifier getModuleIdentifier() {
            return this.moduleIdentifier;
        }

        public void setModuleIdentifier(ModuleIdentifier moduleIdentifier) {
            this.moduleIdentifier = moduleIdentifier;
        }

        public void addModuleDependency(ModuleDependency dependency) {
            this.moduleDependencies.add(dependency);
        }

        public List<ModuleDependency> getModuleDependencies() {
            return Collections.unmodifiableList(this.moduleDependencies);
        }

        public void addResourceRoot(ResourceRoot resourceRoot) {
            this.resourceRoots.add(resourceRoot);
        }

        public List<ResourceRoot> getResourceRoots() {
            return Collections.unmodifiableList(this.resourceRoots);
        }

        public void addModuleExtensionDependency(ExtensionListEntry extension) {
            this.moduleExtensionDependencies.add(extension);
        }

        public List<ExtensionListEntry> getModuleExtensionDependencies() {
            return Collections.unmodifiableList(this.moduleExtensionDependencies);
        }

        public List<ModuleIdentifier> getExclusions() {
            return this.exclusions;
        }

        public List<FilterSpecification> getExportFilters() {
            return this.exportFilters;
        }

        public List<String> getClassFileTransformers() {
            return this.classFileTransformers;
        }
    }
}

