/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt;

import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.domain.http.server.ManagementHttpServer;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class HttpManagementService
implements Service<HttpManagementService> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"serverManagement", "controller", "management", "http"});
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private final InjectedValue<NetworkInterfaceBinding> interfaceBindingValue = new InjectedValue();
    private final InjectedValue<Integer> portValue = new InjectedValue();
    private final InjectedValue<Integer> securePortValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executorServiceValue = new InjectedValue();
    private final InjectedValue<String> tempDirValue = new InjectedValue();
    private final InjectedValue<SecurityRealmService> securityRealmServiceValue = new InjectedValue();
    private InetSocketAddress bindAddress;
    private InetSocketAddress secureBindAddress;
    private ManagementHttpServer serverManagement;
    private ModelControllerClient modelControllerClient;

    public synchronized void start(StartContext context) throws StartException {
        int securePort;
        ModelController modelController = (ModelController)this.modelControllerValue.getValue();
        ExecutorService executorService = (ExecutorService)this.executorServiceValue.getValue();
        NetworkInterfaceBinding interfaceBinding = (NetworkInterfaceBinding)this.interfaceBindingValue.getValue();
        this.modelControllerClient = modelController.createClient((Executor)executorService);
        int port = (Integer)this.portValue.getOptionalValue();
        if (port > 0) {
            this.bindAddress = new InetSocketAddress(interfaceBinding.getAddress(), port);
        }
        if ((securePort = ((Integer)this.securePortValue.getOptionalValue()).intValue()) > 0) {
            this.secureBindAddress = new InetSocketAddress(interfaceBinding.getAddress(), securePort);
        }
        SecurityRealmService securityRealmService = (SecurityRealmService)this.securityRealmServiceValue.getOptionalValue();
        try {
            this.serverManagement = ManagementHttpServer.create((InetSocketAddress)this.bindAddress, (InetSocketAddress)this.secureBindAddress, (int)50, (ModelControllerClient)this.modelControllerClient, (Executor)executorService, (SecurityRealm)securityRealmService);
            this.serverManagement.start();
        }
        catch (BindException e) {
            StringBuilder sb = new StringBuilder().append(e.getMessage());
            if (port > 0) {
                sb.append(" ").append(this.bindAddress);
            }
            if (securePort > 0) {
                sb.append(" ").append(this.secureBindAddress);
            }
            throw new StartException(sb.toString(), (Throwable)e);
        }
        catch (Exception e) {
            throw new StartException("Failed to start serverManagement socket", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        if (this.serverManagement != null) {
            this.serverManagement.stop();
        }
    }

    public HttpManagementService getValue() throws IllegalStateException {
        return this;
    }

    public Injector<NetworkInterfaceBinding> getInterfaceInjector() {
        return this.interfaceBindingValue;
    }

    public Injector<ExecutorService> getExecutorServiceInjector() {
        return this.executorServiceValue;
    }

    public Injector<Integer> getPortInjector() {
        return this.portValue;
    }

    public Injector<Integer> getSecurePortInjector() {
        return this.securePortValue;
    }

    public Injector<ModelController> getModelControllerInjector() {
        return this.modelControllerValue;
    }

    public InjectedValue<String> getTempDirInjector() {
        return this.tempDirValue;
    }

    public InjectedValue<SecurityRealmService> getSecurityRealmInjector() {
        return this.securityRealmServiceValue;
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public InetSocketAddress getSecureBindAddress() {
        return this.secureBindAddress;
    }
}

