/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import java.util.Map;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.ejb.EJBPolicyModuleDelegate;
import org.jboss.security.authorization.modules.ejb.EJBXACMLUtil;
import org.jboss.security.authorization.resources.EJBResource;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.xacml.interfaces.PolicyDecisionPoint;
import org.jboss.security.xacml.interfaces.RequestContext;
import org.jboss.security.xacml.interfaces.ResponseContext;

public class EJBXACMLPolicyModuleDelegate
extends EJBPolicyModuleDelegate {
    private String policyContextID;

    public EJBXACMLPolicyModuleDelegate() {
        log = Logger.getLogger(this.getClass());
        this.trace = log.isTraceEnabled();
    }

    public int authorize(Resource resource, Subject callerSubject, RoleGroup role) {
        if (!(resource instanceof EJBResource)) {
            throw new IllegalArgumentException("resource is not an EJBResource");
        }
        EJBResource ejbResource = (EJBResource)resource;
        Map<String, Object> map = resource.getMap();
        if (map == null) {
            throw new IllegalStateException("Map from the Resource is null");
        }
        this.policyRegistration = (PolicyRegistration)map.get("policyRegistration");
        if (this.policyRegistration == null) {
            throw new IllegalStateException("Policy Registration passed is null");
        }
        this.callerRunAs = ejbResource.getCallerRunAsIdentity();
        this.ejbName = ejbResource.getEjbName();
        this.ejbMethod = ejbResource.getEjbMethod();
        this.ejbPrincipal = ejbResource.getPrincipal();
        this.policyContextID = ejbResource.getPolicyContextID();
        if (this.policyContextID == null) {
            throw new IllegalStateException("Context ID is null");
        }
        this.securityRoleReferences = ejbResource.getSecurityRoleReferences();
        this.roleName = (String)map.get("roleName");
        Boolean roleRefCheck = this.checkBooleanValue((Boolean)map.get("roleRefPermissionCheck"));
        if (roleRefCheck.booleanValue()) {
            return this.checkRoleRef(role);
        }
        return this.process(role);
    }

    private int process(RoleGroup callerRoles) {
        int result = -1;
        EJBXACMLUtil util = new EJBXACMLUtil();
        try {
            RequestContext requestCtx = util.createXACMLRequest(this.ejbName, this.ejbMethod, this.ejbPrincipal, callerRoles);
            PolicyDecisionPoint pdp = util.getPDP(this.policyRegistration, this.policyContextID);
            if (pdp == null) {
                throw new IllegalStateException("PDP is null");
            }
            ResponseContext response = pdp.evaluate(requestCtx);
            result = response.getDecision() == 0 ? 1 : -1;
        }
        catch (Exception e) {
            if (this.trace) {
                log.trace((Object)"Exception in processing:", (Throwable)e);
            }
            result = -1;
        }
        return result;
    }

    private Boolean checkBooleanValue(Boolean bool) {
        if (bool == null) {
            return Boolean.FALSE;
        }
        return bool;
    }
}

