/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.ComponentViewInstance;
import org.jboss.as.ee.component.ProxyInvocationHandler;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.SimpleInterceptorFactoryContext;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

final class ViewService
implements Service<ComponentView> {
    private static final Logger logger = Logger.getLogger(ViewService.class);
    private final InjectedValue<Component> componentInjector = new InjectedValue();
    private final Map<Method, InterceptorFactory> viewInterceptorFactories;
    private final Map<Method, InterceptorFactory> clientInterceptorFactories;
    private final InterceptorFactory viewPostConstruct;
    private final InterceptorFactory viewPreDestroy;
    private final InterceptorFactory clientPostConstruct;
    private final InterceptorFactory clientPreDestroy;
    private final ProxyFactory<?> proxyFactory;
    private final Set<Method> allowedMethods;
    private final Class<?> viewClass;
    private volatile ComponentView view;
    private static InterceptorFactory DESTROY_INTERCEPTOR = new ImmediateInterceptorFactory(new Interceptor(){

        public Object processInvocation(InterceptorContext context) throws Exception {
            ((ComponentViewInstance)context.getPrivateData(ComponentViewInstance.class)).destroy();
            return null;
        }
    });

    ViewService(ViewConfiguration viewConfiguration) {
        this.viewClass = viewConfiguration.getViewClass();
        ProxyFactory<?> proxyFactory = viewConfiguration.getProxyFactory();
        this.proxyFactory = proxyFactory;
        List methods = proxyFactory.getCachedMethods();
        int methodCount = methods.size();
        this.viewPostConstruct = Interceptors.getChainedInterceptorFactory(viewConfiguration.getViewPostConstructInterceptors());
        this.viewPreDestroy = Interceptors.getChainedInterceptorFactory(viewConfiguration.getViewPreDestroyInterceptors());
        this.clientPostConstruct = Interceptors.getChainedInterceptorFactory(viewConfiguration.getClientPostConstructInterceptors());
        this.clientPreDestroy = Interceptors.getChainedInterceptorFactory(viewConfiguration.getClientPreDestroyInterceptors());
        IdentityHashMap<Method, InterceptorFactory> viewInterceptorFactories = new IdentityHashMap<Method, InterceptorFactory>(methodCount);
        IdentityHashMap<Method, InterceptorFactory> clientInterceptorFactories = new IdentityHashMap<Method, InterceptorFactory>(methodCount);
        for (Method method : methods) {
            if (method.getName().equals("finalize") && method.getParameterTypes().length == 0) {
                viewInterceptorFactories.put(method, DESTROY_INTERCEPTOR);
                continue;
            }
            viewInterceptorFactories.put(method, Interceptors.getChainedInterceptorFactory(viewConfiguration.getViewInterceptors(method)));
            clientInterceptorFactories.put(method, Interceptors.getChainedInterceptorFactory(viewConfiguration.getClientInterceptors(method)));
        }
        this.viewInterceptorFactories = viewInterceptorFactories;
        this.clientInterceptorFactories = clientInterceptorFactories;
        this.allowedMethods = Collections.unmodifiableSet(viewInterceptorFactories.keySet());
    }

    public void start(StartContext context) throws StartException {
        this.view = new View();
    }

    public void stop(StopContext context) {
        this.view = null;
    }

    public Injector<Component> getComponentInjector() {
        return this.componentInjector;
    }

    public ComponentView getValue() throws IllegalStateException, IllegalArgumentException {
        return this.view;
    }

    class View
    implements ComponentView {
        private final Component component;

        View() {
            this.component = (Component)ViewService.this.componentInjector.getValue();
        }

        @Override
        public ComponentViewInstance createInstance() {
            return this.createInstance(Collections.<Object, Object>emptyMap());
        }

        @Override
        public ComponentViewInstance createInstance(Map<Object, Object> contextData) {
            SimpleInterceptorFactoryContext factoryContext = new SimpleInterceptorFactoryContext();
            Map viewInterceptorFactories = ViewService.this.viewInterceptorFactories;
            IdentityHashMap<Method, Interceptor> viewEntryPoints = new IdentityHashMap<Method, Interceptor>(viewInterceptorFactories.size());
            factoryContext.getContextData().put(Component.class, this.component);
            factoryContext.getContextData().put(ComponentView.class, this);
            factoryContext.getContextData().putAll(contextData);
            Interceptor postConstructInterceptor = ViewService.this.viewPostConstruct.create((InterceptorFactoryContext)factoryContext);
            for (Method method : viewInterceptorFactories.keySet()) {
                viewEntryPoints.put(method, ((InterceptorFactory)viewInterceptorFactories.get(method)).create((InterceptorFactoryContext)factoryContext));
            }
            Interceptor preDestroyInterceptor = ViewService.this.viewPreDestroy.create((InterceptorFactoryContext)factoryContext);
            ViewInstance instance = new ViewInstance(viewEntryPoints, preDestroyInterceptor);
            try {
                InterceptorContext context = new InterceptorContext();
                context.putPrivateData(ComponentView.class, (Object)this);
                context.putPrivateData(Component.class, (Object)this.component);
                postConstructInterceptor.processInvocation(context);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate component view", e);
            }
            return instance;
        }

        @Override
        public Component getComponent() {
            return this.component;
        }

        @Override
        public Class<?> getProxyClass() {
            return ViewService.this.proxyFactory.defineClass();
        }

        class ViewInstance
        implements ComponentViewInstance {
            private final Map<Method, Interceptor> viewEntryPoints;
            private final Interceptor preDestroyInterceptor;

            ViewInstance(Map<Method, Interceptor> viewEntryPoints, Interceptor preDestroyInterceptor) {
                this.viewEntryPoints = viewEntryPoints;
                this.preDestroyInterceptor = preDestroyInterceptor;
            }

            @Override
            public Component getComponent() {
                return View.this.component;
            }

            @Override
            public Class<?> getViewClass() {
                return ViewService.this.viewClass;
            }

            @Override
            public Object createProxy() {
                SimpleInterceptorFactoryContext factoryContext = new SimpleInterceptorFactoryContext();
                factoryContext.getContextData().put(Component.class, View.this.component);
                factoryContext.getContextData().put(ComponentView.class, View.this);
                factoryContext.getContextData().put(ComponentViewInstance.class, this);
                Map clientInterceptorFactories = ViewService.this.clientInterceptorFactories;
                IdentityHashMap<Method, Interceptor> clientEntryPoints = new IdentityHashMap<Method, Interceptor>(clientInterceptorFactories.size());
                for (Method method : clientInterceptorFactories.keySet()) {
                    clientEntryPoints.put(method, ((InterceptorFactory)clientInterceptorFactories.get(method)).create((InterceptorFactoryContext)factoryContext));
                }
                Interceptor postConstructInterceptor = ViewService.this.clientPostConstruct.create((InterceptorFactoryContext)factoryContext);
                try {
                    Object object = ViewService.this.proxyFactory.newInstance((InvocationHandler)new ProxyInvocationHandler(clientEntryPoints, View.this.component, View.this, this));
                    InterceptorContext interceptorContext = new InterceptorContext();
                    interceptorContext.putPrivateData(ComponentView.class, (Object)View.this);
                    interceptorContext.putPrivateData(ComponentViewInstance.class, (Object)this);
                    interceptorContext.putPrivateData(Component.class, (Object)View.this.component);
                    try {
                        postConstructInterceptor.processInvocation(interceptorContext);
                    }
                    catch (Exception e) {
                        InstantiationException exception = new InstantiationException("Post-construct lifecycle failed");
                        exception.initCause(e);
                        throw exception;
                    }
                    return object;
                }
                catch (InstantiationException e) {
                    InstantiationError error = new InstantiationError(e.getMessage());
                    Throwable cause = e.getCause();
                    if (cause != null) {
                        error.initCause(cause);
                    }
                    throw error;
                }
                catch (IllegalAccessException e) {
                    IllegalAccessError error = new IllegalAccessError(e.getMessage());
                    Throwable cause = e.getCause();
                    if (cause != null) {
                        error.initCause(cause);
                    }
                    throw error;
                }
            }

            @Override
            public Collection<Method> allowedMethods() {
                return ViewService.this.allowedMethods;
            }

            @Override
            public Interceptor getEntryPoint(Method method) throws IllegalArgumentException {
                Interceptor interceptor = this.viewEntryPoints.get(method);
                if (interceptor == null) {
                    throw new IllegalArgumentException("Invalid view entry point " + method);
                }
                return interceptor;
            }

            @Override
            @Deprecated
            public boolean isAsynchronous(Method method) throws IllegalArgumentException {
                return false;
            }

            @Override
            public void destroy() {
                try {
                    InterceptorContext interceptorContext = new InterceptorContext();
                    interceptorContext.putPrivateData(ComponentView.class, (Object)View.this);
                    interceptorContext.putPrivateData(ComponentViewInstance.class, (Object)this);
                    interceptorContext.putPrivateData(Component.class, (Object)View.this.component);
                    this.preDestroyInterceptor.processInvocation(interceptorContext);
                }
                catch (Exception e) {
                    logger.warn((Object)("Exception while invoking pre-destroy interceptor for component class: " + this.getComponent().getComponentClass()), (Throwable)e);
                }
            }
        }
    }
}

