/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.session;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.ejb.AccessTimeout;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.TransactionAttributeType;
import org.jboss.as.ejb3.component.AsyncFutureInterceptor;
import org.jboss.as.ejb3.component.AsyncVoidInterceptor;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.session.SessionBeanComponentCreateService;
import org.jboss.as.ejb3.component.session.SessionBeanComponentInstance;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.ejb3.context.spi.SessionContext;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;

public abstract class SessionBeanComponent
extends EJBComponent
implements org.jboss.ejb3.context.spi.SessionBeanComponent {
    private static final Logger logger = Logger.getLogger(SessionBeanComponent.class);
    static final ServiceName ASYNC_EXECUTOR_SERVICE_NAME = ThreadsServices.EXECUTOR.append(new String[]{"ejb3-async"});
    protected Map<String, AccessTimeout> beanLevelAccessTimeout;
    private final Set<Method> asynchronousMethods;
    protected Executor asyncExecutor;
    protected final Map<Method, InterceptorFactory> timeoutInterceptors;

    protected SessionBeanComponent(SessionBeanComponentCreateService ejbComponentCreateService) {
        super(ejbComponentCreateService);
        this.beanLevelAccessTimeout = ejbComponentCreateService.getBeanAccessTimeout();
        this.asynchronousMethods = null;
        this.timeoutInterceptors = ejbComponentCreateService.getTimeoutInterceptors();
    }

    public <T> T getBusinessObject(SessionContext ctx, Class<T> businessInterface) throws IllegalStateException {
        if (businessInterface == null) {
            throw new IllegalStateException("Business interface type cannot be null");
        }
        return this.createViewInstanceProxy(businessInterface, Collections.<Object, Object>emptyMap());
    }

    protected Serializable getSessionIdOf(SessionContext ctx) {
        return ((SessionBeanComponentInstance.SessionBeanComponentInstanceContext)ctx).getId();
    }

    public EJBLocalObject getEJBLocalObject(SessionContext ctx) throws IllegalStateException {
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.session.SessionBeanComponent.getEJBLocalObject");
    }

    public EJBObject getEJBObject(SessionContext ctx) throws IllegalStateException {
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.session.SessionBeanComponent.getEJBObject");
    }

    public Executor getAsynchronousExecutor() {
        return this.asyncExecutor;
    }

    @Override
    public boolean getRollbackOnly() throws IllegalStateException {
        if (this.getCurrentTransactionAttribute() == TransactionAttributeType.SUPPORTS) {
            throw new IllegalStateException("EJB 3.1 FR 13.6.2.9 getRollbackOnly is not allowed with SUPPORTS attribute");
        }
        return super.getRollbackOnly();
    }

    protected boolean isAsynchronous(Method method) {
        Set<Method> asyncMethods = this.asynchronousMethods;
        if (asyncMethods == null) {
            return false;
        }
        for (Method asyncMethod : asyncMethods) {
            Object[] asyncMethodParams;
            Object[] methodParams;
            if (!method.getName().equals(asyncMethod.getName()) || !Arrays.equals(methodParams = method.getParameterTypes(), asyncMethodParams = asyncMethod.getParameterTypes())) continue;
            return true;
        }
        return false;
    }

    protected Object invokeAsynchronous(Method method, InterceptorContext context) throws Exception {
        if (Void.TYPE.isAssignableFrom(method.getReturnType())) {
            return new AsyncVoidInterceptor(this.getAsynchronousExecutor()).processInvocation(context);
        }
        return new AsyncFutureInterceptor(this.getAsynchronousExecutor()).processInvocation(context);
    }

    protected boolean isInvocationAllowed(Method method) {
        int m = method.getModifiers();
        if (!Modifier.isPublic(m)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Method " + method + " is *not* public"));
            }
            return false;
        }
        if (Modifier.isFinal(m)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Method " + method + " is final"));
            }
            return false;
        }
        if (Modifier.isStatic(m)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Method " + method + " is static"));
            }
            return false;
        }
        if (Modifier.isNative(m)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Method " + method + " is native"));
            }
            return false;
        }
        return true;
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException {
        if (this.getCurrentTransactionAttribute() == TransactionAttributeType.SUPPORTS) {
            throw new IllegalStateException("EJB 3.1 FR 13.6.2.8 setRollbackOnly is not allowed with SUPPORTS attribute");
        }
        super.setRollbackOnly();
    }
}

