/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import java.lang.reflect.Method;
import java.util.Collection;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.EJBMethodIdentifier;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.deployment.processors.dd.AbstractEjbXmlDescriptorProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.MethodsMetaData;
import org.jboss.modules.Module;

public class ExcludeListDDProcessor
extends AbstractEjbXmlDescriptorProcessor<EnterpriseBeanMetaData> {
    private static final Logger logger = Logger.getLogger(ExcludeListDDProcessor.class);

    @Override
    protected Class<EnterpriseBeanMetaData> getMetaDataType() {
        return EnterpriseBeanMetaData.class;
    }

    @Override
    protected void processBeanMetaData(EnterpriseBeanMetaData beanMetaData, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Class ejbClass;
        String ejbName = beanMetaData.getEjbName();
        AssemblyDescriptorMetaData assemblyDescriptor = beanMetaData.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            return;
        }
        ExcludeListMetaData excludeList = assemblyDescriptor.getExcludeListByEjbName(ejbName);
        if (excludeList == null) {
            return;
        }
        MethodsMetaData methods = excludeList.getMethods();
        if (methods == null || methods.isEmpty()) {
            return;
        }
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)moduleDescription.getComponentByName(ejbName);
        try {
            ejbClass = module.getClassLoader().loadClass(beanMetaData.getEjbClass());
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentUnitProcessingException("Could not load EJB class " + beanMetaData.getEjbClass());
        }
        ClassReflectionIndex classReflectionIndex = deploymentReflectionIndex.getClassIndex(ejbClass);
        for (MethodMetaData denyAllMethod : methods) {
            String methodName = denyAllMethod.getMethodName();
            MethodIntf methodIntf = this.getMethodIntf(denyAllMethod);
            if (methodName.equals("*")) {
                if (methodIntf == null) {
                    ejbComponentDescription.applyDenyAllOnAllMethodsOfAllViews();
                    continue;
                }
                ejbComponentDescription.applyDenyAllOnAllMethodsOfViewType(methodIntf);
                continue;
            }
            MethodParametersMetaData methodParams = denyAllMethod.getMethodParams();
            if (methodParams == null || methodParams.isEmpty()) {
                Collection denyAllApplicableMethods = ClassReflectionIndexUtil.findAllMethodsByName((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)classReflectionIndex, (String)methodName);
                if (denyAllApplicableMethods.isEmpty()) {
                    logger.warn((Object)("No method named: " + methodName + " found on EJB: " + ejbName + " while processing exclude-list element in ejb-jar.xml"));
                    continue;
                }
                this.applyDenyAll(ejbComponentDescription, methodIntf, denyAllApplicableMethods);
                continue;
            }
            String[] paramTypes = (String[])methodParams.toArray((Object[])new String[methodParams.size()]);
            Collection denyAllApplicableMethods = ClassReflectionIndexUtil.findMethods((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)classReflectionIndex, (String)methodName, (String[])paramTypes);
            if (denyAllApplicableMethods.isEmpty()) {
                logger.warn((Object)("No method named: " + methodName + " with param types: " + paramTypes + " found on EJB: " + ejbName + " while processing exclude-list element in ejb-jar.xml"));
                continue;
            }
            this.applyDenyAll(ejbComponentDescription, methodIntf, denyAllApplicableMethods);
        }
    }

    private MethodIntf getMethodIntf(MethodMetaData method) {
        MethodInterfaceType methodInterfaceType = method.getMethodIntf();
        if (methodInterfaceType == null) {
            return null;
        }
        switch (methodInterfaceType) {
            case Local: {
                return MethodIntf.LOCAL;
            }
            case Remote: {
                return MethodIntf.REMOTE;
            }
            case Home: {
                return MethodIntf.HOME;
            }
            case LocalHome: {
                return MethodIntf.LOCAL_HOME;
            }
            case ServiceEndpoint: {
                return MethodIntf.SERVICE_ENDPOINT;
            }
            case MessageEndpoint: {
                return MethodIntf.MESSAGE_ENDPOINT;
            }
            case Timer: {
                return MethodIntf.TIMER;
            }
        }
        throw new RuntimeException("Unknown method-intf " + methodInterfaceType + " on method " + method);
    }

    private void applyDenyAll(EJBComponentDescription ejbComponentDescription, MethodIntf viewType, Collection<Method> denyAllApplicableMethods) {
        for (Method denyAllApplicableMethod : denyAllApplicableMethods) {
            EJBMethodIdentifier ejbMethodIdentifier = EJBMethodIdentifier.fromMethod(denyAllApplicableMethod);
            if (viewType == null) {
                ejbComponentDescription.applyDenyAllOnAllViewsForMethod(ejbMethodIdentifier);
                continue;
            }
            ejbComponentDescription.applyDenyAllOnViewTypeForMethod(viewType, ejbMethodIdentifier);
        }
    }
}

