/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInterceptorFactory;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.as.ejb3.security.SecurityContextInterceptor;
import org.jboss.as.security.service.SimpleSecurityManager;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.logging.Logger;

public class SecurityContextInterceptorFactory
extends ComponentInterceptorFactory {
    private static final Logger logger = Logger.getLogger(SecurityContextInterceptorFactory.class);

    protected Interceptor create(Component component, InterceptorFactoryContext context) {
        if (!(component instanceof EJBComponent)) {
            throw new IllegalStateException("Unexpected component type: " + component.getClass() + " expected: " + EJBComponent.class);
        }
        EJBComponent ejbComponent = (EJBComponent)component;
        SimpleSecurityManager securityManager = ejbComponent.getSecurityManager();
        EJBSecurityMetaData securityMetaData = ejbComponent.getSecurityMetaData();
        String securityDomain = securityMetaData.getSecurityDomain();
        if (securityDomain == null) {
            throw new IllegalStateException("EJB " + ejbComponent.getComponentName() + " is enabled for security but doesn't have a security domain set");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Using security domain: " + securityDomain + " for EJB " + ejbComponent.getComponentName()));
        }
        String runAs = securityMetaData.getRunAs();
        String runAsPrincipal = "run-as-principal";
        return new SecurityContextInterceptor(securityManager, securityDomain, runAs, "run-as-principal");
    }
}

