/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.tx;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ejb3.tx.TimerTransactionRolledBackException;
import org.jboss.ejb3.context.spi.InvocationContext;
import org.jboss.ejb3.tx2.impl.CMTTxInterceptor;
import org.jboss.ejb3.tx2.spi.TransactionalInvocationContext;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

public class TimerCMTTxInterceptor
extends CMTTxInterceptor
implements Interceptor {
    private static final ThreadLocal<Throwable> EXCEPTION = new ThreadLocal();

    public Object processInvocation(InterceptorContext invocation) throws Exception {
        return super.invoke((TransactionalInvocationContext)invocation.getPrivateData(InvocationContext.class));
    }

    public void handleExceptionInOurTx(TransactionalInvocationContext invocation, Throwable t, Transaction tx) throws Exception {
        EXCEPTION.set(t);
        super.handleExceptionInOurTx(invocation, t, tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endTransaction(TransactionManager tm, Transaction tx) {
        try {
            boolean rolledBack = false;
            try {
                if (tx.getStatus() == 1) {
                    rolledBack = true;
                }
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
            super.endTransaction(tm, tx);
            if (rolledBack && EXCEPTION.get() == null) {
                throw new TimerTransactionRolledBackException("Timer invocation failed, transaction rolled back");
            }
        }
        finally {
            EXCEPTION.remove();
        }
    }

    private Object processInvocation(TransactionalInvocationContext invocation) throws Exception {
        return this.requiresNew(invocation);
    }
}

