/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jboss.logging.Logger;

class AsynchEventHandler
implements Runnable {
    private String name;
    private BlockingQueue<Object> events = new LinkedBlockingQueue<Object>();
    private boolean blocking;
    private AsynchEventProcessor processor;
    private boolean stopped = true;
    private Thread handlerThread;
    private Logger log;

    public AsynchEventHandler(AsynchEventProcessor processor, String name) {
        this.processor = processor;
        if (name == null) {
            name = "AsynchEventHandler";
        }
        this.name = name;
        this.log = Logger.getLogger((String)(processor.getClass().getName() + "." + name));
    }

    public void queueEvent(Object event) throws InterruptedException {
        if (event != null) {
            this.events.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.log.debug((Object)("Begin " + this.name + " Thread"));
        this.stopped = false;
        boolean intr = false;
        try {
            while (!this.stopped) {
                try {
                    this.blocking = true;
                    Object event = this.events.take();
                    this.blocking = false;
                    if (this.stopped) continue;
                    this.processor.processEvent(event);
                }
                catch (InterruptedException e) {
                    intr = true;
                    this.blocking = false;
                    if (this.stopped) {
                        this.log.debug((Object)(this.name + " Thread interrupted"));
                        break;
                    }
                    this.log.error((Object)(this.name + " Thread interrupted"), (Throwable)e);
                }
                catch (Throwable t) {
                    this.log.error((Object)"Caught Throwable handling asynch events", t);
                }
            }
            this.log.debug((Object)("End " + this.name + " Thread"));
            return;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void start() {
        this.handlerThread = new Thread((Runnable)this, this.name + " Thread");
        this.handlerThread.start();
    }

    public void stop() {
        this.stopped = true;
        if (this.blocking) {
            this.handlerThread.interrupt();
        }
        if (this.handlerThread.isAlive()) {
            try {
                this.handlerThread.join(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.handlerThread.isAlive()) {
            this.handlerThread.interrupt();
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public static interface AsynchEventProcessor {
        public void processEvent(Object var1);
    }
}

