/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import org.infinispan.config.AbstractConfigurationBeanVisitor;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.loaders.decorators.AsyncStoreConfig;

public class TimeoutConfigurationValidatingVisitor
extends AbstractConfigurationBeanVisitor {
    private AsyncStoreConfig asyncType = null;
    private GlobalConfiguration global = null;

    @Override
    public void visitAsyncStoreConfig(AsyncStoreConfig bean) {
        this.asyncType = bean;
    }

    @Override
    public void visitGlobalConfiguration(GlobalConfiguration bean) {
        this.global = bean;
    }

    @Override
    public void visitConfiguration(Configuration bean) {
        boolean nonLocalCache;
        boolean bl = nonLocalCache = bean.getCacheMode() != Configuration.CacheMode.LOCAL && this.global.getTransportClass() != null;
        if (nonLocalCache) {
            if (this.asyncType != null && this.asyncType.getFlushLockTimeout() > this.asyncType.getShutdownTimeout()) {
                this.log.invalidTimeoutValue("<async>: flushLockTimeout ", this.asyncType.getFlushLockTimeout(), "<async>: shutdownTimeout ", this.asyncType.getShutdownTimeout());
            }
            if (this.asyncType != null && this.asyncType.getShutdownTimeout() > (long)bean.getCacheStopTimeout()) {
                this.log.invalidTimeoutValue("<async>: shutdownTimeout ", this.asyncType.getShutdownTimeout(), "<transaction>: cacheStopTimeout ", bean.getCacheStopTimeout());
            }
            if (bean.getDeadlockDetectionSpinDuration() > bean.getLockAcquisitionTimeout()) {
                this.log.invalidTimeoutValue("<deadlockDetection>: spinDuration", bean.getDeadlockDetectionSpinDuration(), "<locking>:lockAcquisitionTimeout ", bean.getLockAcquisitionTimeout());
            }
            if (bean.getLockAcquisitionTimeout() > bean.getSyncReplTimeout()) {
                this.log.invalidTimeoutValue("<locking>:lockAcquisitionTimeout ", bean.getLockAcquisitionTimeout(), "<sync>:replTimeout", bean.getSyncReplTimeout());
            }
            if (bean.getSyncReplTimeout() > this.global.getDistributedSyncTimeout()) {
                this.log.invalidTimeoutValue("<sync>:replTimeout", bean.getSyncReplTimeout(), "<transport>: distributedSyncTimout", this.global.getDistributedSyncTimeout());
            }
            if (this.global.getDistributedSyncTimeout() > bean.getStateRetrievalTimeout()) {
                this.log.invalidTimeoutValue("<transport>: distributedSyncTimout", this.global.getDistributedSyncTimeout(), "<stateRetrieval>:timeout", bean.getStateRetrievalTimeout());
            }
        }
    }
}

