/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.util.Set;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.CacheException;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.InvocationContextFlagsOverride;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionTable;

public class InvocationContextContainerImpl
implements InvocationContextContainer {
    private TransactionManager tm;
    private TransactionTable transactionTable;
    ThreadLocal<InvocationContext> icTl = new ThreadLocal();

    @Inject
    public void init(TransactionManager tm, TransactionTable transactionTable) {
        this.tm = tm;
        this.transactionTable = transactionTable;
    }

    @Override
    public InvocationContext createInvocationContext() {
        return this.createInvocationContext(this.getRunningTx());
    }

    @Override
    public InvocationContext createInvocationContext(Transaction tx) {
        NonTxInvocationContext nonTxContext;
        InvocationContext existing = this.icTl.get();
        if (tx != null) {
            LocalTxInvocationContext localContext;
            if (existing == null || !(existing instanceof LocalTxInvocationContext)) {
                localContext = new LocalTxInvocationContext();
                this.icTl.set(localContext);
            } else {
                localContext = (LocalTxInvocationContext)existing;
            }
            LocalTransaction localTransaction = this.transactionTable.getLocalTransaction(tx);
            localContext.setLocalTransaction(localTransaction);
            localContext.setTransaction(tx);
            return localContext;
        }
        if (existing == null || !(existing instanceof NonTxInvocationContext)) {
            nonTxContext = new NonTxInvocationContext();
            this.icTl.set(nonTxContext);
        } else {
            nonTxContext = (NonTxInvocationContext)existing;
        }
        nonTxContext.setOriginLocal(true);
        return nonTxContext;
    }

    @Override
    public LocalTxInvocationContext createTxInvocationContext() {
        InvocationContext existing = this.icTl.get();
        if (existing != null && existing instanceof LocalTxInvocationContext) {
            return (LocalTxInvocationContext)existing;
        }
        LocalTxInvocationContext localTxContext = new LocalTxInvocationContext();
        this.icTl.set(localTxContext);
        return localTxContext;
    }

    @Override
    public RemoteTxInvocationContext createRemoteTxInvocationContext(Address origin) {
        InvocationContext existing = this.icTl.get();
        if (existing != null && existing instanceof RemoteTxInvocationContext) {
            return (RemoteTxInvocationContext)existing;
        }
        RemoteTxInvocationContext remoteTxContext = new RemoteTxInvocationContext();
        this.icTl.set(remoteTxContext);
        remoteTxContext.setOrigin(origin);
        return remoteTxContext;
    }

    @Override
    public NonTxInvocationContext createNonTxInvocationContext() {
        InvocationContext existing = this.icTl.get();
        if (existing != null && existing instanceof NonTxInvocationContext) {
            NonTxInvocationContext context = (NonTxInvocationContext)existing;
            context.setOriginLocal(true);
            return context;
        }
        NonTxInvocationContext remoteTxContext = new NonTxInvocationContext();
        this.icTl.set(remoteTxContext);
        return remoteTxContext;
    }

    @Override
    public InvocationContext createRemoteInvocationContextForCommand(VisitableCommand cacheCommand, Address origin) {
        FlagAffectedCommand command;
        Set<Flag> flags;
        NonTxInvocationContext context = this.createRemoteInvocationContext(origin);
        if (cacheCommand != null && cacheCommand instanceof FlagAffectedCommand && (flags = (command = (FlagAffectedCommand)((Object)cacheCommand)).getFlags()) != null && !flags.isEmpty()) {
            return new InvocationContextFlagsOverride(context, flags);
        }
        return context;
    }

    @Override
    public NonTxInvocationContext createRemoteInvocationContext(Address origin) {
        InvocationContext existing = this.icTl.get();
        if (existing != null && existing instanceof NonTxInvocationContext) {
            NonTxInvocationContext context = (NonTxInvocationContext)existing;
            context.setOriginLocal(false);
            context.setOrigin(origin);
            return context;
        }
        NonTxInvocationContext remoteNonTxContext = new NonTxInvocationContext();
        remoteNonTxContext.setOriginLocal(false);
        remoteNonTxContext.setOrigin(origin);
        this.icTl.set(remoteNonTxContext);
        return remoteNonTxContext;
    }

    @Override
    public InvocationContext getInvocationContext() {
        InvocationContext invocationContext = this.icTl.get();
        if (invocationContext == null) {
            throw new IllegalStateException("This method can only be called after associating the current thread with a context");
        }
        return invocationContext;
    }

    @Override
    public InvocationContext suspend() {
        InvocationContext invocationContext = this.icTl.get();
        this.icTl.remove();
        return invocationContext;
    }

    @Override
    public void resume(InvocationContext ctxt) {
        if (ctxt != null) {
            this.icTl.set(ctxt);
        }
    }

    private Transaction getRunningTx() {
        try {
            return this.tm == null ? null : this.tm.getTransaction();
        }
        catch (SystemException e) {
            throw new CacheException(e);
        }
    }
}

