/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.control.RehashControlCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.distribution.DistributionManagerImpl;
import org.infinispan.distribution.RehashTask;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashHelper;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Immutables;
import org.infinispan.util.ReadOnlyDataContainerBackedKeySet;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.AggregatingNotifyingFutureImpl;

public class RebalanceTask
extends RehashTask {
    private final InvocationContextContainer icc;
    private final CacheNotifier notifier;
    private final InterceptorChain interceptorChain;
    private final int newViewId;
    private final boolean rehashInterrupted;

    public RebalanceTask(RpcManager rpcManager, CommandsFactory commandsFactory, Configuration conf, DataContainer dataContainer, DistributionManagerImpl dmi, InvocationContextContainer icc, CacheNotifier notifier, InterceptorChain interceptorChain, int newViewId, boolean rehashInterrupted) {
        super(dmi, rpcManager, conf, commandsFactory, dataContainer);
        this.icc = icc;
        this.notifier = notifier;
        this.interceptorChain = interceptorChain;
        this.newViewId = newViewId;
        this.rehashInterrupted = rehashInterrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void performRehash() throws Exception {
        boolean pendingRehash;
        long start = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debugf("Commencing rehash %d on node: %s. Before start, data container had %d entries", this.newViewId, this.getMyAddress(), this.dataContainer.size());
        }
        Set<Address> set = Collections.emptySet();
        Set<Address> set2 = Collections.emptySet();
        ArrayList<Object> keysToRemove = new ArrayList<Object>();
        try {
            if (this.rehashInterrupted) {
                this.log.tracef("Rehash is still in progress, not blocking transactions as they should already be blocked", new Object[0]);
            } else {
                this.distributionManager.getTransactionLogger().blockNewTransactions();
            }
            List<Address> newMembers = this.rpcManager.getTransport().getMembers();
            ConsistentHash chNew = ConsistentHashHelper.createConsistentHash(this.configuration, newMembers);
            ConsistentHash chOld = this.distributionManager.setConsistentHash(chNew);
            if (this.trace) {
                this.log.tracef("Rebalancing: chOld = %s, chNew = %s", chOld, chNew);
            }
            if (this.configuration.isRehashEnabled()) {
                Collection<Address> collection = Immutables.immutableCollectionWrap(chOld.getCaches());
                Collection<Address> collection2 = Immutables.immutableCollectionWrap(chNew.getCaches());
                this.notifier.notifyDataRehashed(collection, collection2, this.newViewId, true);
                int numOwners = this.configuration.getNumOwners();
                HashMap<Address, Map<Object, InternalCacheValue>> states = new HashMap<Address, Map<Object, InternalCacheValue>>();
                for (InternalCacheEntry ice : this.dataContainer) {
                    this.rebalance(ice.getKey(), ice, numOwners, chOld, chNew, null, states, keysToRemove);
                }
                CacheStore cacheStore = this.distributionManager.getCacheStoreForRehashing();
                if (cacheStore != null) {
                    for (Object key : cacheStore.loadAllKeys(new ReadOnlyDataContainerBackedKeySet(this.dataContainer))) {
                        this.rebalance(key, null, numOwners, chOld, chNew, cacheStore, states, keysToRemove);
                    }
                } else if (this.trace) {
                    this.log.trace("No cache store or cache store is shared, not rebalancing stored keys");
                }
                this.pushState(chOld, chNew, states);
            } else if (this.trace) {
                this.log.trace("Rehash not enabled, so not pushing state");
            }
            pendingRehash = false;
        }
        catch (Throwable throwable) {
            boolean pendingRehash2 = false;
            try {
                this.distributionManager.notifyCoordinatorPushCompleted(this.newViewId);
                boolean bl = pendingRehash2 = !this.distributionManager.waitForRehashToComplete(this.newViewId);
                if (this.configuration.isRehashEnabled()) {
                    this.invalidateKeys(keysToRemove);
                    this.notifier.notifyDataRehashed(set, set2, this.newViewId, false);
                }
            }
            finally {
                if (pendingRehash2) {
                    this.log.debugf("Another rehash is pending, keeping the transactions blocked", new Object[0]);
                } else {
                    try {
                        this.distributionManager.getTransactionLogger().unblockNewTransactions();
                    }
                    catch (Exception e) {
                        this.log.debug("Unblocking transactions failed", e);
                    }
                }
            }
            this.log.debugf("Node %s completed rehash for view %d in %s!", this.self, this.newViewId, Util.prettyPrintTime(System.currentTimeMillis() - start));
            throw throwable;
        }
        try {
            this.distributionManager.notifyCoordinatorPushCompleted(this.newViewId);
            boolean bl = pendingRehash = !this.distributionManager.waitForRehashToComplete(this.newViewId);
            if (this.configuration.isRehashEnabled()) {
                void var4_7;
                void var3_4;
                this.invalidateKeys(keysToRemove);
                this.notifier.notifyDataRehashed((Collection<Address>)var3_4, (Collection<Address>)var4_7, this.newViewId, false);
            }
        }
        finally {
            if (pendingRehash) {
                this.log.debugf("Another rehash is pending, keeping the transactions blocked", new Object[0]);
            } else {
                try {
                    this.distributionManager.getTransactionLogger().unblockNewTransactions();
                }
                catch (Exception e) {
                    this.log.debug("Unblocking transactions failed", e);
                }
            }
        }
        this.log.debugf("Node %s completed rehash for view %d in %s!", this.self, this.newViewId, Util.prettyPrintTime(System.currentTimeMillis() - start));
    }

    private void invalidateKeys(List<Object> keysToRemove) {
        try {
            if (keysToRemove.size() > 0) {
                InvalidateCommand invalidateCmd = this.cf.buildInvalidateFromL1Command(true, keysToRemove);
                NonTxInvocationContext ctx = this.icc.createNonTxInvocationContext();
                ctx.setFlags(Flag.CACHE_MODE_LOCAL, Flag.SKIP_LOCKING);
                this.interceptorChain.invoke(ctx, invalidateCmd);
                this.log.debugf("Invalidated %d keys, data container now has %d keys", keysToRemove.size(), this.dataContainer.size());
                this.log.tracef("Invalidated keys: %s", keysToRemove);
            }
        }
        catch (CacheException e) {
            this.log.failedToInvalidateKeys(e);
            throw e;
        }
    }

    private void pushState(ConsistentHash chOld, ConsistentHash chNew, Map<Address, Map<Object, InternalCacheValue>> states) throws InterruptedException, ExecutionException {
        AggregatingNotifyingFutureImpl stateTransferFuture = new AggregatingNotifyingFutureImpl(null, states.size());
        for (Map.Entry<Address, Map<Object, InternalCacheValue>> entry : states.entrySet()) {
            Address target = entry.getKey();
            Map<Object, InternalCacheValue> state = entry.getValue();
            this.log.debugf("Pushing to node %s %d keys", target, state.size());
            this.log.tracef("Pushing to node %s keys: %s", target, state.keySet());
            RehashControlCommand cmd = this.cf.buildRehashControlCommand(RehashControlCommand.Type.APPLY_STATE, this.self, this.newViewId, state, chOld, chNew);
            this.rpcManager.invokeRemotelyInFuture(Collections.singleton(target), cmd, false, stateTransferFuture, this.configuration.getRehashRpcTimeout());
        }
        try {
            stateTransferFuture.get();
        }
        catch (ExecutionException e) {
            this.log.errorTransferringState(e);
            throw e;
        }
        this.log.debugf("Node finished pushing data for rehash %d.", this.newViewId);
    }

    protected void rebalance(Object key, InternalCacheEntry value, int numOwners, ConsistentHash chOld, ConsistentHash chNew, CacheStore cacheStore, Map<Address, Map<Object, InternalCacheValue>> states, List<Object> keysToRemove) {
        List<Address> newOwners;
        List<Address> oldOwners = chOld.locate(key, numOwners);
        if (((Object)oldOwners).equals(newOwners = chNew.locate(key, numOwners))) {
            return;
        }
        Address pushingOwner = null;
        for (int i = oldOwners.size() - 1; i >= 0; --i) {
            Address server = oldOwners.get(i);
            if (!chNew.getCaches().contains(server)) continue;
            pushingOwner = server;
            break;
        }
        if (this.trace) {
            this.log.tracef("Rebalancing key %s from %s to %s, pushing owner is %s", new Object[]{key, oldOwners, newOwners, pushingOwner});
        }
        if (this.self.equals(pushingOwner)) {
            if (value == null) {
                try {
                    value = cacheStore.load(key);
                }
                catch (CacheLoaderException e) {
                    this.log.failedLoadingValueFromCacheStore(key);
                }
            }
            for (Address server : newOwners) {
                if (oldOwners.contains(server)) continue;
                Map<Object, InternalCacheValue> map = states.get(server);
                if (map == null) {
                    map = new HashMap<Object, InternalCacheValue>();
                    states.put(server, map);
                }
                if (value == null) continue;
                map.put(key, value.toInternalCacheValue());
            }
        }
        if (oldOwners.contains(this.self) && !newOwners.contains(this.self)) {
            keysToRemove.add(key);
        }
    }

    public Address getMyAddress() {
        return this.rpcManager != null && this.rpcManager.getTransport() != null ? this.rpcManager.getTransport().getAddress() : null;
    }
}

