/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheException;
import org.infinispan.commands.module.ModuleCommandInitializer;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.factories.BootstrapFactory;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.ScopeDetector;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.ReflectionCache;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.util.ModuleProperties;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ComponentRegistry
extends AbstractComponentRegistry {
    private static final Map<Class, Scopes> componentScopeLookup = new ConcurrentHashMap<Class, Scopes>(1);
    private final GlobalComponentRegistry globalComponents;
    private final String cacheName;
    private static final Log log = LogFactory.getLog(ComponentRegistry.class);
    private CacheManagerNotifier cacheManagerNotifier;

    @Inject
    public void setCacheManagerNotifier(CacheManagerNotifier cacheManagerNotifier) {
        this.cacheManagerNotifier = cacheManagerNotifier;
    }

    public ComponentRegistry(String cacheName, Configuration configuration, AdvancedCache cache, GlobalComponentRegistry globalComponents, ReflectionCache reflectionCache) {
        super(reflectionCache);
        try {
            this.cacheName = cacheName;
            if (cacheName == null) {
                throw new ConfigurationException("Cache name cannot be null!");
            }
            if (globalComponents == null) {
                throw new NullPointerException("GlobalComponentRegistry cannot be null!");
            }
            this.globalComponents = globalComponents;
            this.registerDefaultClassLoader(null);
            this.registerComponent((Object)this, ComponentRegistry.class);
            this.registerComponent((Object)configuration, Configuration.class);
            this.registerComponent((Object)new BootstrapFactory(cache, configuration, this), BootstrapFactory.class);
            Map<Byte, ModuleCommandInitializer> initializers = ModuleProperties.moduleCommandInitializers(null);
            if (initializers != null && !initializers.isEmpty()) {
                this.registerNonVolatileComponent(initializers, "org.infinispan.modules.command.initializers");
                for (ModuleCommandInitializer mci : initializers.values()) {
                    this.registerNonVolatileComponent((Object)mci, mci.getClass());
                }
            } else {
                this.registerNonVolatileComponent(Collections.emptyMap(), "org.infinispan.modules.command.initializers");
            }
        }
        catch (Exception e) {
            throw new CacheException("Unable to construct a ComponentRegistry!", e);
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public final <T> T getComponent(Class<T> componentType, String name) {
        if (this.isGlobal(componentType)) {
            return this.globalComponents.getComponent(componentType, name);
        }
        return this.getLocalComponent(componentType, name);
    }

    public final <T> T getLocalComponent(Class<T> componentType, String name) {
        return super.getComponent(componentType, name);
    }

    public final <T> T getLocalComponent(Class<T> componentType) {
        return this.getLocalComponent(componentType, componentType.getName());
    }

    @Override
    protected final Map<Class, Class<? extends AbstractComponentFactory>> getDefaultFactoryMap() {
        return this.globalComponents.getDefaultFactoryMap();
    }

    @Override
    protected final AbstractComponentRegistry.Component lookupComponent(Class componentClass, String name) {
        if (this.isGlobal(componentClass)) {
            return this.globalComponents.lookupComponent(componentClass, name);
        }
        return this.lookupLocalComponent(componentClass, name);
    }

    protected final AbstractComponentRegistry.Component lookupLocalComponent(Class componentClass, String name) {
        return super.lookupComponent(componentClass, name);
    }

    public final GlobalComponentRegistry getGlobalComponentRegistry() {
        return this.globalComponents;
    }

    @Override
    protected void registerComponentInternal(Object component, String name, boolean nonVolatile) {
        if (this.isGlobal(component.getClass())) {
            this.globalComponents.registerComponentInternal(component, name, nonVolatile);
        } else {
            super.registerComponentInternal(component, name, nonVolatile);
        }
    }

    private boolean isGlobal(Class clazz) {
        Scopes componentScope = componentScopeLookup.get(clazz);
        if (componentScope == null) {
            componentScope = ScopeDetector.detectScope(clazz);
            componentScopeLookup.put(clazz, componentScope);
        }
        return componentScope == Scopes.GLOBAL;
    }

    @Override
    public void start() {
        this.globalComponents.start();
        boolean needToNotify = this.state != ComponentStatus.RUNNING && this.state != ComponentStatus.INITIALIZING;
        this.globalComponents.registerNamedComponentRegistry(this, this.cacheName);
        super.start();
        if (needToNotify && this.state == ComponentStatus.RUNNING) {
            for (ModuleLifecycle l : moduleLifecycles) {
                l.cacheStarted(this, this.cacheName);
            }
            this.cacheManagerNotifier.notifyCacheStarted(this.cacheName);
        }
    }

    void notifyCacheStarting(Configuration configuration) {
        for (ModuleLifecycle l : moduleLifecycles) {
            l.cacheStarting(this, configuration, this.cacheName);
        }
    }

    @Override
    public void stop() {
        boolean needToNotify;
        if (this.state.stopAllowed()) {
            this.globalComponents.unregisterNamedComponentRegistry(this.cacheName);
        }
        boolean bl = needToNotify = this.state == ComponentStatus.RUNNING || this.state == ComponentStatus.INITIALIZING;
        if (needToNotify) {
            for (ModuleLifecycle l : moduleLifecycles) {
                l.cacheStopping(this, this.cacheName);
            }
        }
        super.stop();
        if (this.state == ComponentStatus.TERMINATED && needToNotify) {
            for (ModuleLifecycle l : moduleLifecycles) {
                l.cacheStopped(this, this.cacheName);
            }
            this.cacheManagerNotifier.notifyCacheStopped(this.cacheName);
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }
}

